/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequestBuilder;

class WriteIntentSwitchReplicaRequestDeserializer
implements MessageDeserializer<WriteIntentSwitchReplicaRequest> {
    private final WriteIntentSwitchReplicaRequestBuilder msg;

    WriteIntentSwitchReplicaRequestDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.writeIntentSwitchReplicaRequest();
    }

    @Override
    public Class<WriteIntentSwitchReplicaRequest> klass() {
        return WriteIntentSwitchReplicaRequest.class;
    }

    @Override
    public WriteIntentSwitchReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.writeIntentSwitchReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readSet("tableIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tableIds((Set<Integer>)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(WriteIntentSwitchReplicaRequest.class);
    }
}

