/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.TxMetaMessage;
import org.apache.ignite3.internal.tx.message.TxMetaMessageImpl;

class TxMetaMessageSerializer
implements MessageSerializer<TxMetaMessage> {
    public static final TxMetaMessageSerializer INSTANCE = new TxMetaMessageSerializer();

    private TxMetaMessageSerializer() {
    }

    @Override
    public boolean writeMessage(TxMetaMessage msg, MessageWriter writer) throws MessageMappingException {
        TxMetaMessageImpl message = (TxMetaMessageImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.txMetaMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeList("enlistedPartitions", message.enlistedPartitions(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                int idShifted = message.txState() == null ? 0 : message.txState().id() + 1;
                boolean written = writer.writeInt("txState", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

