/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageResponse;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageResponseBuilder;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;

class TxCleanupMessageResponseDeserializer
implements MessageDeserializer<TxCleanupMessageResponse> {
    private final TxCleanupMessageResponseBuilder msg;

    TxCleanupMessageResponseDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txCleanupMessageResponse();
    }

    @Override
    public Class<TxCleanupMessageResponse> klass() {
        return TxCleanupMessageResponse.class;
    }

    @Override
    public TxCleanupMessageResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txCleanupMessageResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (CleanupReplicatedInfoMessage)reader.readMessage("result");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.result((CleanupReplicatedInfoMessage)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxCleanupMessageResponse.class);
    }
}

