/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TransactionMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMetaAbandoned;
import org.apache.ignite3.internal.tx.TxStateMetaFinishing;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxStateMetaMessage;
import org.apache.ignite3.internal.util.FastTimestamps;
import org.jetbrains.annotations.Nullable;

public class TxStateMeta
implements TransactionMeta {
    private static final long serialVersionUID = 8521181896862227127L;
    private final TxState txState;
    @Nullable
    private final UUID txCoordinatorId;
    @Nullable
    private final ZonePartitionId commitPartitionId;
    @Nullable
    private final HybridTimestamp commitTimestamp;
    @Nullable
    private final Long initialVacuumObservationTimestamp;
    @Nullable
    private final Long cleanupCompletionTimestamp;
    @Nullable
    private final Boolean isFinishedDueToTimeout;
    @Nullable
    private final String txLabel;
    @IgniteToStringExclude
    @Nullable
    private final InternalTransaction tx;

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable ZonePartitionId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable InternalTransaction tx, @Nullable Boolean isFinishedDueToTimeout) {
        this(txState, txCoordinatorId, commitPartitionId, commitTimestamp, tx, null, null, isFinishedDueToTimeout, null);
    }

    public TxStateMeta(TxState txState, @Nullable UUID txCoordinatorId, @Nullable ZonePartitionId commitPartitionId, @Nullable HybridTimestamp commitTimestamp, @Nullable InternalTransaction tx, @Nullable Long initialVacuumObservationTimestamp, @Nullable Long cleanupCompletionTimestamp, @Nullable Boolean isFinishedDueToTimeout, @Nullable String txLabel) {
        this.txState = txState;
        this.txCoordinatorId = txCoordinatorId;
        this.commitPartitionId = commitPartitionId;
        this.commitTimestamp = commitTimestamp;
        this.tx = tx;
        this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
        this.isFinishedDueToTimeout = isFinishedDueToTimeout;
        this.txLabel = txLabel;
        this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp != null ? initialVacuumObservationTimestamp : (TxState.isFinalState(txState) ? Long.valueOf(FastTimestamps.coarseCurrentTimeMillis()) : null);
    }

    @Nullable
    public InternalTransaction tx() {
        return this.tx;
    }

    public TxStateMetaAbandoned abandoned() {
        assert (TxState.checkTransitionCorrectness(this.txState, TxState.ABANDONED)) : "Transaction state is incorrect [txState=" + this.txState + "].";
        return new TxStateMetaAbandoned(this.txCoordinatorId, this.commitPartitionId, this.tx, this.txLabel);
    }

    public TxStateMetaFinishing finishing(boolean isFinishedDueToTimeoutFlag) {
        return new TxStateMetaFinishing(this.txCoordinatorId, this.commitPartitionId, isFinishedDueToTimeoutFlag, this.txLabel);
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    @Nullable
    public UUID txCoordinatorId() {
        return this.txCoordinatorId;
    }

    @Nullable
    public ZonePartitionId commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Nullable
    public Long initialVacuumObservationTimestamp() {
        return this.initialVacuumObservationTimestamp;
    }

    @Nullable
    public Long cleanupCompletionTimestamp() {
        return this.cleanupCompletionTimestamp;
    }

    @Nullable
    public Boolean isFinishedDueToTimeout() {
        return this.isFinishedDueToTimeout;
    }

    @Nullable
    public String txLabel() {
        return this.txLabel;
    }

    @Override
    public TxStateMetaMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        return txMessagesFactory.txStateMetaMessage().txState(this.txState).txCoordinatorId(this.txCoordinatorId).commitPartitionId(this.commitPartitionId == null ? null : ReplicaMessageUtils.toZonePartitionIdMessage(replicaMessagesFactory, this.commitPartitionId)).commitTimestamp(this.commitTimestamp).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp).isFinishedDueToTimeout(this.isFinishedDueToTimeout).txLabel(this.txLabel).build();
    }

    public String toString() {
        return S.toString(TxStateMeta.class, this);
    }

    public static TxStateMetaBuilder builder(TxState txState) {
        return new TxStateMetaBuilder(txState);
    }

    public static TxStateMetaBuilder builder(@Nullable TxStateMeta old, TxState txState) {
        return old == null ? TxStateMeta.builder(txState) : old.mutate().txState(txState);
    }

    public TxStateMetaBuilder mutate() {
        return new TxStateMetaBuilder(this);
    }

    public static class TxStateMetaBuilder {
        protected TxState txState;
        @Nullable
        protected UUID txCoordinatorId;
        @Nullable
        protected ZonePartitionId commitPartitionId;
        @Nullable
        private HybridTimestamp commitTimestamp;
        @Nullable
        private Long initialVacuumObservationTimestamp;
        @Nullable
        private Long cleanupCompletionTimestamp;
        @Nullable
        protected Boolean isFinishedDueToTimeout;
        @Nullable
        protected String txLabel;
        @Nullable
        protected InternalTransaction tx;

        TxStateMetaBuilder(TxState txState) {
            this.txState = txState;
        }

        TxStateMetaBuilder(TxStateMeta old) {
            this.txState = old.txState;
            this.txCoordinatorId = old.txCoordinatorId;
            this.commitPartitionId = old.commitPartitionId;
            this.commitTimestamp = old.commitTimestamp;
            this.initialVacuumObservationTimestamp = old.initialVacuumObservationTimestamp;
            this.cleanupCompletionTimestamp = old.cleanupCompletionTimestamp;
            this.isFinishedDueToTimeout = old.isFinishedDueToTimeout;
            this.txLabel = old.txLabel;
            this.tx = old.tx;
        }

        public TxStateMetaBuilder txState(TxState txState) {
            this.txState = txState;
            return this;
        }

        public TxStateMetaBuilder txCoordinatorId(@Nullable UUID txCoordinatorId) {
            if (txCoordinatorId != null) {
                this.txCoordinatorId = txCoordinatorId;
            }
            return this;
        }

        public TxStateMetaBuilder commitPartitionId(@Nullable ZonePartitionId commitPartitionId) {
            if (commitPartitionId != null) {
                this.commitPartitionId = commitPartitionId;
            }
            return this;
        }

        public TxStateMetaBuilder commitTimestamp(@Nullable HybridTimestamp commitTimestamp) {
            if (commitTimestamp != null) {
                this.commitTimestamp = commitTimestamp;
            }
            return this;
        }

        public TxStateMetaBuilder initialVacuumObservationTimestamp(@Nullable Long initialVacuumObservationTimestamp) {
            this.initialVacuumObservationTimestamp = initialVacuumObservationTimestamp;
            return this;
        }

        public TxStateMetaBuilder cleanupCompletionTimestamp(@Nullable Long cleanupCompletionTimestamp) {
            this.cleanupCompletionTimestamp = cleanupCompletionTimestamp;
            return this;
        }

        public TxStateMetaBuilder finishedDueToTimeout(@Nullable Boolean finishedDueToTimeout) {
            this.isFinishedDueToTimeout = finishedDueToTimeout;
            return this;
        }

        public TxStateMetaBuilder txLabel(@Nullable String txLabel) {
            this.txLabel = txLabel;
            return this;
        }

        public TxStateMetaBuilder tx(@Nullable InternalTransaction tx) {
            this.tx = tx;
            return this;
        }

        public TxStateMeta build() {
            Objects.requireNonNull(this.txState, "txState must not be null");
            if (this.txState == TxState.FINISHING) {
                return new TxStateMetaFinishing(this.txCoordinatorId, this.commitPartitionId, this.isFinishedDueToTimeout, this.txLabel);
            }
            if (this.txState == TxState.ABANDONED) {
                return new TxStateMetaAbandoned(this.txCoordinatorId, this.commitPartitionId, this.tx, this.txLabel);
            }
            return new TxStateMeta(this.txState, this.txCoordinatorId, this.commitPartitionId, this.commitTimestamp, this.tx, this.initialVacuumObservationTimestamp, this.cleanupCompletionTimestamp, this.isFinishedDueToTimeout, this.txLabel);
        }
    }
}

