/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite3.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.partition.HashPartition;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.Partition;
import org.apache.ignite3.table.partition.PartitionManager;

public class HashPartitionManagerImpl
implements PartitionManager {
    private final InternalTable table;
    private final SchemaRegistry schemaReg;
    private final MarshallersProvider marshallers;

    public HashPartitionManagerImpl(InternalTable table, SchemaRegistry schemaReg, MarshallersProvider marshallers) {
        this.table = table;
        this.schemaReg = schemaReg;
        this.marshallers = marshallers;
    }

    @Override
    public CompletableFuture<List<Partition>> partitionsAsync() {
        return CompletableFuture.completedFuture(this.partitions());
    }

    @Override
    public List<Partition> partitions() {
        int partitions = this.table.partitions();
        ArrayList<Partition> list = new ArrayList<Partition>(partitions);
        for (int i = 0; i < partitions; ++i) {
            list.add(new HashPartition(i));
        }
        return list;
    }

    @Override
    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        int partitions = this.table.partitions();
        CompletableFuture[] futures = new CompletableFuture[partitions];
        for (int i = 0; i < partitions; ++i) {
            futures[i] = this.table.partitionLocation(i);
        }
        return CompletableFuture.allOf(futures).thenApply(unused -> {
            HashMap<HashPartition, ClusterNode> result = new HashMap<HashPartition, ClusterNode>(partitions);
            for (int i = 0; i < partitions; ++i) {
                result.put(new HashPartition(i), ((InternalClusterNode)futures[i].join()).toPublicNode());
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<List<Partition>> primaryReplicasAsync(ClusterNode node) {
        return this.primaryReplicasAsync().thenApply(map -> {
            ArrayList<Partition> parts = new ArrayList<Partition>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (!((ClusterNode)entry.getValue()).equals(node)) continue;
                parts.add((Partition)entry.getKey());
            }
            return parts;
        });
    }

    @Override
    public Map<Partition, ClusterNode> primaryReplicas() {
        return ViewUtils.sync(this.primaryReplicasAsync());
    }

    @Override
    public List<Partition> primaryReplicas(ClusterNode node) {
        return ViewUtils.sync(this.primaryReplicasAsync(node));
    }

    @Override
    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.table.partitionLocation(Math.toIntExact(partition.id())).thenApply(InternalClusterNode::toPublicNode);
    }

    @Override
    public ClusterNode primaryReplica(Partition partition) {
        return ViewUtils.sync(this.primaryReplicaAsync(partition));
    }

    @Override
    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mapper);
        SchemaDescriptor schema = this.schemaReg.lastKnownSchema();
        Column valCol = CollectionUtils.first(schema.valueColumns());
        assert (valCol != null);
        KvMarshallerImpl<K, Void> marshaller = new KvMarshallerImpl<K, Void>(schema, this.marshallers, mapper, Mapper.of(Void.class, valCol.name()));
        Row keyRow = marshaller.marshal(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId(keyRow)));
    }

    @Override
    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        Objects.requireNonNull(key);
        Row keyRow = new TupleMarshallerImpl(this.table::name, this.schemaReg.lastKnownSchema()).marshalKey(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId(keyRow)));
    }

    @Override
    public <K> Partition partition(K key, Mapper<K> mapper) {
        return ViewUtils.sync(this.partitionAsync(key, mapper));
    }

    @Override
    public Partition partition(Tuple key) {
        return ViewUtils.sync(this.partitionAsync(key));
    }
}

