/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.message;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.table.message.PartitionModificationInfoMessage;
import org.apache.ignite3.internal.table.message.PartitionModificationInfoMessageBuilder;
import org.apache.ignite3.internal.table.message.PartitionModificationInfoMessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class PartitionModificationInfoMessageImpl
implements PartitionModificationInfoMessage,
Cloneable {
    public static final short GROUP_TYPE = 17;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final long estimatedSize;
    @IgniteToStringInclude
    private final long lastModificationCounter;
    @IgniteToStringInclude
    private final int partId;
    @IgniteToStringInclude
    private final int tableId;

    private PartitionModificationInfoMessageImpl(long estimatedSize, long lastModificationCounter, int partId, int tableId) {
        this.estimatedSize = estimatedSize;
        this.lastModificationCounter = lastModificationCounter;
        this.partId = partId;
        this.tableId = tableId;
    }

    @Override
    public long estimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public long lastModificationCounter() {
        return this.lastModificationCounter;
    }

    @Override
    public int partId() {
        return this.partId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return PartitionModificationInfoMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 17;
    }

    public String toString() {
        return S.toString(PartitionModificationInfoMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionModificationInfoMessageImpl otherMessage = (PartitionModificationInfoMessageImpl)other;
        return this.estimatedSize == otherMessage.estimatedSize && this.lastModificationCounter == otherMessage.lastModificationCounter && this.partId == otherMessage.partId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.estimatedSize, this.lastModificationCounter, this.partId, this.tableId);
        return result;
    }

    @Override
    public PartitionModificationInfoMessageImpl clone() {
        try {
            return (PartitionModificationInfoMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PartitionModificationInfoMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements PartitionModificationInfoMessageBuilder {
        private long estimatedSize;
        private long lastModificationCounter;
        private int partId;
        private int tableId;

        private Builder() {
        }

        @Override
        public PartitionModificationInfoMessageBuilder estimatedSize(long estimatedSize) {
            this.estimatedSize = estimatedSize;
            return this;
        }

        @Override
        public PartitionModificationInfoMessageBuilder lastModificationCounter(long lastModificationCounter) {
            this.lastModificationCounter = lastModificationCounter;
            return this;
        }

        @Override
        public PartitionModificationInfoMessageBuilder partId(int partId) {
            this.partId = partId;
            return this;
        }

        @Override
        public PartitionModificationInfoMessageBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public long estimatedSize() {
            return this.estimatedSize;
        }

        @Override
        public long lastModificationCounter() {
            return this.lastModificationCounter;
        }

        @Override
        public int partId() {
            return this.partId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public PartitionModificationInfoMessage build() {
            return new PartitionModificationInfoMessageImpl(this.estimatedSize, this.lastModificationCounter, this.partId, this.tableId);
        }

        @Override
        public PartitionModificationInfoMessage buildDeserialized() {
            return new PartitionModificationInfoMessageImpl(this.estimatedSize, this.lastModificationCounter, this.partId, this.tableId);
        }
    }
}

