/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator.secondary;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryRequest;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryRequestSender;
import org.apache.ignite3.internal.continuousquery.ContinuousQueryScanResultWithSchema;
import org.apache.ignite3.internal.placementdriver.ReplicaMeta;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

class ReplicaServiceWrapper
implements ContinuousQueryRequestSender<BinaryRow, SchemaDescriptor> {
    private static final int REQUEST_RETRY_COUNT = 5;
    private final int partitionId;
    private final InternalTable internalTable;
    private final ReplicaService replicaService;
    private final IgniteSpinBusyLock lock;

    ReplicaServiceWrapper(int partitionId, InternalTable internalTable, ReplicaService replicaService, IgniteSpinBusyLock lock) {
        this.partitionId = partitionId;
        this.internalTable = internalTable;
        this.replicaService = replicaService;
        this.lock = lock;
    }

    <R> CompletableFuture<R> invokeWithRetry(Function<ReplicaMeta, ReplicaRequest> requestFactory) {
        return IgniteUtils.inBusyLockAsync(this.lock, () -> this.invokeWithRetry(5, requestFactory));
    }

    private <R> CompletableFuture<R> invokeWithRetry(int retryCount, Function<ReplicaMeta, ReplicaRequest> requestFactory) {
        return this.internalTable.secondaryPartitionLocation(this.partitionId).thenCompose(meta -> IgniteUtils.inBusyLockAsync(this.lock, () -> {
            String primaryReplicaName = meta.getLeaseholder();
            assert (primaryReplicaName != null);
            return ((CompletableFuture)this.replicaService.invoke(primaryReplicaName, (ReplicaRequest)requestFactory.apply((ReplicaMeta)meta)).handle((response, e) -> this.handleResponse((Object)response, (Throwable)e, retryCount, requestFactory))).thenCompose(Function.identity());
        }));
    }

    private <R> CompletableFuture<R> handleResponse(@Nullable R response, @Nullable Throwable error, int retryCount, Function<ReplicaMeta, ReplicaRequest> requestFactory) {
        if (error == null) {
            return CompletableFuture.completedFuture(response);
        }
        if (ExceptionUtils.hasCause(error, ReplicationTimeoutException.class) && retryCount != 0) {
            return this.invokeWithRetry(retryCount - 1, requestFactory);
        }
        return CompletableFuture.failedFuture(error);
    }

    @Override
    public CompletableFuture<ContinuousQueryScanResultWithSchema<BinaryRow, SchemaDescriptor>> sendContinuousQueryRequest(ContinuousQueryRequest request) {
        return this.internalTable.sendContinuousQueryRequest(request);
    }
}

