/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator.handlers;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite3.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite3.internal.util.CompletableFutures;

public class BuildIndexReplicaRequestHandler {
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final IndexMetaStorage indexMetaStorage;
    private final ReplicationRaftCommandApplicator commandApplicator;

    public BuildIndexReplicaRequestHandler(IndexMetaStorage indexMetaStorage, ReplicationRaftCommandApplicator commandApplicator) {
        this.indexMetaStorage = indexMetaStorage;
        this.commandApplicator = commandApplicator;
    }

    public CompletableFuture<?> handle(BuildIndexReplicaRequest request) {
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(request.indexId());
        if (indexMeta == null || indexMeta.isDropped()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MetaIndexStatusChange buildingChangeInfo = indexMeta.statusChange(MetaIndexStatus.BUILDING);
        return this.commandApplicator.applyCommand(BuildIndexReplicaRequestHandler.toBuildIndexCommand(request, buildingChangeInfo));
    }

    private static BuildIndexCommand toBuildIndexCommand(BuildIndexReplicaRequest request, MetaIndexStatusChange buildingChangeInfo) {
        return PARTITION_REPLICATION_MESSAGES_FACTORY.buildIndexCommandV3().indexId(request.indexId()).tableId(request.tableId()).rowIds(request.rowIds()).finish(request.finish()).abortedTransactionIds(Objects.requireNonNullElse(request.abortedTransactionIds(), Set.of())).requiredCatalogVersion(buildingChangeInfo.catalogVersion()).build();
    }
}

