/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.table.distributed.disaster.ManualGroupRestartRequest;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

class ManualGroupRestartRequestSerializer
extends VersionedSerializer<ManualGroupRestartRequest> {
    private static final int UNDEFINED_TABLE_ID = -1;
    static final ManualGroupRestartRequestSerializer INSTANCE = new ManualGroupRestartRequestSerializer();

    ManualGroupRestartRequestSerializer() {
    }

    @Override
    protected byte getProtocolVersion() {
        return 3;
    }

    @Override
    protected void writeExternalData(ManualGroupRestartRequest request, IgniteDataOutput out) throws IOException {
        Objects.requireNonNull(request.coordinator(), "Coordinator must not be null");
        out.writeUuid(request.operationId());
        out.writeVarInt(request.zoneId());
        out.writeVarInt(-1L);
        ManualGroupRestartRequestSerializer.writeVarIntSet(request.partitionIds(), out);
        ManualGroupRestartRequestSerializer.writeStringSet(request.nodeNames(), out);
        HybridTimestamp.hybridTimestamp(request.assignmentsTimestamp()).writeTo(out);
        out.writeBoolean(request.cleanUp());
        out.writeUTF(request.coordinator());
    }

    @Override
    protected ManualGroupRestartRequest readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID operationId = in.readUuid();
        int zoneId = in.readVarIntAsInt();
        in.readVarIntAsInt();
        Set<Integer> partitionIds = ManualGroupRestartRequestSerializer.readVarIntSet(in);
        Set<String> nodeNames = ManualGroupRestartRequestSerializer.readStringSet(in);
        HybridTimestamp assignmentsTimestamp = HybridTimestamp.readFrom(in);
        boolean cleanUp = false;
        if (protoVer >= 2) {
            cleanUp = in.readBoolean();
        }
        String coordinator = ManualGroupRestartRequestSerializer.readCoordinator(protoVer, in);
        return new ManualGroupRestartRequest(operationId, zoneId, partitionIds, nodeNames, assignmentsTimestamp.longValue(), cleanUp, coordinator);
    }

    @Nullable
    private static String readCoordinator(byte protoVer, IgniteDataInput in) throws IOException {
        return protoVer >= 3 ? in.readUTF() : null;
    }
}

