/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.jetbrains.annotations.TestOnly;

public abstract class TxContext {
    protected final UUID txId;
    protected final UUID coordinatorId;

    public static TxContext readOnly(UUID txId, UUID txCoordinatorId, HybridTimestamp readTimestamp) {
        return new ReadOnly(txId, txCoordinatorId, readTimestamp);
    }

    @TestOnly
    public static TxContext readOnly(InternalTransaction tx) {
        assert (tx.isReadOnly());
        HybridTimestamp readTimestamp = tx.readTimestamp();
        assert (readTimestamp != null);
        return new ReadOnly(tx.id(), tx.coordinatorId(), readTimestamp);
    }

    public static TxContext readWrite(UUID txId, UUID txCoordinatorId, ZonePartitionId commitPartition, long enlistmentConsistencyToken) {
        return new ReadWrite(txId, txCoordinatorId, commitPartition, enlistmentConsistencyToken);
    }

    @TestOnly
    public static TxContext readWrite(InternalTransaction tx, long enlistmentConsistencyToken) {
        assert (!tx.isReadOnly());
        return new ReadWrite(tx.id(), tx.coordinatorId(), tx.commitPartition(), enlistmentConsistencyToken);
    }

    protected TxContext(UUID txId, UUID coordinatorId) {
        Objects.requireNonNull(txId, "Transaction id is mandatory");
        Objects.requireNonNull(coordinatorId, "Transaction coordinator id is mandatory");
        this.txId = txId;
        this.coordinatorId = coordinatorId;
    }

    public abstract boolean isReadOnly();

    public UUID txId() {
        return this.txId;
    }

    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    public static class ReadOnly
    extends TxContext {
        private final HybridTimestamp readTimestamp;

        private ReadOnly(UUID txId, UUID txCoordinatorId, HybridTimestamp readTimestamp) {
            super(txId, txCoordinatorId);
            this.readTimestamp = readTimestamp;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadOnly txCtx = (ReadOnly)o;
            return Objects.equals(this.txId, txCtx.txId) && Objects.equals(this.coordinatorId, txCtx.coordinatorId) && Objects.equals(this.readTimestamp, txCtx.readTimestamp);
        }

        public int hashCode() {
            return Objects.hash(this.txId);
        }

        public String toString() {
            return IgniteToStringBuilder.toString(this);
        }
    }

    public static class ReadWrite
    extends TxContext {
        private final ZonePartitionId commitPartition;
        private final long enlistmentConsistencyToken;

        private ReadWrite(UUID txId, UUID txCoordinatorId, ZonePartitionId commitPartition, long enlistmentConsistencyToken) {
            super(txId, txCoordinatorId);
            Objects.requireNonNull(commitPartition, "Commit partition is mandatory for RW transaction");
            if (enlistmentConsistencyToken < 0L) {
                throw new IllegalArgumentException("Consistency token partition is mandatory for RW transaction");
            }
            this.commitPartition = commitPartition;
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadWrite opCtx = (ReadWrite)o;
            return this.enlistmentConsistencyToken == opCtx.enlistmentConsistencyToken && Objects.equals(this.txId, opCtx.txId) && Objects.equals(this.coordinatorId, opCtx.coordinatorId) && Objects.equals(this.commitPartition, opCtx.commitPartition);
        }

        public ZonePartitionId commitPartition() {
            return this.commitPartition;
        }

        public HybridTimestamp beginTimestamp() {
            return TransactionIds.beginTimestamp(this.txId);
        }

        public long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        public int hashCode() {
            return Objects.hash(this.txId);
        }

        public String toString() {
            return IgniteToStringBuilder.toString(this);
        }
    }
}

