/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallerSchema;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.marshaller.TupleReader;
import org.apache.ignite3.internal.nearcache.EmbeddedNearCacheKeyImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite3.internal.schema.marshaller.reflection.RecordMarshallerImpl;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.streamer.StreamerBatchSender;
import org.apache.ignite3.internal.table.AbstractTableView;
import org.apache.ignite3.internal.table.DataStreamer;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.PojoStreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.table.criteria.SqlRowProjection;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Pair;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.table.ContinuousQueryOptions;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.TableRowEventBatch;
import org.apache.ignite3.table.TableRowEventType;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheRecordRowEventSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class RecordViewImpl<R>
extends AbstractTableView<R>
implements RecordView<R>,
NearCacheEntriesProvider<R, R, BinaryRowEx> {
    private final Mapper<R> mapper;
    private final Function<SchemaDescriptor, RecordMarshaller<R>> marshallerFactory;
    @Nullable
    private volatile RecordMarshaller<R> marsh;

    public RecordViewImpl(InternalTable tbl, SchemaRegistry schemaRegistry, SchemaVersions schemaVersions, IgniteSql sql, MarshallersProvider marshallers, Mapper<R> mapper) {
        super(tbl, schemaVersions, schemaRegistry, sql, marshallers);
        this.mapper = mapper;
        this.marshallerFactory = schema -> new RecordMarshallerImpl((SchemaDescriptor)schema, marshallers, mapper);
    }

    @Override
    public R get(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    @Override
    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, "keyRecs", "key");
        return this.doOperation(tx, schemaVersion -> this.tbl.getAll(this.marshalKeys(keyRecs, schemaVersion), (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, false, schemaVersion, true)));
    }

    @Override
    public boolean contains(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.containsAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(Objects::nonNull);
        });
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> keyRows = this.marshalKeys(keys, schemaVersion);
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                for (BinaryRow row : rows) {
                    if (row != null) continue;
                    return false;
                }
                return true;
            });
        });
    }

    @Override
    public void upsert(@Nullable Transaction tx, R rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(rec, schemaVersion);
            return this.tbl.upsert(keyRow, (InternalTransaction)tx);
        });
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        return this.doOperation(tx, schemaVersion -> this.tbl.upsertAll(this.marshal(recs, schemaVersion), (InternalTransaction)tx));
    }

    @Override
    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(rec, schemaVersion);
            return this.tbl.getAndUpsert(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    @Override
    public boolean insert(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.insertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(rec, schemaVersion);
            return this.tbl.insert(keyRow, (InternalTransaction)tx);
        });
    }

    @Override
    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(recs, schemaVersion);
            return this.tbl.insertAll(rows, (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, false, schemaVersion, false));
        });
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx newRow = this.marshal(rec, schemaVersion);
            return this.tbl.replace(newRow, (InternalTransaction)tx);
        });
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx oldRow = this.marshal(oldRec, schemaVersion);
            BinaryRowEx newRow = this.marshal(newRec, schemaVersion);
            return this.tbl.replace(oldRow, newRow, (InternalTransaction)tx);
        });
    }

    @Override
    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(rec, schemaVersion);
            return this.tbl.getAndReplace(row, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    @Override
    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.delete(row, (InternalTransaction)tx);
        });
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(keyRec, schemaVersion);
            return this.tbl.deleteExact(row, (InternalTransaction)tx);
        });
    }

    @Override
    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshalKey(keyRec, schemaVersion);
            return this.tbl.getAndDelete(row, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshal((BinaryRow)binaryRow, schemaVersion));
        });
    }

    @Override
    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshalKeys(keyRecs, schemaVersion);
            return this.tbl.deleteAll(rows, (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, true, schemaVersion, false));
        });
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name().toCanonicalForm(), new Object[0]).thenApply(r -> null);
    }

    @Override
    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        Objects.requireNonNull(recs);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(recs, schemaVersion);
            return this.tbl.deleteAllExact(rows, (InternalTransaction)tx).thenApply(binaryRows -> this.unmarshal((Collection<BinaryRow>)binaryRows, true, schemaVersion, false));
        });
    }

    private RecordMarshaller<R> marshaller(int schemaVersion) throws MarshallerException {
        RecordMarshaller<R> marsh = this.marsh;
        if (marsh != null && marsh.schemaVersion() == schemaVersion) {
            return marsh;
        }
        try {
            SchemaDescriptor schema = this.rowConverter.registry().schema(schemaVersion);
            marsh = this.marshallerFactory.apply(schema);
            this.marsh = marsh;
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
        return marsh;
    }

    private BinaryRowEx marshal(R rec, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        return marsh.marshal(rec);
    }

    private Collection<BinaryRowEx> marshal(Collection<R> recs, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        for (R rec : recs) {
            Row row = marsh.marshal(Objects.requireNonNull(rec));
            rows.add(row);
        }
        return rows;
    }

    private Collection<BinaryRowEx> marshal(Collection<R> recs, int schemaVersion, @Nullable BitSet deleted) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        for (R rec : recs) {
            boolean isDeleted = deleted != null && deleted.get(rows.size());
            Row row = isDeleted ? marsh.marshalKey(rec) : marsh.marshal(rec);
            rows.add(row);
        }
        return rows;
    }

    private BinaryRowEx marshalKey(R rec, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        return marsh.marshalKey(rec);
    }

    private Collection<BinaryRowEx> marshalKeys(Collection<R> recs, int schemaVersion) {
        RecordMarshaller<R> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        for (R rec : recs) {
            Row row = marsh.marshalKey(Objects.requireNonNull(rec));
            rows.add(row);
        }
        return rows;
    }

    @Nullable
    private R unmarshal(@Nullable BinaryRow binaryRow, int targetSchemaVersion) {
        if (binaryRow == null) {
            return null;
        }
        Row row = this.rowConverter.resolveRow(binaryRow, targetSchemaVersion);
        RecordMarshaller<R> marshaller = this.marshaller(row.schemaVersion());
        return marshaller.unmarshal(row);
    }

    private List<R> unmarshal(Collection<BinaryRow> rows, boolean keyOnly, int targetSchemaVersion, boolean addNull) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        RecordMarshaller<R> marsh = this.marshaller(targetSchemaVersion);
        ArrayList<R> recs = new ArrayList<R>(rows.size());
        List<Row> resolvedRows = keyOnly ? this.rowConverter.resolveKeys(rows, targetSchemaVersion) : this.rowConverter.resolveRows(rows, targetSchemaVersion);
        for (Row row : resolvedRows) {
            if (row != null) {
                recs.add(marsh.unmarshal(row));
                continue;
            }
            if (!addNull) continue;
            recs.add(null);
        }
        return recs;
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.withSchemaSync(null, schemaVersion -> this.tbl.updateAll(this.marshal(items, schemaVersion, deleted), deleted, (int)partitionId)));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, options, batchSender, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    @Override
    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        StreamerBatchSender batchSender = (partitionIndex, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.tbl.partitionLocation((int)partitionIndex).thenCompose(node -> this.tbl.streamerReceiverRunner().runReceiverAsync(receiver, receiverArg, rows, (InternalClusterNode)node, receiver.units())));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options, batchSender, resultSubscriber, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    private PojoStreamerPartitionAwarenessProvider<R> streamerPartitioner() {
        return new PojoStreamerPartitionAwarenessProvider<R>(this.rowConverter.registry(), this.tbl.partitions(), this.marshaller(this.rowConverter.registry().lastKnownSchemaVersion()));
    }

    @Override
    protected Function<SqlRow, R> queryMapper(ResultSetMetadata meta, SchemaDescriptor schema) {
        MarshallerSchema marshallerSchema = schema.marshallerSchema();
        Marshaller marsh = this.marshallers.getRowMarshaller(marshallerSchema, this.mapper, false, true);
        List<Column> cols = schema.columns();
        return row -> marsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, RecordViewImpl.columnNames(cols))), null);
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        Objects.requireNonNull(subscriber);
        this.tbl.queryContinuously(subscriber, options, (row, schema) -> this.unmarshal((BinaryRow)row, row.schemaVersion()));
    }

    @Override
    public Class<R> valueType() {
        return this.mapper.targetType();
    }

    @Override
    public CompletableFuture<NearCacheKey<R, BinaryRowEx>> getNearCacheKeyAsync(R keyRec, boolean enforceKeyOnly) {
        return this.doOperation(null, schemaVersion -> {
            BinaryRowEx keyRow = this.marshalKey(keyRec, schemaVersion);
            return CompletableFuture.completedFuture(new EmbeddedNearCacheKeyImpl<Object>(keyRec, keyRow));
        });
    }

    @Override
    public CompletableFuture<Collection<NearCacheKey<R, BinaryRowEx>>> getNearCacheKeysAsync(Iterable<? extends R> keys, boolean enforceKeyOnly) {
        return this.doOperation(null, schemaVersion -> {
            ArrayList cacheKeys = new ArrayList();
            for (Object keyRec : keys) {
                BinaryRowEx keyRow = this.marshalKey(keyRec, schemaVersion);
                EmbeddedNearCacheKeyImpl cacheKey = new EmbeddedNearCacheKeyImpl(keyRec, keyRow);
                cacheKeys.add(cacheKey);
            }
            return CompletableFuture.completedFuture(cacheKeys);
        });
    }

    @Override
    public CompletableFuture<Pair<NearCacheKey<R, BinaryRowEx>, NearCacheValue<R>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<R, BinaryRowEx> key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = (BinaryRowEx)key.serializedKey();
            if (keyRow == null || schemaVersion != keyRow.schemaVersion()) {
                keyRow = this.marshalKey(key.key(), schemaVersion);
            }
            EmbeddedNearCacheKeyImpl finalCacheKey = new EmbeddedNearCacheKeyImpl(key.key(), keyRow);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> {
                NearCacheValue<Object> cacheVal;
                if (binaryRow == null) {
                    cacheVal = new NearCacheValue();
                } else {
                    @Nullable R val = this.unmarshal((BinaryRow)binaryRow, schemaVersion);
                    cacheVal = new NearCacheValue<R>(val);
                }
                return new Pair(finalCacheKey, cacheVal);
            });
        });
    }

    @Override
    public CompletableFuture<Map<NearCacheKey<R, BinaryRowEx>, NearCacheValue<R>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<R, BinaryRowEx>> nearCacheKeys) {
        return this.doOperation(tx, schemaVersion -> {
            ArrayList ncKeys = new ArrayList(nearCacheKeys.size());
            ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                BinaryRowEx keyRow = (BinaryRowEx)nearCacheKey.serializedKey();
                if (keyRow == null || schemaVersion != keyRow.schemaVersion()) {
                    keyRow = this.marshalKey(nearCacheKey.key(), schemaVersion);
                }
                keyRows.add(keyRow);
                ncKeys.add(new EmbeddedNearCacheKeyImpl(nearCacheKey.key(), keyRow));
            }
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                assert (rows.size() == keyRows.size());
                LinkedHashMap ret = new LinkedHashMap(rows.size());
                for (int i = 0; i < rows.size(); ++i) {
                    NearCacheValue<Object> cacheVal;
                    BinaryRow binaryRow = (BinaryRow)rows.get(i);
                    if (binaryRow == null) {
                        cacheVal = new NearCacheValue();
                    } else {
                        @Nullable R val = this.unmarshal(binaryRow, schemaVersion);
                        cacheVal = new NearCacheValue<R>(val);
                    }
                    NearCacheKey nearCacheKey = (NearCacheKey)ncKeys.get(i);
                    ret.put(nearCacheKey, cacheVal);
                }
                return ret;
            });
        });
    }

    @Override
    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<R, R>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED).build();
        this.queryContinuously(new NearCacheSchemaVersionAwareSubscriber(new NearCacheRecordRowEventSubscriber(subscriber), () -> this.doOperation(null, CompletableFuture::completedFuture)), opts);
    }

    @Override
    public void close() throws Exception {
    }
}

