/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.rocksdb.PartitionDataHelper;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbTombstonesCursor;
import org.apache.ignite3.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;

class RocksDbTombstonesStorage {
    private static final int TOMBSTONES_KEY_ROW_ID_OFFSET = 6;
    private static final int TOMBSTONES_KEY_TS_OFFSET = 22;
    private static final int TOMBSTONES_KEY_SIZE = 30;
    private static final ThreadLocal<ByteBuffer> TOMBSTONES_KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(30).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
    private static final long BATCH_DELETE_BYTE_LIMIT = 8192L;
    private final ColumnFamilyHandle tombstonesCfHandle;
    private final RocksDbMvPartitionStorage storage;
    private final RocksDB db;

    RocksDbTombstonesStorage(RocksDbMvPartitionStorage storage, RocksDB db, ColumnFamilyHandle tombstonesCfHandle) {
        this.db = db;
        this.storage = storage;
        this.tombstonesCfHandle = tombstonesCfHandle;
    }

    void addToTombstonesStorage(WriteBatchWithIndex writeBatch, RowId rowId, HybridTimestamp timestamp) throws RocksDBException {
        ByteBuffer keyBuffer = TOMBSTONES_KEY_BUFFER.get();
        keyBuffer.clear();
        this.storage.helper().putTombstonesKey(keyBuffer, rowId, timestamp);
        writeBatch.put(this.tombstonesCfHandle, keyBuffer, RocksDbStorageUtils.EMPTY_DIRECT_BUFFER);
    }

    void deleteStorage(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.deleteRange(this.tombstonesCfHandle, this.storage.helper().partitionStartPrefix(), this.storage.helper().partitionEndPrefix());
    }

    public void clear(HybridTimestamp upperBoundExcluding) throws StorageException {
        RocksIterator it = this.db.newIterator(this.tombstonesCfHandle, this.storage.helper().upperBoundReadOpts);
        it.seek(this.storage.helper().partitionStartPrefix());
        while (it.isValid()) {
            this.clearBatch(upperBoundExcluding.longValue(), it);
        }
    }

    private void clearBatch(long upperBoundExcluding, RocksIterator it) {
        this.storage.runConsistently(locker -> {
            Object var6_6;
            WriteBatch writeBatch = new WriteBatch();
            try {
                while (it.isValid() && writeBatch.getDataSize() < 8192L) {
                    ByteBuffer key = RocksDbTombstonesStorage.readTombstonesKey(it);
                    if (RocksDbTombstonesStorage.readTimestampLongDesc(key) < upperBoundExcluding) {
                        writeBatch.delete(this.tombstonesCfHandle, key);
                    }
                    it.next();
                }
                this.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
                var6_6 = null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new StorageException("Clearing snapshot tombstones failed", (Throwable)e);
                }
            }
            writeBatch.close();
            return var6_6;
        });
    }

    public Cursor<Tombstone> find(@Nullable HybridTimestamp from, @Nullable HybridTimestamp to) {
        return new RocksDbTombstonesCursor(this.storage, this.db, this.tombstonesCfHandle, from, to);
    }

    static ByteBuffer readTombstonesKey(RocksIterator tombstonesIt) {
        ByteBuffer tombstonesKeyBuffer = TOMBSTONES_KEY_BUFFER.get();
        tombstonesKeyBuffer.clear();
        tombstonesIt.key(tombstonesKeyBuffer);
        return tombstonesKeyBuffer;
    }

    static long readTimestampLongDesc(ByteBuffer keyBuffer) {
        return PartitionDataHelper.readTimestampLongDesc(keyBuffer, 22);
    }

    static RowId readRowId(ByteBuffer keyBuffer, PartitionDataHelper helper) {
        return helper.getRowId(keyBuffer, 6);
    }
}

