/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateNextWiLinkHandler;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdatePrevWiLinkHandler;
import org.apache.ignite3.internal.storage.pagememory.mv.WriteIntentLinks;

class WriteIntentListSupport {
    WriteIntentListSupport() {
    }

    static void removeNodeFromWriteIntentsList(long linkToRowVersionToRemove, PersistentPageMemoryMvPartitionStorage storage, Supplier<String> operationInfoSupplier) {
        FreeListImpl freeList = storage.renewableState.freeList();
        long wiListHeadLink = storage.lockWriteIntentListHead();
        try {
            WriteIntentLinks links = storage.readWriteIntentLinks(linkToRowVersionToRemove);
            if (links.nextWriteIntentLink() != 0L) {
                freeList.updateDataRow(links.nextWriteIntentLink(), UpdatePrevWiLinkHandler.INSTANCE, links.prevWriteIntentLink());
            }
            if (links.prevWriteIntentLink() != 0L) {
                freeList.updateDataRow(links.prevWriteIntentLink(), UpdateNextWiLinkHandler.INSTANCE, links.nextWriteIntentLink());
            } else {
                wiListHeadLink = links.nextWriteIntentLink();
            }
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error while updating WI links: [link={}, {}]", (Throwable)e, linkToRowVersionToRemove, operationInfoSupplier.get());
        }
        finally {
            storage.updateWriteIntentListHeadAndUnlock(wiListHeadLink);
        }
    }
}

