/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class VersionChain
extends VersionChainKey {
    public static final long NULL_UUID_COMPONENT = 0L;
    private final long headLink;
    private final long nextLink;
    @Nullable
    private final UUID transactionId;
    @Nullable
    private final Integer commitZoneId;
    private final int commitPartitionId;

    private VersionChain(RowId rowId, @Nullable UUID transactionId, @Nullable Integer commitZoneId, int commitPartitionId, long headLink, long nextLink) {
        super(rowId);
        this.transactionId = transactionId;
        this.commitZoneId = commitZoneId;
        this.commitPartitionId = commitPartitionId;
        this.headLink = headLink;
        this.nextLink = nextLink;
    }

    public static VersionChain createCommitted(RowId rowId, long headLink, long nextLink) {
        return new VersionChain(rowId, null, null, -1, headLink, nextLink);
    }

    public static VersionChain createUncommitted(RowId rowId, UUID transactionId, int commitZoneId, int commitPartitionId, long headLink, long nextLink) {
        return new VersionChain(rowId, transactionId, commitZoneId, commitPartitionId, headLink, nextLink);
    }

    @Nullable
    public UUID transactionId() {
        return this.transactionId;
    }

    @Nullable
    public Integer commitZoneId() {
        return this.commitZoneId;
    }

    public int commitPartitionId() {
        return this.commitPartitionId;
    }

    public long headLink() {
        return this.headLink;
    }

    public long nextLink() {
        return this.nextLink;
    }

    public long newestCommittedLink() {
        return this.isUncommitted() ? this.nextLink : this.headLink;
    }

    public boolean isUncommitted() {
        return this.transactionId != null;
    }

    public boolean hasCommittedVersions() {
        return this.newestCommittedLink() != 0L;
    }

    public boolean hasNextLink() {
        return this.nextLink != 0L;
    }

    public boolean hasHeadLink() {
        return this.headLink != 0L;
    }

    public VersionChain withNextLink(long nextLink) {
        return new VersionChain(this.rowId, this.transactionId, this.commitZoneId, this.commitPartitionId, this.headLink, nextLink);
    }

    public String toString() {
        return S.toString(VersionChain.class, this, "rowId", (Object)this.rowId);
    }
}

