/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointListener;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineView;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.AddWriteLinkingWiInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.BlobStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.ConsistentGradualTaskExecutor;
import org.apache.ignite3.internal.storage.pagememory.mv.PageMemoryTombstonesCursor;
import org.apache.ignite3.internal.storage.pagememory.mv.PreloadingForGcInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.ReadWriteIntentLinks;
import org.apache.ignite3.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogTree;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite3.internal.storage.pagememory.mv.WiLinkableRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.WriteIntentLinks;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.TombstonesTree;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io.TombstonesLeafIo;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.storage.util.LocalLocker;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryMvPartitionStorage
extends AbstractPageMemoryMvPartitionStorage {
    private static final int CLEAR_BATCH = 5000;
    private final CheckpointManager checkpointManager;
    private final CheckpointTimeoutLock checkpointTimeoutLock;
    private volatile StoragePartitionMeta meta;
    private final CheckpointListener checkpointListener;
    private volatile BlobStorage blobStorage;
    private final ReadWriteLock replicationProtocolGroupConfigReadWriteLock = new ReentrantReadWriteLock();
    @Nullable
    private volatile LeaseInfo leaseInfo;
    private long wiHeadLink = 0L;
    private final ReentrantLock wiHeadLock = new ReentrantLock();
    private final Object leaseInfoLock = new Object();

    public PersistentPageMemoryMvPartitionStorage(PersistentPageMemoryTableStorage tableStorage, int partitionId, StoragePartitionMeta meta, FreeListImpl freeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, TombstonesTree tombstonesTree, ExecutorService destructionExecutor, UpdateLogTree updateLogTree, FailureProcessor failureProcessor) {
        super(partitionId, tableStorage, new RenewablePartitionStorageState(tableStorage, partitionId, versionChainTree, freeList, indexMetaTree, gcQueue, tombstonesTree), destructionExecutor, updateLogTree, failureProcessor);
        this.checkpointManager = tableStorage.engine().checkpointManager();
        this.checkpointTimeoutLock = this.checkpointManager.checkpointTimeoutLock();
        PersistentPageMemoryDataRegion dataRegion = tableStorage.dataRegion();
        this.meta = meta;
        this.checkpointListener = new CheckpointListener(){

            @Override
            public void beforeCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }

            @Override
            public void onMarkCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }
        };
        this.checkpointManager.addCheckpointListener(this.checkpointListener, dataRegion);
        this.blobStorage = new BlobStorage(freeList, (PageMemory)dataRegion.pageMemory(), tableStorage.getTableId(), partitionId);
        this.leaseInfo = this.leaseInfoFromMeta();
    }

    @Override
    public void start() {
        super.start();
        this.busy(() -> {
            this.wiHeadLink = this.meta.wiHeadLink();
        });
    }

    @Override
    protected GradualTaskExecutor createGradualTaskExecutor(ExecutorService threadPool) {
        return new ConsistentGradualTaskExecutor(this, threadPool);
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        LocalLocker locker = (LocalLocker)THREAD_LOCAL_LOCKER.get();
        if (locker != null) {
            return closure.execute(locker);
        }
        return (V)this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            PersistentPageMemoryLocker locker0 = new PersistentPageMemoryLocker();
            this.checkpointTimeoutLock.checkpointReadLock();
            THREAD_LOCAL_LOCKER.set(locker0);
            try {
                Object v = closure.execute(locker0);
                return v;
            }
            finally {
                THREAD_LOCAL_LOCKER.set(null);
                locker0.unlockAll();
                this.checkpointTimeoutLock.checkpointReadUnlock();
            }
        });
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        return this.busy(() -> {
            CheckpointProgress scheduledCheckpoint;
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
            if (!trigger) {
                scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint(Integer.MAX_VALUE, "subscribe to next checkpoint");
            } else if (lastCheckpoint != null && this.meta.metaSnapshot(lastCheckpoint.id()).lastAppliedIndex() == this.meta.lastAppliedIndex()) {
                scheduledCheckpoint = lastCheckpoint;
            } else {
                PersistentPageMemoryTableStorage persistentTableStorage = (PersistentPageMemoryTableStorage)this.tableStorage;
                PersistentPageMemoryStorageEngineView engineCfg = (PersistentPageMemoryStorageEngineView)persistentTableStorage.engine().configuration().value();
                int checkpointDelayMillis = engineCfg.checkpoint().checkpointDelayMillis();
                scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint(checkpointDelayMillis, "Triggered by replicator");
            }
            return scheduledCheckpoint.futureFor(CheckpointState.FINISHED);
        });
    }

    @Override
    public long lastAppliedIndex() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return this.meta.lastAppliedIndex();
        });
    }

    @Override
    public long lastAppliedTerm() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return this.meta.lastAppliedTerm();
        });
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.lastAppliedBusy(lastAppliedIndex, lastAppliedTerm);
            return null;
        });
    }

    @Override
    public Cursor<Tombstone> scanSnapshotTombstones(HybridTimestamp fromIncluding, HybridTimestamp toIncluding) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            try {
                return new PageMemoryTombstonesCursor(this, this.renewableState.tombstonesTree().find(null, null), fromIncluding, toIncluding);
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Couldn't get tombstones cursor", (Throwable)e);
            }
        });
    }

    @Override
    public boolean snapshotTombstonesPreservationSupported() {
        return true;
    }

    private void lastAppliedBusy(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.updateMeta((lastCheckpointId, meta) -> meta.lastApplied(lastCheckpointId, lastAppliedIndex, lastAppliedTerm));
    }

    private void updateMeta(MetaUpdateClosure closure) {
        assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread());
        CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
        UUID lastCheckpointId = lastCheckpoint == null ? null : lastCheckpoint.id();
        closure.update(lastCheckpointId, this.meta);
        this.checkpointManager.markPartitionAsDirty(this.tableStorage.dataRegion(), this.tableStorage.getTableId(), this.partitionId, this.meta.partitionGeneration());
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            try {
                this.replicationProtocolGroupConfigReadWriteLock.readLock().lock();
                try {
                    long configFirstPageId = this.meta.lastReplicationProtocolGroupConfigFirstPageId();
                    if (configFirstPageId == 0L) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    byte[] byArray = this.blobStorage.readBlob(this.meta.lastReplicationProtocolGroupConfigFirstPageId());
                    return byArray;
                }
                finally {
                    this.replicationProtocolGroupConfigReadWriteLock.readLock().unlock();
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to read group config: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
            }
        });
    }

    @Override
    public void committedGroupConfiguration(byte[] config) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.committedGroupConfigurationBusy(config);
            return null;
        });
    }

    @Override
    public void updateLease(LeaseInfo leaseInfo) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.updateLeaseBusy(leaseInfo);
            return null;
        });
    }

    private void updateLeaseBusy(LeaseInfo leaseInfo) {
        this.updateMeta((lastCheckpointId, meta) -> {
            Object object = this.leaseInfoLock;
            synchronized (object) {
                if (leaseInfo.leaseStartTime() <= meta.leaseStartTime()) {
                    return;
                }
                try {
                    byte[] primaryReplicaNodeNameBytes = ByteUtils.stringToBytes(leaseInfo.primaryReplicaNodeName());
                    if (meta.primaryReplicaNodeNameFirstPageId() == 0L) {
                        long primaryReplicaNodeNameFirstPageId = this.blobStorage.addBlob(primaryReplicaNodeNameBytes);
                        meta.primaryReplicaNodeNameFirstPageId(lastCheckpointId, primaryReplicaNodeNameFirstPageId);
                    } else {
                        this.blobStorage.updateBlob(meta.primaryReplicaNodeNameFirstPageId(), primaryReplicaNodeNameBytes);
                    }
                    meta.primaryReplicaNodeId(lastCheckpointId, leaseInfo.primaryReplicaNodeId());
                    meta.updateLease(lastCheckpointId, leaseInfo.leaseStartTime());
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Cannot save lease meta: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
                }
                this.leaseInfo = leaseInfo;
            }
        });
    }

    long lockWriteIntentListHead() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            this.wiHeadLock.lock();
            return this.wiHeadLink;
        });
    }

    void updateWriteIntentListHeadAndUnlock(long wiHeadLink) {
        try {
            if (wiHeadLink == this.wiHeadLink) {
                return;
            }
            this.busy(() -> {
                StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
                this.wiHeadLink = wiHeadLink;
                this.updateWiHeadBusy(wiHeadLink);
            });
        }
        finally {
            this.wiHeadLock.unlock();
        }
    }

    private void updateWiHeadBusy(long link) {
        this.updateMeta((lastCheckpointId, meta) -> meta.updateWiHead(lastCheckpointId, link));
    }

    boolean writeIntentHeadIsLockedByCurrentThread() {
        return this.wiHeadLock.isHeldByCurrentThread();
    }

    long writeIntentListHead() {
        return this.wiHeadLink;
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.leaseInfo;
        });
    }

    @Nullable
    private LeaseInfo leaseInfoFromMeta() {
        String primaryReplicaNodeName;
        long primaryReplicaNodeNameFirstPageId = this.meta.primaryReplicaNodeNameFirstPageId();
        if (primaryReplicaNodeNameFirstPageId == 0L) {
            return null;
        }
        try {
            primaryReplicaNodeName = ByteUtils.stringFromBytes(this.blobStorage.readBlob(primaryReplicaNodeNameFirstPageId));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to read primary replica node name: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
        }
        return new LeaseInfo(this.meta.leaseStartTime(), this.meta.primaryReplicaNodeId(), primaryReplicaNodeName);
    }

    private void committedGroupConfigurationBusy(byte[] groupConfigBytes) {
        this.updateMeta((lastCheckpointId, meta) -> {
            this.replicationProtocolGroupConfigReadWriteLock.writeLock().lock();
            try {
                if (meta.lastReplicationProtocolGroupConfigFirstPageId() == 0L) {
                    long configPageId = this.blobStorage.addBlob(groupConfigBytes);
                    meta.lastReplicationProtocolGroupConfigFirstPageId(lastCheckpointId, configPageId);
                } else {
                    this.blobStorage.updateBlob(meta.lastReplicationProtocolGroupConfigFirstPageId(), groupConfigBytes);
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot save committed group configuration: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
            }
            finally {
                this.replicationProtocolGroupConfigReadWriteLock.writeLock().unlock();
            }
        });
    }

    @Override
    public void createHashIndex(StorageHashIndexDescriptor indexDescriptor) {
        this.runConsistently(locker -> {
            super.createHashIndex(indexDescriptor);
            return null;
        });
    }

    @Override
    public void createSortedIndex(StorageSortedIndexDescriptor indexDescriptor) {
        this.runConsistently(locker -> {
            super.createSortedIndex(indexDescriptor);
            return null;
        });
    }

    @Override
    protected List<AutoCloseable> getResourcesToClose() {
        List<AutoCloseable> resourcesToClose = super.getResourcesToClose();
        resourcesToClose.add(() -> this.checkpointManager.removeCheckpointListener(this.checkpointListener));
        RenewablePartitionStorageState localState = this.renewableState;
        resourcesToClose.add(localState.freeList()::close);
        resourcesToClose.add(this.blobStorage::close);
        return resourcesToClose;
    }

    private void syncMetadataOnCheckpoint(@Nullable Executor executor) {
        RenewablePartitionStorageState localState = this.renewableState;
        if (executor == null) {
            this.busySafe(() -> this.saveFreeListMetadataBusy(localState));
        } else {
            executor.execute(() -> this.busySafe(() -> this.saveFreeListMetadataBusy(localState)));
        }
    }

    @Override
    public void lastAppliedOnRebalance(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.lastAppliedBusy(lastAppliedIndex, lastAppliedTerm);
    }

    public void updateDataStructures(StoragePartitionMeta meta, FreeListImpl freeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, TombstonesTree tombstonesTree, UpdateLogTree updateLogTree) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.meta = meta;
        this.updateLogTree = updateLogTree;
        this.blobStorage = new BlobStorage(freeList, (PageMemory)this.tableStorage.dataRegion().pageMemory(), this.tableStorage.getTableId(), this.partitionId);
        this.updateRenewableState(versionChainTree, freeList, indexMetaTree, gcQueue, tombstonesTree);
        this.checkpointManager.addCheckpointListener(this.checkpointListener, this.tableStorage.dataRegion());
    }

    @Override
    List<AutoCloseable> getResourcesToCloseOnCleanup() {
        RenewablePartitionStorageState localState = this.renewableState;
        return List.of(() -> this.checkpointManager.removeCheckpointListener(this.checkpointListener), localState.freeList()::close, localState.versionChainTree()::close, localState.indexMetaTree()::close, localState.gcQueue()::close, localState.tombstonesTree()::close, this.updateLogTree::close, this.blobStorage::close);
    }

    @Override
    public void committedGroupConfigurationOnRebalance(byte[] config) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.committedGroupConfigurationBusy(config);
    }

    @Override
    public void updateLeaseOnRebalance(LeaseInfo leaseInfo) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.updateLeaseBusy(leaseInfo);
    }

    private void saveFreeListMetadataBusy(RenewablePartitionStorageState localState) {
        try {
            localState.freeList().saveMetadata();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to save free list metadata: [{}]", (Throwable)e, this.createStorageInfo());
        }
    }

    @Override
    public long estimatedSize() {
        return this.meta.estimatedSize();
    }

    public int pageCount() {
        return this.meta.pageCount();
    }

    @Override
    public void incrementEstimatedSize() {
        this.updateMeta((lastCheckpointId, meta) -> meta.incrementEstimatedSize(lastCheckpointId));
    }

    @Override
    public void decrementEstimatedSize() {
        this.updateMeta((lastCheckpointId, meta) -> meta.decrementEstimatedSize(lastCheckpointId));
    }

    public int emptyDataPageCountInFreeList() {
        return this.renewableState.freeList().emptyDataPages();
    }

    @Override
    public void clearSnapshotTombstones(final HybridTimestamp upperBoundExcluding) {
        Tombstone lowerBound;
        Tombstone nextToProcess = null;
        BplusTree.TreeRowMapClosure<Tombstone, Tombstone, Tombstone> filter = new BplusTree.TreeRowMapClosure<Tombstone, Tombstone, Tombstone>(){

            @Override
            public boolean apply(BplusTree<Tombstone, Tombstone> tree, BplusIo<Tombstone> io, long pageAddr, int idx) {
                TombstonesLeafIo leafIo = (TombstonesLeafIo)io;
                return leafIo.timestampCompareTo(pageAddr, idx, upperBoundExcluding) < 0L;
            }
        };
        while ((nextToProcess = this.runConsistently(arg_0 -> this.lambda$clearSnapshotTombstones$26(filter, lowerBound = nextToProcess, arg_0))) != null) {
        }
    }

    @Nullable
    private Tombstone clearBatch(BplusTree.TreeRowMapClosure<Tombstone, Tombstone, Tombstone> filter, @Nullable Tombstone lowerBound) {
        this.throwExceptionIfStorageNotInRunnableState();
        TombstonesTree tombstoneTree = this.renewableState.tombstonesTree();
        Cursor<Tombstone> tombstones = tombstoneTree.find(lowerBound, null, filter, null);
        try {
            Tombstone tombstone;
            for (int cleared = 0; tombstones.hasNext() && cleared < 5000; ++cleared) {
                tombstoneTree.remove((Tombstone)tombstones.next());
            }
            Tombstone tombstone2 = tombstone = tombstones.hasNext() ? (Tombstone)tombstones.next() : null;
            if (tombstones != null) {
                tombstones.close();
            }
            return tombstone;
        }
        catch (Throwable throwable) {
            try {
                if (tombstones != null) {
                    try {
                        tombstones.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Couldn't clear snapshot tombstone tree", (Throwable)e);
            }
        }
    }

    @Override
    public Cursor<RowId> scanWriteIntents() {
        return this.busy(() -> new WriteIntentsCursor(this.lockWriteIntentListHead()));
    }

    @Override
    AddWriteLinkingWiInvokeClosure newAddWriteInvokeClosure(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId, boolean isArchivation) {
        return new AddWriteLinkingWiInvokeClosure(rowId, row, txId, commitZoneId, commitPartitionId, this, isArchivation);
    }

    WriteIntentLinks readWriteIntentLinks(long rowVersionLink) {
        ReadWriteIntentLinks read = new ReadWriteIntentLinks(this.partitionId);
        try {
            this.rowVersionDataPageReader.traverse(rowVersionLink, read, null);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Write intent links lookup failed: [link={}, {}]", (Throwable)e, rowVersionLink, this.createStorageInfo());
        }
        return read.result();
    }

    @Override
    protected void preloadingForGcIfNeededBusy(GcRowVersion gcRowVersion) {
        RowId rowId = gcRowVersion.getRowId();
        HybridTimestamp timestamp = gcRowVersion.getTimestamp();
        PreloadingForGcInvokeClosure preloadingForGc = new PreloadingForGcInvokeClosure(rowId, timestamp, gcRowVersion.getLink(), this);
        this.lockByRowId.lock(rowId);
        try {
            this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, preloadingForGc);
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause(e);
            throw new StorageException("Error preloading row versions for garbage collection: [rowId={}, rowTimestamp={}, {}]", (Throwable)e, rowId, timestamp, this.createStorageInfo());
        }
        finally {
            this.lockByRowId.unlockAll(rowId);
        }
    }

    private /* synthetic */ Tombstone lambda$clearSnapshotTombstones$26(2 filter, Tombstone lowerBound, MvPartitionStorage.Locker locker) throws StorageException {
        return this.clearBatch(filter, lowerBound);
    }

    @FunctionalInterface
    private static interface MetaUpdateClosure {
        public void update(@Nullable UUID var1, StoragePartitionMeta var2);
    }

    private class WriteIntentsCursor
    implements Cursor<RowId> {
        private final long headLink;
        private long nextLink;

        private WriteIntentsCursor(long headLink) {
            this.headLink = headLink;
            this.nextLink = headLink;
        }

        @Override
        public boolean hasNext() {
            return PersistentPageMemoryMvPartitionStorage.this.busy(() -> this.nextLink != 0L);
        }

        @Override
        public RowId next() {
            return PersistentPageMemoryMvPartitionStorage.this.busy(() -> {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                RowVersion rowVersion = PersistentPageMemoryMvPartitionStorage.this.readRowVersion(this.nextLink, AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
                assert (rowVersion instanceof WiLinkableRowVersion);
                WiLinkableRowVersion linkableRowVersion = (WiLinkableRowVersion)rowVersion;
                this.nextLink = linkableRowVersion.nextWriteIntentLink();
                return linkableRowVersion.requiredRowId();
            });
        }

        @Override
        public void close() {
            PersistentPageMemoryMvPartitionStorage.this.updateWriteIntentListHeadAndUnlock(this.headLink);
        }
    }

    private class PersistentPageMemoryLocker
    extends LocalLocker {
        private PersistentPageMemoryLocker() {
            super(PersistentPageMemoryMvPartitionStorage.this.lockByRowId);
        }

        @Override
        public boolean shouldRelease() {
            return PersistentPageMemoryMvPartitionStorage.this.checkpointTimeoutLock.shouldReleaseReadLock();
        }
    }
}

