/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeList;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.pagememory.util.PageHandler;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.TombstonesTree;
import org.jetbrains.annotations.Nullable;

class CommitWriteInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    private final HybridTimestamp timestamp;
    private final UUID txId;
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final FreeList freeList;
    private final GcQueue gcQueue;
    @Nullable
    private final TombstonesTree tombstonesTree;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    private long linkToWriteIntentToCommit = 0L;
    @Nullable
    private RowVersion toRemove;
    private CommitResult commitResult;
    private long rowLinkForAddToGcQueue = 0L;
    @Nullable
    private RowVersion currentRowVersion;
    @Nullable
    private RowVersion prevRowVersion;

    CommitWriteInvokeClosure(RowId rowId, HybridTimestamp timestamp, UUID txId, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.timestamp = timestamp;
        this.txId = txId;
        this.storage = storage;
        RenewablePartitionStorageState localState = storage.renewableState;
        this.freeList = localState.freeList();
        this.gcQueue = localState.gcQueue();
        this.tombstonesTree = localState.tombstonesTree();
    }

    @Override
    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        boolean isPreviousRowTombstone;
        if (oldRow == null || oldRow.transactionId() == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
            this.commitResult = CommitResult.noWriteIntent();
            return;
        }
        if (!this.txId.equals(oldRow.transactionId())) {
            this.operationType = IgniteTree.OperationType.NOOP;
            this.commitResult = CommitResult.txMismatch(oldRow.transactionId());
            return;
        }
        this.operationType = IgniteTree.OperationType.PUT;
        this.commitResult = CommitResult.success();
        this.currentRowVersion = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
        assert (this.currentRowVersion != null) : this.commitWriteInfo() + ", headLink=" + oldRow.headLink();
        RowVersion rowVersion = this.prevRowVersion = oldRow.hasNextLink() ? this.storage.readRowVersion(oldRow.nextLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE) : null;
        if (this.prevRowVersion == null && this.currentRowVersion.isTombstone()) {
            this.operationType = IgniteTree.OperationType.REMOVE;
            return;
        }
        boolean bl = isPreviousRowTombstone = this.prevRowVersion != null && this.prevRowVersion.isTombstone();
        if (isPreviousRowTombstone && this.currentRowVersion.isTombstone()) {
            this.toRemove = this.currentRowVersion;
            this.newRow = VersionChain.createCommitted(this.rowId, this.prevRowVersion.link(), this.prevRowVersion.nextLink());
        } else {
            this.linkToWriteIntentToCommit = this.currentRowVersion.link();
            this.newRow = VersionChain.createCommitted(this.rowId, this.currentRowVersion.link(), this.currentRowVersion.nextLink());
            if (this.currentRowVersion.hasNextLink()) {
                this.rowLinkForAddToGcQueue = this.currentRowVersion.link();
            }
        }
    }

    @Override
    @Nullable
    public VersionChain newRow() {
        assert (this.operationType == IgniteTree.OperationType.PUT == (this.newRow != null)) : this.commitWriteInfo() + ", newRow=" + this.newRow + ", op=" + this.operationType;
        return this.newRow;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null) : this.commitWriteInfo();
        return this.operationType;
    }

    @Override
    public void onUpdate() {
        assert (this.operationType == IgniteTree.OperationType.PUT || this.linkToWriteIntentToCommit == 0L) : this.commitWriteInfo() + ", link=" + this.linkToWriteIntentToCommit + ", op=" + this.operationType;
        if (this.linkToWriteIntentToCommit != 0L) {
            assert (this.currentRowVersion != null);
            assert (!this.currentRowVersion.isCommitted()) : this.commitWriteInfo() + ", currentRowVersion=" + this.currentRowVersion;
            this.currentRowVersion.operations().removeFromWriteIntentsList(this.storage, this::commitWriteInfo);
            PageHandler<HybridTimestamp, Object> updateHandler = this.currentRowVersion.operations().converterToCommittedVersion();
            try {
                this.freeList.updateDataRow(this.linkToWriteIntentToCommit, updateHandler, this.timestamp);
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error while updating committed row version: [link={}, {}]", (Throwable)e, this.linkToWriteIntentToCommit, this.commitWriteInfo());
            }
        }
    }

    void afterCompletion() {
        assert (this.operationType == IgniteTree.OperationType.PUT || this.toRemove == null) : this.commitWriteInfo() + ", toRemove=" + this.toRemove + ", op=" + this.operationType;
        if (this.operationType == IgniteTree.OperationType.NOOP) {
            return;
        }
        assert (this.currentRowVersion != null) : this.commitWriteInfo();
        if (this.toRemove != null) {
            this.storage.removeRowVersion(this.toRemove);
        }
        if (this.operationType == IgniteTree.OperationType.PUT && this.tombstonesTree != null && this.currentRowVersion.isTombstone()) {
            this.tombstonesTree.add(this.rowId, this.timestamp);
        }
        if (this.rowLinkForAddToGcQueue != 0L) {
            this.gcQueue.add(this.rowId, this.timestamp, this.rowLinkForAddToGcQueue);
        }
        if (this.operationType == IgniteTree.OperationType.PUT) {
            if (this.prevRowVersion == null || this.prevRowVersion.isTombstone()) {
                if (!this.currentRowVersion.isTombstone()) {
                    this.storage.incrementEstimatedSize();
                }
            } else if (this.currentRowVersion.isTombstone()) {
                this.storage.decrementEstimatedSize();
            }
        }
    }

    CommitResult commitResult() {
        return this.commitResult;
    }

    private String commitWriteInfo() {
        return this.storage.commitWriteInfo(this.rowId, this.timestamp, this.txId);
    }
}

