/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeList;
import org.apache.ignite3.internal.pagememory.io.DataPageIo;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.util.PageHandler;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.pagememory.mv.AddWriteInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateNextWiLinkHandler;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdatePrevWiLinkHandler;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.storage.pagememory.mv.WiLinkableRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.WriteIntentLinks;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

class AddWriteLinkingWiInvokeClosure
extends AddWriteInvokeClosure {
    private final PersistentPageMemoryMvPartitionStorage persistentStorage;
    private final FreeList freeList;

    AddWriteLinkingWiInvokeClosure(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId, PersistentPageMemoryMvPartitionStorage storage, boolean isArchivation) {
        super(rowId, row, txId, commitZoneId, commitPartitionId, storage, isArchivation);
        this.persistentStorage = storage;
        this.freeList = storage.renewableState.freeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RowVersion insertFirstRowVersion() {
        long wiListHeadLink;
        WiLinkableRowVersion newVersion = this.insertWiLinkableRowVersion(0L);
        long newWiListHeadLink = wiListHeadLink = this.persistentStorage.lockWriteIntentListHead();
        try {
            this.updateWiListLinks(newVersion.link(), new WriteIntentLinks(0L, wiListHeadLink));
            newWiListHeadLink = newVersion.link();
        }
        finally {
            this.persistentStorage.updateWriteIntentListHeadAndUnlock(newWiListHeadLink);
        }
        return newVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RowVersion insertAnotherRowVersion(VersionChain chain, @Nullable RowVersion existingWriteIntent) {
        long wiListHeadLink;
        boolean replacingExistingWriteIntent = chain.isUncommitted();
        assert (replacingExistingWriteIntent == (existingWriteIntent != null));
        WiLinkableRowVersion newVersion = this.insertWiLinkableRowVersion(chain.newestCommittedLink());
        long newWiListHeadLink = wiListHeadLink = this.persistentStorage.lockWriteIntentListHead();
        try {
            WriteIntentLinks newWiLinks = this.newWiLinksForReplacement(existingWriteIntent, wiListHeadLink);
            this.updateWiListLinks(newVersion.link(), newWiLinks);
            if (newWiLinks.prevWriteIntentLink() == 0L) {
                newWiListHeadLink = newVersion.link();
            }
        }
        finally {
            this.persistentStorage.updateWriteIntentListHeadAndUnlock(newWiListHeadLink);
        }
        return newVersion;
    }

    private WriteIntentLinks newWiLinksForReplacement(@Nullable RowVersion existingWriteIntent, long wiListHeadLink) {
        assert (this.persistentStorage.writeIntentHeadIsLockedByCurrentThread());
        if (existingWriteIntent instanceof WiLinkableRowVersion) {
            return this.persistentStorage.readWriteIntentLinks(existingWriteIntent.link());
        }
        return new WriteIntentLinks(0L, wiListHeadLink);
    }

    private WiLinkableRowVersion insertWiLinkableRowVersion(long nextLink) {
        WiLinkableRowVersion rowVersion = new WiLinkableRowVersion(this.rowId, this.storage.partitionId, nextLink, 0L, 0L, this.row, this.isArchivation);
        this.storage.insertRowVersion(rowVersion);
        return rowVersion;
    }

    private void updateWiListLinks(long newRowVersionLink, WriteIntentLinks newWiLinks) {
        assert (this.persistentStorage.writeIntentHeadIsLockedByCurrentThread());
        try {
            this.freeList.updateDataRow(newRowVersionLink, UpdateWiLinksHandler.INSTANCE, newWiLinks);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error while updating WI links: [link={}, {}]", (Throwable)e, newRowVersionLink, this.addWriteInfo());
        }
        if (newWiLinks.prevWriteIntentLink() != 0L) {
            try {
                this.freeList.updateDataRow(newWiLinks.prevWriteIntentLink(), UpdateNextWiLinkHandler.INSTANCE, newRowVersionLink);
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error while updating WI next link of prev WI: [link={}, {}]", (Throwable)e, newWiLinks.prevWriteIntentLink(), this.addWriteInfo());
            }
        }
        if (newWiLinks.nextWriteIntentLink() != 0L) {
            try {
                this.freeList.updateDataRow(newWiLinks.nextWriteIntentLink(), UpdatePrevWiLinkHandler.INSTANCE, newRowVersionLink);
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error while updating WI prev link of next WI: [link={}, {}]", (Throwable)e, newWiLinks.nextWriteIntentLink(), this.addWriteInfo());
            }
        }
    }

    private static class UpdateWiLinksHandler
    implements PageHandler<WriteIntentLinks, Object> {
        private static final UpdateWiLinksHandler INSTANCE = new UpdateWiLinksHandler();

        private UpdateWiLinksHandler() {
        }

        @Override
        public Object run(int groupId, long pageId, long page, long pageAddr, PageIo io, WriteIntentLinks wiLinks, int itemId) {
            DataPageIo dataIo = (DataPageIo)io;
            int payloadOffset = dataIo.getPayloadOffset(pageAddr, itemId, GridUnsafe.pageSize(), 0);
            PartitionlessLinks.writePartitionless(pageAddr + (long)payloadOffset + 29L, wiLinks.prevWriteIntentLink());
            PartitionlessLinks.writePartitionless(pageAddr + (long)payloadOffset + 35L, wiLinks.nextWriteIntentLink());
            return true;
        }
    }
}

