/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.PartitionTimestampCursor;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.RowMeta;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.StorageRebalanceException;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.mv.AbortWriteInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.AddWriteCommittedInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.AddWriteInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.CommitWriteInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.FindRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.IntervalCursor;
import org.apache.ignite3.internal.storage.pagememory.mv.LatestVersionsCursor;
import org.apache.ignite3.internal.storage.pagememory.mv.PageMemoryIndexes;
import org.apache.ignite3.internal.storage.pagememory.mv.ReadRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RemoveWriteOnGcInvokeClosure;
import org.apache.ignite3.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.ScanAllVersionsCursor;
import org.apache.ignite3.internal.storage.pagememory.mv.ScanVersionsCursor;
import org.apache.ignite3.internal.storage.pagememory.mv.TimestampCursor;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogKey;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogTree;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.TombstonesTree;
import org.apache.ignite3.internal.storage.util.LocalLocker;
import org.apache.ignite3.internal.storage.util.LockByRowId;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.CursorUtils;
import org.apache.ignite3.internal.util.HybridTimestampUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.table.TableRowEventType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryMvPartitionStorage
implements MvPartitionStorage {
    static final Predicate<HybridTimestamp> ALWAYS_LOAD_VALUE = timestamp -> true;
    static final Predicate<HybridTimestamp> DONT_LOAD_VALUE = timestamp -> false;
    static final ThreadLocal<LocalLocker> THREAD_LOCAL_LOCKER = new ThreadLocal();
    protected final int partitionId;
    protected final AbstractPageMemoryTableStorage tableStorage;
    final PageMemoryIndexes indexes;
    protected volatile UpdateLogTree updateLogTree;
    final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    final LockByRowId lockByRowId = new LockByRowId();
    final GradualTaskExecutor destructionExecutor;
    final FailureProcessor failureProcessor;
    volatile RenewablePartitionStorageState renewableState;
    protected final DataPageReader rowVersionDataPageReader;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();

    AbstractPageMemoryMvPartitionStorage(int partitionId, AbstractPageMemoryTableStorage tableStorage, RenewablePartitionStorageState renewableState, ExecutorService destructionExecutor, UpdateLogTree updateLogTree, FailureProcessor failureProcessor) {
        this.partitionId = partitionId;
        this.tableStorage = tableStorage;
        this.renewableState = renewableState;
        this.destructionExecutor = this.createGradualTaskExecutor(destructionExecutor);
        this.failureProcessor = failureProcessor;
        this.indexes = new PageMemoryIndexes(this.destructionExecutor, failureProcessor, this::runConsistently);
        this.updateLogTree = updateLogTree;
        Object pageMemory = tableStorage.dataRegion().pageMemory();
        this.rowVersionDataPageReader = new DataPageReader((PageMemory)pageMemory, tableStorage.getTableId());
    }

    protected abstract GradualTaskExecutor createGradualTaskExecutor(ExecutorService var1);

    public void start() {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            RenewablePartitionStorageState localState = this.renewableState;
            try {
                this.indexes.performRecovery(localState.indexMetaTree(), localState.indexStorageFactory(), this.tableStorage.getIndexDescriptorSupplier());
            }
            catch (Exception e) {
                throw new StorageException("Failed to process SQL indexes during partition start: [{}]", (Throwable)e, this.createStorageInfo());
            }
            return null;
        });
    }

    public int partitionId() {
        return this.partitionId;
    }

    public void createHashIndex(StorageHashIndexDescriptor indexDescriptor) {
        this.busy(() -> this.indexes.createHashIndex(indexDescriptor, this.renewableState.indexStorageFactory()));
    }

    public void createSortedIndex(StorageSortedIndexDescriptor indexDescriptor) {
        this.busy(() -> this.indexes.createSortedIndex(indexDescriptor, this.renewableState.indexStorageFactory()));
    }

    void updateRenewableState(VersionChainTree versionChainTree, FreeListImpl freeList, IndexMetaTree indexMetaTree, GcQueue gcQueue, @Nullable TombstonesTree tombstonesTree) {
        RenewablePartitionStorageState newState;
        this.renewableState = newState = new RenewablePartitionStorageState(this.tableStorage, this.partitionId, versionChainTree, freeList, indexMetaTree, gcQueue, tombstonesTree);
        this.indexes.updateDataStructures(newState.indexStorageFactory());
    }

    static boolean rowIsLocked(RowId rowId) {
        LocalLocker locker = THREAD_LOCAL_LOCKER.get();
        return locker != null && locker.isLocked(rowId);
    }

    @Override
    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            if (rowId.partitionId() != this.partitionId) {
                throw new IllegalArgumentException(String.format("RowId partition [%d] is not equal to storage partition [%d].", rowId.partitionId(), this.partitionId));
            }
            return this.findVersionChain(rowId, versionChain -> {
                if (versionChain == null) {
                    return ReadResult.empty(rowId);
                }
                if (AbstractPageMemoryMvPartitionStorage.lookingForLatestVersion(timestamp)) {
                    return this.findLatestRowVersion((VersionChain)versionChain);
                }
                return this.findRowVersionByTimestamp((VersionChain)versionChain, timestamp);
            });
        });
    }

    @Nullable
    private IgniteBiTuple<ReadResult, ReadResult> readCurrentAndPrevious(RowId rowId, HybridTimestamp timestamp, boolean skipRemoved) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.findVersionChain(rowId, versionChain -> {
                if (versionChain == null) {
                    return new IgniteBiTuple<ReadResult, ReadResult>(ReadResult.empty(rowId), ReadResult.empty(rowId));
                }
                return this.findCurrentAndPreviousCommittedRowVersionByTimestamp((VersionChain)versionChain, timestamp, skipRemoved);
            });
        });
    }

    private static boolean lookingForLatestVersion(HybridTimestamp from, HybridTimestamp to) {
        return HybridTimestamp.MIN_VALUE.equals(from) && HybridTimestamp.MAX_VALUE.equals(to);
    }

    private static boolean lookingForLatestVersion(HybridTimestamp timestamp) {
        return HybridTimestamp.MAX_VALUE.equals(timestamp);
    }

    ReadResult findLatestRowVersion(VersionChain versionChain) {
        return this.findLatestRowVersion(versionChain, ALWAYS_LOAD_VALUE);
    }

    private ReadResult findLatestRowVersion(VersionChain versionChain, Predicate<HybridTimestamp> loadValue) {
        RowVersion rowVersion = this.readRowVersion(versionChain.headLink(), loadValue);
        if (versionChain.isUncommitted()) {
            assert (versionChain.transactionId() != null);
            HybridTimestamp newestCommitTs = null;
            if (versionChain.hasCommittedVersions()) {
                long newestCommitLink = versionChain.newestCommittedLink();
                newestCommitTs = this.readRowVersion(newestCommitLink, loadValue).timestamp();
            }
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(versionChain, rowVersion, newestCommitTs);
        }
        return ReadResult.createFromCommitted(versionChain.rowId(), rowVersion.value(), rowVersion.timestamp(), rowVersion.isArchived());
    }

    RowVersion readRowVersion(long rowVersionLink, Predicate<HybridTimestamp> loadValue) {
        ReadRowVersion read = new ReadRowVersion(this.partitionId);
        try {
            this.rowVersionDataPageReader.traverse(rowVersionLink, read, loadValue);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Row version lookup failed: [link={}, {}]", (Throwable)e, rowVersionLink, this.createStorageInfo());
        }
        return read.result();
    }

    @Nullable
    RowVersion findRowVersion(VersionChain versionChain, FindRowVersion.RowVersionFilter filter, boolean loadValueBytes) {
        assert (versionChain.hasHeadLink());
        FindRowVersion findRowVersion = new FindRowVersion(this.partitionId, loadValueBytes);
        try {
            this.rowVersionDataPageReader.traverse(versionChain.headLink(), findRowVersion, filter);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error when looking up row version in version chain: [rowId={}, headLink={}, {}]", (Throwable)e, versionChain.rowId(), versionChain.headLink(), this.createStorageInfo());
        }
        return findRowVersion.getResult();
    }

    ReadResult findRowVersionByTimestamp(VersionChain versionChain, HybridTimestamp timestamp) {
        assert (timestamp != null);
        long headLink = versionChain.headLink();
        if (versionChain.isUncommitted() && !versionChain.hasCommittedVersions()) {
            RowVersion rowVersion = this.readRowVersion(headLink, ALWAYS_LOAD_VALUE);
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(versionChain, rowVersion, null);
        }
        return this.walkVersionChain(versionChain, timestamp);
    }

    ReadResult findRowVersionByTimestamp(VersionChain versionChain, HybridTimestamp from, HybridTimestamp to) {
        assert (from != null);
        assert (to != null);
        long headLink = versionChain.headLink();
        if (versionChain.isUncommitted() && !versionChain.hasCommittedVersions()) {
            RowVersion rowVersion = this.readRowVersion(headLink, ALWAYS_LOAD_VALUE);
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(versionChain, rowVersion, null);
        }
        return this.walkVersionChain(versionChain, from, to);
    }

    @Nullable
    private IgniteBiTuple<ReadResult, ReadResult> findCurrentAndPreviousCommittedRowVersionByTimestamp(VersionChain chain, HybridTimestamp timestamp, boolean skipRemoved) {
        assert (timestamp != null);
        boolean hasWriteIntent = chain.isUncommitted();
        if (hasWriteIntent && !chain.hasCommittedVersions()) {
            return new IgniteBiTuple<ReadResult, ReadResult>(ReadResult.empty(chain.rowId), ReadResult.empty(chain.rowId));
        }
        RowVersion firstCommit = hasWriteIntent ? this.readRowVersion(chain.nextLink(), rowTimestamp -> timestamp.compareTo((HybridTimestamp)rowTimestamp) == 0) : this.readRowVersion(chain.headLink(), rowTimestamp -> timestamp.compareTo((HybridTimestamp)rowTimestamp) >= 0);
        assert (firstCommit.isCommitted());
        assert (firstCommit.timestamp() != null);
        RowVersion curCommit = firstCommit;
        ReadResult readRes = null;
        ReadResult readResPrev = null;
        HybridTimestamp targetTs = timestamp;
        do {
            HybridTimestamp curCommitTimestamp = curCommit.timestamp();
            assert (curCommitTimestamp != null);
            if (targetTs.compareTo(curCommitTimestamp) >= 0) {
                BinaryRow row = curCommit.isTombstone() ? null : curCommit.value();
                ReadResult res = ReadResult.createFromCommitted(chain.rowId(), row, curCommitTimestamp, curCommit.isArchived());
                if (readRes != null) {
                    readResPrev = res;
                    break;
                }
                readRes = res;
                targetTs = HybridTimestamp.hybridTimestamp(timestamp.longValue() - 1L);
                if (res.isEmpty() && skipRemoved) {
                    return null;
                }
            }
            if (!curCommit.hasNextLink()) {
                curCommit = null;
                continue;
            }
            HybridTimestamp targetTs0 = targetTs;
            curCommit = this.readRowVersion(curCommit.nextLink(), rowTimestamp -> targetTs0.compareTo((HybridTimestamp)rowTimestamp) >= 0);
        } while (curCommit != null);
        return new IgniteBiTuple<ReadResult, Object>(readRes == null ? ReadResult.empty(chain.rowId) : readRes, (readResPrev == null ? ReadResult.empty(chain.rowId) : readResPrev));
    }

    private ReadResult walkVersionChain(VersionChain chain, HybridTimestamp timestamp) {
        assert (chain.hasCommittedVersions());
        boolean hasWriteIntent = chain.isUncommitted();
        RowVersion firstCommit = hasWriteIntent ? this.readRowVersion(chain.nextLink(), rowTimestamp -> timestamp.compareTo((HybridTimestamp)rowTimestamp) == 0) : this.readRowVersion(chain.headLink(), rowTimestamp -> timestamp.compareTo((HybridTimestamp)rowTimestamp) >= 0);
        assert (firstCommit.isCommitted());
        assert (firstCommit.timestamp() != null);
        if (hasWriteIntent && timestamp.compareTo(firstCommit.timestamp()) > 0) {
            RowVersion rowVersion = this.readRowVersion(chain.headLink(), ALWAYS_LOAD_VALUE);
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(chain, rowVersion, firstCommit.timestamp());
        }
        RowVersion curCommit = firstCommit;
        do {
            assert (curCommit.timestamp() != null);
            int compareResult = timestamp.compareTo(curCommit.timestamp());
            if (compareResult < 0) continue;
            BinaryRow row = curCommit.isTombstone() ? null : curCommit.value();
            return ReadResult.createFromCommitted(chain.rowId(), row, curCommit.timestamp(), curCommit.isArchived());
        } while ((curCommit = !curCommit.hasNextLink() ? null : this.readRowVersion(curCommit.nextLink(), rowTimestamp -> timestamp.compareTo((HybridTimestamp)rowTimestamp) >= 0)) != null);
        return ReadResult.empty(chain.rowId());
    }

    private ReadResult walkVersionChain(VersionChain chain, HybridTimestamp from, HybridTimestamp to) {
        assert (chain.hasCommittedVersions());
        assert (from.compareTo(to) <= 0);
        boolean hasWriteIntent = chain.isUncommitted();
        RowVersion firstCommit = hasWriteIntent ? this.readRowVersion(chain.nextLink(), rowTimestamp -> to.compareTo((HybridTimestamp)rowTimestamp) == 0) : this.readRowVersion(chain.headLink(), rowTimestamp -> HybridTimestampUtils.withinClosedInterval(rowTimestamp, from, to));
        assert (firstCommit.isCommitted());
        assert (firstCommit.timestamp() != null);
        if (hasWriteIntent && to.compareTo(firstCommit.timestamp()) > 0) {
            RowVersion rowVersion = this.readRowVersion(chain.headLink(), ALWAYS_LOAD_VALUE);
            return AbstractPageMemoryMvPartitionStorage.writeIntentToResult(chain, rowVersion, firstCommit.timestamp());
        }
        RowVersion curCommit = firstCommit;
        while (true) {
            assert (curCommit.timestamp() != null);
            if (curCommit.timestamp().compareTo(from) < 0) {
                return ReadResult.empty(chain.rowId());
            }
            if (curCommit.timestamp().compareTo(to) <= 0) break;
            if (!curCommit.hasNextLink()) {
                return ReadResult.empty(chain.rowId());
            }
            curCommit = this.readRowVersion(curCommit.nextLink(), rowTimestamp -> HybridTimestampUtils.withinClosedInterval(rowTimestamp, from, to));
        }
        BinaryRow row = curCommit.isTombstone() ? null : curCommit.value();
        return ReadResult.createFromCommitted(chain.rowId(), row, curCommit.timestamp(), curCommit.isArchived());
    }

    private static ReadResult writeIntentToResult(VersionChain chain, RowVersion rowVersion, @Nullable HybridTimestamp lastCommittedTimestamp) {
        assert (rowVersion.isUncommitted());
        UUID transactionId = chain.transactionId();
        int commitTableId = chain.commitZoneId();
        int commitPartitionId = chain.commitPartitionId();
        return ReadResult.createFromWriteIntent(chain.rowId(), rowVersion.value(), transactionId, commitTableId, commitPartitionId, lastCommittedTimestamp, rowVersion.isArchived());
    }

    void insertRowVersion(RowVersion rowVersion) {
        try {
            this.renewableState.freeList().insertDataRow(rowVersion);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot store a row version: [row={}, {}]", (Throwable)e, rowVersion, this.createStorageInfo());
        }
    }

    @Override
    public AddWriteResult addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId, boolean isArchivation) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : this.addWriteInfo(rowId, row, txId, commitZoneId, commitPartitionId);
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState(this.state.get(), this::createStorageInfo);
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId)) : this.addWriteInfo(rowId, row, txId, commitZoneId, commitPartitionId);
            try {
                AddWriteInvokeClosure addWrite = this.newAddWriteInvokeClosure(rowId, row, txId, commitZoneId, commitPartitionId, isArchivation);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, addWrite);
                addWrite.afterCompletion();
                AddWriteResult addWriteResult = addWrite.result();
                assert (addWriteResult != null) : this.addWriteInfo(rowId, row, txId, commitZoneId, commitPartitionId);
                return addWriteResult;
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause(e);
                throw new StorageException("Error while executing addWrite: [{}]", (Throwable)e, this.addWriteInfo(rowId, row, txId, commitZoneId, commitPartitionId));
            }
        });
    }

    abstract AddWriteInvokeClosure newAddWriteInvokeClosure(RowId var1, @Nullable BinaryRow var2, UUID var3, int var4, int var5, boolean var6);

    @Override
    public AbortResult abortWrite(RowId rowId, UUID txId) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : this.abortWriteInfo(rowId, txId);
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId)) : this.abortWriteInfo(rowId, txId);
            try {
                AbortWriteInvokeClosure abortWrite = new AbortWriteInvokeClosure(rowId, txId, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, abortWrite);
                abortWrite.afterCompletion();
                AbortResult abortResult = abortWrite.abortResult();
                assert (abortResult != null) : this.abortWriteInfo(rowId, txId);
                return abortResult;
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause(e);
                throw new StorageException("Error while executing abortWrite: [{}]", (Throwable)e, this.abortWriteInfo(rowId, txId));
            }
        });
    }

    @Override
    public CommitResult commitWrite(RowId rowId, HybridTimestamp timestamp, UUID txId) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : this.commitWriteInfo(rowId, timestamp, txId);
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState(this.state.get(), this::createStorageInfo);
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId)) : this.commitWriteInfo(rowId, timestamp, txId);
            try {
                CommitWriteInvokeClosure commitWrite = new CommitWriteInvokeClosure(rowId, timestamp, txId, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, commitWrite);
                this.addUpdateLogEntry(timestamp, rowId);
                commitWrite.afterCompletion();
                CommitResult commitResult = commitWrite.commitResult();
                assert (commitResult != null) : this.commitWriteInfo(rowId, timestamp, txId);
                return commitResult;
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause(e);
                throw new StorageException("Error while executing commitWrite: [{}]", (Throwable)e, this.commitWriteInfo(rowId, timestamp, txId));
            }
        });
    }

    @Override
    public void discard(RowId rowId) throws StorageException {
        throw new StorageException("Unsupported operation");
    }

    void removeRowVersion(RowVersion rowVersion) {
        try {
            this.renewableState.freeList().removeDataRowByLink(rowVersion.link());
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Cannot remove row version: [row={}, {}]", (Throwable)e, rowVersion, this.createStorageInfo());
        }
    }

    @Override
    public AddWriteCommittedResult addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        assert (rowId.partitionId() == this.partitionId) : this.addWriteCommittedInfo(rowId, row, commitTimestamp);
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState(this.state.get(), this::createStorageInfo);
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId)) : this.addWriteCommittedInfo(rowId, row, commitTimestamp);
            try {
                AddWriteCommittedInvokeClosure addWriteCommitted = new AddWriteCommittedInvokeClosure(rowId, row, commitTimestamp, this);
                this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, addWriteCommitted);
                this.addUpdateLogEntry(commitTimestamp, rowId);
                addWriteCommitted.afterCompletion();
                AddWriteCommittedResult addWriteCommittedResult = addWriteCommitted.addWriteCommittedResult();
                assert (addWriteCommittedResult != null) : this.addWriteCommittedInfo(rowId, row, commitTimestamp);
                return addWriteCommittedResult;
            }
            catch (IgniteInternalCheckedException e) {
                StorageUtils.throwStorageExceptionIfItCause(e);
                throw new StorageException("Error while executing addWriteCommitted: [{}]", (Throwable)e, this.addWriteCommittedInfo(rowId, row, commitTimestamp));
            }
        });
    }

    @Override
    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(rowId));
            return this.findVersionChain(rowId, versionChain -> {
                if (versionChain == null) {
                    return CursorUtils.emptyCursor();
                }
                return new ScanVersionsCursor((VersionChain)versionChain, this);
            });
        });
    }

    @Override
    public Cursor<ReadResult> scanAllVersions(RowId fromRowId, HybridTimestamp fromTs, HybridTimestamp toTs) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return new ScanAllVersionsCursor(fromRowId, fromTs, toTs, this);
        });
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            if (AbstractPageMemoryMvPartitionStorage.lookingForLatestVersion(timestamp)) {
                return new LatestVersionsCursor(this);
            }
            return new TimestampCursor(this, timestamp);
        });
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp from, HybridTimestamp to) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            if (AbstractPageMemoryMvPartitionStorage.lookingForLatestVersion(from, to)) {
                return new LatestVersionsCursor(this);
            }
            return new IntervalCursor(this, from, to);
        });
    }

    @Override
    public List<RowUpdateInfo<BinaryRow>> scanUpdateLog(HybridTimestamp lowerBoundTsIncl, RowId lowerBoundRowIdExcl, HybridTimestamp upperBoundTsIncl, int maxItems, EnumSet<TableRowEventType> eventTypes, boolean skipOldEntries) throws StorageException {
        assert (maxItems > 0) : "maxItems must be positive";
        assert (!eventTypes.isEmpty()) : "eventTypes must be non-empty";
        UpdateLogKey lowerBound = new UpdateLogKey(lowerBoundRowIdExcl, lowerBoundTsIncl);
        UpdateLogKey upperBound = new UpdateLogKey(RowId.highestRowId(this.partitionId), upperBoundTsIncl);
        boolean lowIncl = false;
        boolean upIncl = true;
        boolean includeRemoved = eventTypes.contains((Object)TableRowEventType.REMOVED);
        boolean includeArchived = eventTypes.contains((Object)TableRowEventType.ARCHIVED);
        Cursor cursor = this.updateLogTree.find(lowerBound, upperBound, lowIncl, upIncl, null, null);
        try {
            ArrayList<RowUpdateInfo<BinaryRow>> result = new ArrayList<RowUpdateInfo<BinaryRow>>(maxItems);
            for (UpdateLogKey updateLogKey : cursor) {
                TableRowEventType eventType;
                HybridTimestamp ts;
                RowId rowId = updateLogKey.rowId();
                IgniteBiTuple<ReadResult, ReadResult> curAndPrev = this.readCurrentAndPrevious(rowId, ts = updateLogKey.timestamp(), !includeRemoved && !includeArchived);
                if (curAndPrev == null) continue;
                ReadResult newVer = curAndPrev.get1();
                ReadResult oldVer = curAndPrev.get2();
                assert (newVer != null) : "Current version must not be null";
                assert (oldVer != null) : "Previous version must not be null";
                if (newVer.isEmpty() && oldVer.isEmpty() || !eventTypes.contains((Object)(eventType = this.detectEventType(newVer, oldVer)))) continue;
                HybridTimestamp commitTs = newVer.commitTimestamp();
                assert (commitTs != null) : "Commit timestamp must not be null for committed versions: " + newVer;
                RowUpdateInfo<BinaryRow> updateInfo = skipOldEntries && eventType == TableRowEventType.UPDATED ? new RowUpdateInfo<Object>(rowId.uuid(), ts, newVer.binaryRow(), null, commitTs, null, eventType) : new RowUpdateInfo<BinaryRow>(rowId.uuid(), ts, newVer.binaryRow(), oldVer.binaryRow(), commitTs, oldVer.commitTimestamp(), eventType);
                result.add(updateInfo);
                if (result.size() < maxItems) continue;
                break;
            }
            ArrayList<RowUpdateInfo<BinaryRow>> arrayList = result;
            if (cursor != null) {
                cursor.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error while scanning update log: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private TableRowEventType detectEventType(ReadResult newVer, ReadResult oldVer) {
        if (!newVer.isEmpty() && !oldVer.isEmpty()) {
            return TableRowEventType.UPDATED;
        }
        if (!newVer.isEmpty()) {
            return TableRowEventType.CREATED;
        }
        if (newVer.isArchived()) {
            return TableRowEventType.ARCHIVED;
        }
        return TableRowEventType.REMOVED;
    }

    private void addUpdateLogEntry(HybridTimestamp timestamp, RowId rowId) {
        UpdateLogKey row = new UpdateLogKey(rowId, timestamp);
        try {
            this.updateLogTree.putx(row);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error while adding update log entry: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void trimUpdateLog(HybridTimestamp lowWatermark, int maxItems) {
        boolean upIncl = false;
        UpdateLogKey upperBound = new UpdateLogKey(RowId.lowestRowId(this.partitionId), lowWatermark);
        ArrayList<UpdateLogKey> toRemove = new ArrayList<UpdateLogKey>(maxItems);
        try (Cursor cursor = this.updateLogTree.find(null, upperBound, false, upIncl, null, null);){
            for (UpdateLogKey updateLogKey : cursor) {
                toRemove.add(updateLogKey);
                if (toRemove.size() < maxItems) continue;
                break;
            }
            for (UpdateLogKey key : toRemove) {
                this.updateLogTree.removex(key);
            }
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error while trimming update log: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            Cursor cursor = this.renewableState.versionChainTree().find(new VersionChainKey(lowerBound), null);
            try {
                RowId rowId;
                RowId rowId2 = rowId = cursor.hasNext() ? ((VersionChain)cursor.next()).rowId() : null;
                if (cursor != null) {
                    cursor.close();
                }
                return rowId;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException("Error occurred while trying to read a row id", (Throwable)e);
                }
            }
        });
    }

    @Override
    @Nullable
    public RowId highestRowId() throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            try {
                VersionChain lastChain = (VersionChain)this.renewableState.versionChainTree().findLast();
                return lastChain == null ? null : lastChain.rowId();
            }
            catch (Exception e) {
                throw new StorageException("Error occurred while trying to read a row id", (Throwable)e);
            }
        });
    }

    @Override
    public List<RowMeta> rowsStartingWith(RowId lowerBoundInclusive, RowId upperBoundInclusive, int limit) throws StorageException {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            VersionChainKey lowerBoundKey = new VersionChainKey(lowerBoundInclusive);
            VersionChainKey upperBoundKey = new VersionChainKey(upperBoundInclusive);
            Cursor cursor = this.renewableState.versionChainTree().find(lowerBoundKey, upperBoundKey);
            try {
                ArrayList<RowMeta> result = new ArrayList<RowMeta>();
                for (int i = 0; i < limit && cursor.hasNext(); ++i) {
                    VersionChain versionChain = (VersionChain)cursor.next();
                    RowMeta row = new RowMeta(versionChain.rowId(), versionChain.transactionId(), versionChain.commitZoneId(), versionChain.commitPartitionId());
                    result.add(row);
                }
                ArrayList<RowMeta> arrayList = result;
                if (cursor != null) {
                    cursor.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException("Error occurred while trying to read a row id", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void close() {
        if (!StorageUtils.transitionToClosedState(this.state, this::createStorageInfo)) {
            return;
        }
        this.busyLock.block();
        this.closeResources();
    }

    public void closeResources() {
        try {
            IgniteUtils.closeAll(this.getResourcesToClose());
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected List<AutoCloseable> getResourcesToClose() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        RenewablePartitionStorageState localState = this.renewableState;
        resources.add(this.destructionExecutor::close);
        resources.add(this.updateLogTree::close);
        resources.add(localState.versionChainTree()::close);
        resources.add(localState.indexMetaTree()::close);
        resources.add(localState.gcQueue()::close);
        if (localState.tombstonesTree() != null) {
            resources.add(localState.tombstonesTree()::close);
        }
        resources.addAll(this.indexes.getResourcesToClose());
        return resources;
    }

    public boolean transitionToDestroyedState() {
        if (!StorageUtils.transitionToDestroyedState(this.state)) {
            return false;
        }
        this.indexes.transitionToDestroyedState();
        this.busyLock.block();
        return true;
    }

    <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void busy(Runnable action) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        try {
            action.run();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void busySafe(Runnable fn) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            fn.run();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public String createStorageInfo() {
        return IgniteStringFormatter.format("tableId={}, partitionId={}", this.tableStorage.getTableId(), this.partitionId);
    }

    String commitWriteInfo(RowId rowId, HybridTimestamp timestamp, UUID txId) {
        return IgniteStringFormatter.format("rowId={}, timestamp={}, txId={}, {}", rowId, timestamp, txId, this.createStorageInfo());
    }

    String abortWriteInfo(RowId rowId, UUID txId) {
        return IgniteStringFormatter.format("rowId={}, txId={}, {}", rowId, txId, this.createStorageInfo());
    }

    String addWriteInfo(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId) {
        return IgniteStringFormatter.format("rowId={}, rowIsTombstone={}, txId={}, commitZoneId={}, commitPartitionId={}, {}", rowId, row == null, txId, commitZoneId, commitPartitionId, this.createStorageInfo());
    }

    String addWriteCommittedInfo(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) {
        return IgniteStringFormatter.format("rowId={}, rowIsTombstone={}, commitTimestamp={}, {}", rowId, row == null, commitTimestamp, this.createStorageInfo());
    }

    public void startRebalance() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAll(this.getResourcesToCloseOnCleanup());
            this.indexes.startRebalance();
        }
        catch (Exception e) {
            throw new StorageRebalanceException(IgniteStringFormatter.format("Error on start of rebalancing: [{}]", this.createStorageInfo()), (Throwable)e);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void startAbortRebalance() {
        this.busyLock.block();
        try {
            IgniteUtils.closeAll(this.getResourcesToCloseOnCleanup());
        }
        catch (Exception e) {
            throw new StorageRebalanceException(IgniteStringFormatter.format("Error on start abort of rebalancing: [{}]", this.createStorageInfo()), (Throwable)e);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void completeRebalance() {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
        this.indexes.completeRebalance();
    }

    public abstract void lastAppliedOnRebalance(long var1, long var3) throws StorageException;

    abstract List<AutoCloseable> getResourcesToCloseOnCleanup();

    public abstract void committedGroupConfigurationOnRebalance(byte[] var1);

    public abstract void updateLeaseOnRebalance(LeaseInfo var1);

    public void startCleanup() throws Exception {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAll(this.getResourcesToCloseOnCleanup());
            this.indexes.startCleanup();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void finishCleanup() {
        if (this.state.compareAndSet(StorageState.CLEANUP, StorageState.RUNNABLE)) {
            this.indexes.finishCleanup();
        }
    }

    void throwExceptionIfStorageNotInRunnableState() {
        StorageUtils.throwExceptionIfStorageNotInRunnableState(this.state.get(), this::createStorageInfo);
    }

    @Nullable
    <T> T findVersionChain(RowId rowId, final Function<VersionChain, T> mapper) {
        try {
            return (T)this.renewableState.versionChainTree().findOne(new VersionChainKey(rowId), new BplusTree.TreeRowMapClosure<VersionChainKey, VersionChain, T>(){

                @Override
                public T map(VersionChain treeRow) {
                    return mapper.apply(treeRow);
                }
            }, null);
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause(e);
            throw new StorageException("Row version lookup failed: [rowId={}, {}]", (Throwable)e, rowId, this.createStorageInfo());
        }
    }

    @Override
    public List<GcEntry> peek(HybridTimestamp lowWatermark, int count) {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            if (count <= 0) {
                return List.of();
            }
            if (count == 1) {
                return this.peekSingleGcEntryBusy(lowWatermark);
            }
            return this.peekGcEntriesBusy(lowWatermark, count);
        });
    }

    @Override
    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        assert (THREAD_LOCAL_LOCKER.get() != null);
        assert (THREAD_LOCAL_LOCKER.get().isLocked(entry.getRowId()));
        this.throwExceptionIfStorageNotInRunnableState();
        assert (entry instanceof GcRowVersion) : entry;
        GcRowVersion gcRowVersion = (GcRowVersion)entry;
        RowId rowId = entry.getRowId();
        HybridTimestamp rowTimestamp = gcRowVersion.getTimestamp();
        if (!this.renewableState.gcQueue().remove(rowId, rowTimestamp, gcRowVersion.getLink())) {
            return null;
        }
        RowVersion removedRowVersion = this.removeWriteOnGc(rowId, rowTimestamp, gcRowVersion.getLink());
        return removedRowVersion.value();
    }

    private RowVersion removeWriteOnGc(RowId rowId, HybridTimestamp rowTimestamp, long rowLink) {
        RemoveWriteOnGcInvokeClosure removeWriteOnGc = new RemoveWriteOnGcInvokeClosure(rowId, rowTimestamp, rowLink, this);
        try {
            this.renewableState.versionChainTree().invoke(new VersionChainKey(rowId), null, removeWriteOnGc);
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause(e);
            throw new StorageException("Error removing row version from version chain on garbage collection: [rowId={}, rowTimestamp={}, {}]", (Throwable)e, rowId, rowTimestamp, this.createStorageInfo());
        }
        removeWriteOnGc.afterCompletion();
        return removeWriteOnGc.getResult();
    }

    @Nullable
    public IndexStorage getIndex(int indexId) {
        return this.busy(() -> this.indexes.getIndex(indexId));
    }

    public CompletableFuture<Void> destroyIndex(int indexId) {
        return this.busy(() -> this.indexes.destroyIndex(indexId, this.renewableState.indexMetaTree()));
    }

    public abstract void incrementEstimatedSize();

    public abstract void decrementEstimatedSize();

    private List<GcEntry> peekSingleGcEntryBusy(HybridTimestamp lowWatermark) {
        GcRowVersion head = this.renewableState.gcQueue().getFirst();
        if (head == null) {
            return List.of();
        }
        HybridTimestamp rowTimestamp = head.getTimestamp();
        if (rowTimestamp.compareTo(lowWatermark) > 0) {
            return List.of();
        }
        this.preloadingForGcIfNeededBusy(head);
        return List.of(head);
    }

    private List<GcEntry> peekGcEntriesBusy(HybridTimestamp lowWatermark, int count) {
        ArrayList<GcEntry> res = new ArrayList<GcEntry>(count);
        try (Cursor cursor = this.renewableState.gcQueue().find(null, null);){
            while (res.size() < count && cursor.hasNext()) {
                GcRowVersion next = (GcRowVersion)cursor.next();
                if (next.getTimestamp().compareTo(lowWatermark) > 0) {
                    break;
                }
                res.add(next);
                this.preloadingForGcIfNeededBusy(next);
            }
        }
        catch (IgniteInternalCheckedException e) {
            StorageUtils.throwStorageExceptionIfItCause(e);
            throw new StorageException("Peek GC entries failed: [lowWatermark={}, count={}, {}]", (Throwable)e, lowWatermark, count, this.createStorageInfo());
        }
        return res;
    }

    protected void preloadingForGcIfNeededBusy(GcRowVersion gcRowVersion) {
    }
}

