/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.jetbrains.annotations.Nullable;

class AbortWriteInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    private final UUID txId;
    private final AbstractPageMemoryMvPartitionStorage storage;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    @Nullable
    private RowVersion toRemove;
    private AbortResult abortResult;

    AbortWriteInvokeClosure(RowId rowId, UUID txId, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.txId = txId;
        this.storage = storage;
    }

    @Override
    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        if (oldRow == null || oldRow.transactionId() == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
            this.abortResult = AbortResult.noWriteIntent();
            return;
        }
        if (!this.txId.equals(oldRow.transactionId())) {
            this.operationType = IgniteTree.OperationType.NOOP;
            this.abortResult = AbortResult.txMismatch(oldRow.transactionId());
            return;
        }
        RowVersion latestVersion = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
        assert (latestVersion.isUncommitted()) : this.abortWriteInfo() + ", headLink=" + oldRow.headLink();
        this.toRemove = latestVersion;
        if (latestVersion.hasNextLink()) {
            RowVersion nextVersion = this.storage.readRowVersion(latestVersion.nextLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
            this.newRow = VersionChain.createCommitted(this.rowId, latestVersion.nextLink(), nextVersion.nextLink());
            this.operationType = IgniteTree.OperationType.PUT;
        } else {
            this.operationType = IgniteTree.OperationType.REMOVE;
        }
        this.abortResult = AbortResult.success(latestVersion.value());
    }

    @Override
    @Nullable
    public VersionChain newRow() {
        assert (this.operationType == IgniteTree.OperationType.PUT == (this.newRow != null)) : this.abortWriteInfo() + ", newRow=" + this.newRow + ", op=" + this.operationType;
        return this.newRow;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null) : this.abortWriteInfo();
        return this.operationType;
    }

    void afterCompletion() {
        assert (this.operationType == IgniteTree.OperationType.NOOP == (this.toRemove == null)) : this.abortWriteInfo() + ", toRemove=" + this.toRemove + ", op=" + this.operationType;
        if (this.toRemove != null) {
            this.toRemove.operations().removeFromWriteIntentsList(this.storage, this::abortWriteInfo);
            this.storage.removeRowVersion(this.toRemove);
        }
    }

    AbortResult abortResult() {
        return this.abortResult;
    }

    private String abortWriteInfo() {
        return this.storage.abortWriteInfo(this.rowId, this.txId);
    }
}

