/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.encryption.fileio;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.ignite3.internal.fileio.FileIo;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.storage.pagememory.encryption.PersistentPageMemoryEncryptionManager;
import org.apache.ignite3.internal.storage.pagememory.encryption.fileio.EncryptedFileIo;

public class EncryptedFileIoFactory
implements FileIoFactory {
    private final FileIoFactory delegate;
    private final PersistentPageMemoryEncryptionManager dataEncryptionManager;
    private final int grpId;
    private final int pageSize;

    public EncryptedFileIoFactory(PersistentPageMemoryEncryptionManager dataEncryptionManager, FileIoFactory delegate, int grpId, int pageSize) {
        this.delegate = delegate;
        this.dataEncryptionManager = dataEncryptionManager;
        this.grpId = grpId;
        this.pageSize = pageSize;
    }

    @Override
    public FileIo create(Path filePath) throws IOException {
        FileIo io = this.delegate.create(filePath);
        return new EncryptedFileIo(io, this.dataEncryptionManager, this.grpId, this.pageSize);
    }

    @Override
    public FileIo create(Path filePath, OpenOption ... modes) throws IOException {
        FileIo io = this.delegate.create(filePath, modes);
        return new EncryptedFileIo(io, this.dataEncryptionManager, this.grpId, this.pageSize);
    }
}

