/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.storage.pagememory.StoragePartitionMetaIo;

public class StoragePartitionMetaIoV2
extends StoragePartitionMetaIo {
    private static final int WI_HEAD_OFF = 152;

    protected StoragePartitionMetaIoV2() {
        super(2);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setWiHead(pageAddr, 0L);
    }

    public void setWiHead(long pageAddr, long headLink) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 152, headLink);
    }

    @Override
    public long getWiHead(long pageAddr) {
        return PageUtils.getLong(pageAddr, 152);
    }

    @Override
    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("TablePartitionMeta [").nl().app("lastAppliedIndex=").app(this.getLastAppliedIndex(addr)).nl().app("lastAppliedTerm=").app(this.getLastAppliedTerm(addr)).nl().app("lastReplicationProtocolGroupConfigFirstPageId=").app(this.getLastReplicationProtocolGroupConfigFirstPageId(addr)).nl().app("freeListRootPageId=").appendHex(StoragePartitionMetaIoV2.getFreeListRootPageId(addr)).nl().app("versionChainTreeRootPageId=").appendHex(this.getVersionChainTreeRootPageId(addr)).nl().app("indexTreeMetaPageId=").appendHex(this.getIndexTreeMetaPageId(addr)).nl().app("gcQueueMetaPageId=").appendHex(this.getGcQueueMetaPageId(addr)).nl().app("pageCount=").app(this.getPageCount(addr)).nl().app("leaseStartTime=").app(this.getLeaseStartTime(addr)).nl().app("primaryReplicaNodeId=").app(this.getPrimaryReplicaNodeId(addr)).nl().app("primaryReplicaNodeNameFirstPageId=").app(this.getPrimaryReplicaNodeNameFirstPageId(addr)).nl().app("estimatedSize=").app(this.getEstimatedSize(addr)).nl().app("wiHead=").app(this.getWiHead(addr)).nl().app(']');
    }
}

