/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.ignite3.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite3.internal.pagememory.persistence.PartitionMetaFactory;
import org.apache.ignite3.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite3.internal.storage.pagememory.StoragePartitionMetaFactory;
import org.apache.ignite3.internal.storage.pagememory.StoragePartitionMetaIoV2;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class StoragePartitionMeta
extends PartitionMeta {
    public static final PartitionMetaFactory FACTORY = new StoragePartitionMetaFactory();
    private static final AtomicLongFieldUpdater<StoragePartitionMeta> ESTIMATED_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(StoragePartitionMeta.class, "estimatedSize");
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    private volatile long lastReplicationProtocolGroupConfigFirstPageId;
    private volatile long leaseStartTime;
    private volatile long wiHeadLink;
    @Nullable
    private volatile UUID primaryReplicaNodeId;
    private volatile long primaryReplicaNodeNameFirstPageId;
    private volatile long freeListRootPageId;
    private volatile long versionChainTreeRootPageId;
    private volatile long indexTreeMetaPageId;
    private volatile long gcQueueMetaPageId;
    private volatile long tombstonesTreeMetaPageId;
    private volatile long updateLogTreeRootPageId;
    private volatile long estimatedSize;

    public StoragePartitionMeta(int pageCount, int partitionGeneration, long lastAppliedIndex, long lastAppliedTerm, long lastReplicationProtocolGroupConfigFirstPageId, long leaseStartTime, @Nullable UUID primaryReplicaNodeId, long primaryReplicaNodeNameFirstPageId, long freeListRootPageId, long versionChainTreeRootPageId, long indexTreeMetaPageId, long gcQueueMetaPageId, long tombstonesTreeMetaPageId, long updateLogTreeRootPageId, long estimatedSize, long wiHeadLink) {
        super(pageCount, partitionGeneration);
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
        this.lastReplicationProtocolGroupConfigFirstPageId = lastReplicationProtocolGroupConfigFirstPageId;
        this.leaseStartTime = leaseStartTime;
        this.primaryReplicaNodeId = primaryReplicaNodeId;
        this.primaryReplicaNodeNameFirstPageId = primaryReplicaNodeNameFirstPageId;
        this.freeListRootPageId = freeListRootPageId;
        this.versionChainTreeRootPageId = versionChainTreeRootPageId;
        this.indexTreeMetaPageId = indexTreeMetaPageId;
        this.gcQueueMetaPageId = gcQueueMetaPageId;
        this.tombstonesTreeMetaPageId = tombstonesTreeMetaPageId;
        this.updateLogTreeRootPageId = updateLogTreeRootPageId;
        this.estimatedSize = estimatedSize;
        this.wiHeadLink = wiHeadLink;
    }

    StoragePartitionMeta init(@Nullable UUID checkpointId) {
        this.initSnapshot(checkpointId);
        return this;
    }

    public long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public long lastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    public void lastApplied(@Nullable UUID checkpointId, long lastAppliedIndex, long lastAppliedTerm) {
        this.updateSnapshot(checkpointId);
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
    }

    public long lastReplicationProtocolGroupConfigFirstPageId() {
        return this.lastReplicationProtocolGroupConfigFirstPageId;
    }

    public void lastReplicationProtocolGroupConfigFirstPageId(@Nullable UUID checkpointId, long pageId) {
        this.updateSnapshot(checkpointId);
        this.lastReplicationProtocolGroupConfigFirstPageId = pageId;
    }

    public long versionChainTreeRootPageId() {
        return this.versionChainTreeRootPageId;
    }

    public void versionChainTreeRootPageId(@Nullable UUID checkpointId, long versionChainTreeRootPageId) {
        this.updateSnapshot(checkpointId);
        this.versionChainTreeRootPageId = versionChainTreeRootPageId;
    }

    public long freeListRootPageId() {
        return this.freeListRootPageId;
    }

    public void freeListRootPageId(@Nullable UUID checkpointId, long freeListRootPageId) {
        this.updateSnapshot(checkpointId);
        this.freeListRootPageId = freeListRootPageId;
    }

    public long indexTreeMetaPageId() {
        return this.indexTreeMetaPageId;
    }

    public void indexTreeMetaPageId(@Nullable UUID checkpointId, long indexTreeMetaPageId) {
        this.updateSnapshot(checkpointId);
        this.indexTreeMetaPageId = indexTreeMetaPageId;
    }

    public long gcQueueMetaPageId() {
        return this.gcQueueMetaPageId;
    }

    public void gcQueueMetaPageId(@Nullable UUID checkpointId, long gcQueueMetaPageId) {
        this.updateSnapshot(checkpointId);
        this.gcQueueMetaPageId = gcQueueMetaPageId;
    }

    public long tombstonesTreeMetaPageId() {
        return this.tombstonesTreeMetaPageId;
    }

    public void tombstonesTreeMetaPageId(@Nullable UUID checkpointId, long tombstonesTreeMetaPageId) {
        this.updateSnapshot(checkpointId);
        this.tombstonesTreeMetaPageId = tombstonesTreeMetaPageId;
    }

    public long updateLogTreeRootPageId() {
        return this.updateLogTreeRootPageId;
    }

    public void updateLogTreeRootPageId(@Nullable UUID checkpointId, long updateLogTreeRootPageId) {
        this.updateSnapshot(checkpointId);
        this.updateLogTreeRootPageId = updateLogTreeRootPageId;
    }

    public long estimatedSize() {
        return this.estimatedSize;
    }

    public void incrementEstimatedSize(@Nullable UUID checkpointId) {
        this.updateSnapshot(checkpointId);
        ESTIMATED_SIZE_UPDATER.incrementAndGet(this);
    }

    public void decrementEstimatedSize(@Nullable UUID checkpointId) {
        this.updateSnapshot(checkpointId);
        ESTIMATED_SIZE_UPDATER.decrementAndGet(this);
    }

    @Override
    protected StoragePartitionMetaSnapshot buildSnapshot(@Nullable UUID checkpointId) {
        return new StoragePartitionMetaSnapshot(checkpointId, this.lastAppliedIndex, this.lastAppliedTerm, this.lastReplicationProtocolGroupConfigFirstPageId, this.versionChainTreeRootPageId, this.freeListRootPageId, this.indexTreeMetaPageId, this.gcQueueMetaPageId, this.tombstonesTreeMetaPageId, this.pageCount(), this.leaseStartTime, this.primaryReplicaNodeId, this.primaryReplicaNodeNameFirstPageId, this.updateLogTreeRootPageId, this.estimatedSize, this.wiHeadLink);
    }

    @Override
    public StoragePartitionMetaSnapshot metaSnapshot(@Nullable UUID checkpointId) {
        return (StoragePartitionMetaSnapshot)super.metaSnapshot(checkpointId);
    }

    @Override
    public String toString() {
        return S.toString(StoragePartitionMeta.class, this, super.toString());
    }

    public void updateLease(@Nullable UUID checkpointId, long leaseStartTime) {
        this.updateSnapshot(checkpointId);
        this.leaseStartTime = leaseStartTime;
    }

    public long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.primaryReplicaNodeId;
    }

    public void primaryReplicaNodeId(@Nullable UUID checkpointId, UUID nodeId) {
        this.updateSnapshot(checkpointId);
        this.primaryReplicaNodeId = nodeId;
    }

    public long primaryReplicaNodeNameFirstPageId() {
        return this.primaryReplicaNodeNameFirstPageId;
    }

    public void primaryReplicaNodeNameFirstPageId(@Nullable UUID checkpointId, long pageId) {
        this.updateSnapshot(checkpointId);
        this.primaryReplicaNodeNameFirstPageId = pageId;
    }

    public long wiHeadLink() {
        return this.wiHeadLink;
    }

    public void updateWiHead(@Nullable UUID checkpointId, long link) {
        this.updateSnapshot(checkpointId);
        this.wiHeadLink = link;
    }

    public static class StoragePartitionMetaSnapshot
    implements PartitionMeta.PartitionMetaSnapshot {
        @Nullable
        private final UUID checkpointId;
        private final long lastAppliedIndex;
        private final long lastAppliedTerm;
        private final long lastReplicationProtocolGroupConfigFirstPageId;
        private final long versionChainTreeRootPageId;
        private final long freeListRootPageId;
        private final long indexTreeMetaPageId;
        private final long gcQueueMetaPageId;
        private final long tombstonesTreeMetaPageId;
        private final int pageCount;
        private final long leaseStartTime;
        private final long updateLogTreeRootPageId;
        @Nullable
        private final UUID primaryReplicaNodeId;
        private final long primaryReplicaNodeNameFirstPageId;
        private final long estimatedSize;
        private final long wiHeadLink;

        private StoragePartitionMetaSnapshot(@Nullable UUID checkpointId, long lastAppliedIndex, long lastAppliedTerm, long lastReplicationProtocolGroupConfigFirstPageId, long versionChainTreeRootPageId, long freeListRootPageId, long indexTreeMetaPageId, long gcQueueMetaPageId, long tombstonesTreeMetaPageId, int pageCount, long leaseStartTime, @Nullable UUID primaryReplicaNodeId, long primaryReplicaNodeNameFistPageId, long updateLogTreeRootPageId, long estimatedSize, long wiHeadLink) {
            this.checkpointId = checkpointId;
            this.lastAppliedIndex = lastAppliedIndex;
            this.lastAppliedTerm = lastAppliedTerm;
            this.lastReplicationProtocolGroupConfigFirstPageId = lastReplicationProtocolGroupConfigFirstPageId;
            this.versionChainTreeRootPageId = versionChainTreeRootPageId;
            this.freeListRootPageId = freeListRootPageId;
            this.indexTreeMetaPageId = indexTreeMetaPageId;
            this.gcQueueMetaPageId = gcQueueMetaPageId;
            this.tombstonesTreeMetaPageId = tombstonesTreeMetaPageId;
            this.pageCount = pageCount;
            this.leaseStartTime = leaseStartTime;
            this.primaryReplicaNodeId = primaryReplicaNodeId;
            this.primaryReplicaNodeNameFirstPageId = primaryReplicaNodeNameFistPageId;
            this.updateLogTreeRootPageId = updateLogTreeRootPageId;
            this.estimatedSize = estimatedSize;
            this.wiHeadLink = wiHeadLink;
        }

        public long lastAppliedIndex() {
            return this.lastAppliedIndex;
        }

        public long lastAppliedTerm() {
            return this.lastAppliedTerm;
        }

        public long lastReplicationProtocolGroupConfigFirstPageId() {
            return this.lastReplicationProtocolGroupConfigFirstPageId;
        }

        public long versionChainTreeRootPageId() {
            return this.versionChainTreeRootPageId;
        }

        public long freeListRootPageId() {
            return this.freeListRootPageId;
        }

        public long indexTreeMetaPageId() {
            return this.indexTreeMetaPageId;
        }

        public long gcQueueMetaPageId() {
            return this.gcQueueMetaPageId;
        }

        @Override
        public int pageCount() {
            return this.pageCount;
        }

        public long leaseStartTime() {
            return this.leaseStartTime;
        }

        public long updateLogTreeRootPageId() {
            return this.updateLogTreeRootPageId;
        }

        public long estimatedSize() {
            return this.estimatedSize;
        }

        @Override
        public void writeTo(PartitionMetaIo metaIo, long pageAddr) {
            StoragePartitionMetaIoV2 storageMetaIo = (StoragePartitionMetaIoV2)metaIo;
            storageMetaIo.setLastAppliedIndex(pageAddr, this.lastAppliedIndex);
            storageMetaIo.setLastAppliedTerm(pageAddr, this.lastAppliedTerm);
            storageMetaIo.setLastReplicationProtocolGroupConfigFirstPageId(pageAddr, this.lastReplicationProtocolGroupConfigFirstPageId);
            storageMetaIo.setVersionChainTreeRootPageId(pageAddr, this.versionChainTreeRootPageId);
            storageMetaIo.setFreeListRootPageId(pageAddr, this.freeListRootPageId);
            storageMetaIo.setIndexTreeMetaPageId(pageAddr, this.indexTreeMetaPageId);
            storageMetaIo.setGcQueueMetaPageId(pageAddr, this.gcQueueMetaPageId);
            storageMetaIo.setTombstonesTreeMetaPageId(pageAddr, this.tombstonesTreeMetaPageId);
            storageMetaIo.setPageCount(pageAddr, this.pageCount);
            storageMetaIo.setLeaseStartTime(pageAddr, this.leaseStartTime);
            storageMetaIo.setPrimaryReplicaNodeId(pageAddr, this.primaryReplicaNodeId);
            storageMetaIo.setPrimaryReplicaNodeNameFirstPageId(pageAddr, this.primaryReplicaNodeNameFirstPageId);
            storageMetaIo.setUpdateLogTreeRootPageId(pageAddr, this.updateLogTreeRootPageId);
            storageMetaIo.setEstimatedSize(pageAddr, this.estimatedSize);
            storageMetaIo.setWiHead(pageAddr, this.wiHeadLink);
        }

        @Override
        @Nullable
        public UUID checkpointId() {
            return this.checkpointId;
        }

        public String toString() {
            return S.toString(StoragePartitionMetaSnapshot.class, this);
        }
    }
}

