/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite3.internal.pagememory.reuse.ReuseList;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.apache.ignite3.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogTree;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.TombstonesTree;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryTableStorage
extends AbstractPageMemoryTableStorage<PersistentPageMemoryMvPartitionStorage> {
    private final PersistentPageMemoryStorageEngine engine;
    private final PersistentPageMemoryDataRegion dataRegion;
    private final ExecutorService destructionExecutor;
    private final FailureProcessor failureProcessor;

    public PersistentPageMemoryTableStorage(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier, PersistentPageMemoryStorageEngine engine, PersistentPageMemoryDataRegion dataRegion, ExecutorService destructionExecutor, FailureProcessor failureProcessor) {
        super(tableDescriptor, indexDescriptorSupplier);
        this.engine = engine;
        this.dataRegion = dataRegion;
        this.destructionExecutor = destructionExecutor;
        this.failureProcessor = failureProcessor;
    }

    @Override
    public PersistentPageMemoryStorageEngine engine() {
        return this.engine;
    }

    public PersistentPageMemoryDataRegion dataRegion() {
        return this.dataRegion;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    protected void finishDestruction() {
        this.dataRegion.pageMemory().onGroupDestroyed(this.getTableId());
        this.dataRegion.checkpointManager().partitionDestructionLockManager().removeLockForGroup(this.getTableId());
        try {
            this.dataRegion.filePageStoreManager().destroyGroupIfExists(this.getTableId());
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Could not destroy table directory", (Throwable)e);
        }
    }

    @Override
    public PersistentPageMemoryMvPartitionStorage createMvPartitionStorage(int partitionId) {
        GroupPartitionId groupPartitionId = this.createGroupPartitionId(partitionId);
        StoragePartitionMeta meta = this.getOrCreatePartitionMetaOnCreatePartition(groupPartitionId);
        return this.inCheckpointLock(() -> {
            PersistentPageMemory pageMemory = this.dataRegion.pageMemory();
            FreeListImpl freeList = this.createFreeList(partitionId, pageMemory, meta);
            VersionChainTree versionChainTree = this.createVersionChainTree(partitionId, freeList, pageMemory, meta);
            IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId, freeList, pageMemory, meta);
            GcQueue gcQueue = this.createGcQueue(partitionId, freeList, pageMemory, meta);
            TombstonesTree tombstonesTree = this.createTombstonesTree(partitionId, freeList, pageMemory, meta);
            UpdateLogTree updateLogTree = this.createUpdateLogTree(partitionId, freeList, pageMemory, meta);
            return new PersistentPageMemoryMvPartitionStorage(this, partitionId, meta, freeList, versionChainTree, indexMetaTree, gcQueue, tombstonesTree, this.destructionExecutor, updateLogTree, this.failureProcessor);
        });
    }

    @Nullable
    public UUID lastCheckpointId() {
        CheckpointProgress lastCeckpointProgress = this.dataRegion.checkpointManager().lastCheckpointProgress();
        return lastCeckpointProgress == null ? null : lastCeckpointProgress.id();
    }

    private FreeListImpl createFreeList(int partId, PersistentPageMemory pageMemory, StoragePartitionMeta meta) throws StorageException {
        try {
            boolean initNew = false;
            if (meta.freeListRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePageNoReuse(this.getTableId(), partId, (byte)2);
                meta.freeListRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new FreeListImpl("PersistentFreeList", this.getTableId(), partId, (PageMemory)this.dataRegion.pageMemory(), meta.freeListRootPageId(), initNew, this.dataRegion.pageListCacheLimit());
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating free list: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partId);
        }
    }

    private VersionChainTree createVersionChainTree(int partId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) throws StorageException {
        try {
            boolean initNew = false;
            if (meta.versionChainTreeRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partId, (byte)2);
                meta.versionChainTreeRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new VersionChainTree(this.getTableId(), Integer.toString(this.getTableId()), partId, this.dataRegion.pageMemory(), this.engine.generateGlobalRemoveId(), meta.versionChainTreeRootPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating VersionChainTree: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partId);
        }
    }

    private IndexMetaTree createIndexMetaTree(int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.indexTreeMetaPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partitionId, (byte)2);
                meta.indexTreeMetaPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new IndexMetaTree(this.getTableId(), Integer.toString(this.getTableId()), partitionId, this.dataRegion.pageMemory(), this.engine.generateGlobalRemoveId(), meta.indexTreeMetaPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating IndexMetaTree: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partitionId);
        }
    }

    private GcQueue createGcQueue(int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.gcQueueMetaPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partitionId, (byte)2);
                meta.gcQueueMetaPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new GcQueue(this.getTableId(), Integer.toString(this.getTableId()), partitionId, this.dataRegion.pageMemory(), this.engine.generateGlobalRemoveId(), meta.gcQueueMetaPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating GarbageCollectionTree: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partitionId);
        }
    }

    private TombstonesTree createTombstonesTree(int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.tombstonesTreeMetaPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partitionId, (byte)2);
                meta.tombstonesTreeMetaPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new TombstonesTree(this.getTableId(), partitionId, this.dataRegion.pageMemory(), new AtomicLong(), meta.tombstonesTreeMetaPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating TombstonesTree: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partitionId);
        }
    }

    private UpdateLogTree createUpdateLogTree(int partId, ReuseList reuseList, PersistentPageMemory pageMemory, StoragePartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.updateLogTreeRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(reuseList, this.getTableId(), partId, (byte)2);
                meta.updateLogTreeRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new UpdateLogTree(this.getTableId(), Integer.toString(this.getTableId()), partId, pageMemory, new AtomicLong(), meta.updateLogTreeRootPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating UpdateLogTree: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partId);
        }
    }

    @Override
    CompletableFuture<Void> destroyMvPartitionStorage(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        boolean transitioned = mvPartitionStorage.transitionToDestroyedState();
        if (transitioned) {
            mvPartitionStorage.closeResources();
        }
        return this.destroyPartitionPhysically(this.createGroupPartitionId(mvPartitionStorage.partitionId()));
    }

    @Override
    CompletableFuture<Void> clearStorageAndUpdateDataStructures(AbstractPageMemoryMvPartitionStorage mvPartitionStorage, Runnable afterUpdateStructuresCallback) {
        GroupPartitionId groupPartitionId = this.createGroupPartitionId(mvPartitionStorage.partitionId());
        return this.destroyPartitionPhysically(groupPartitionId).thenAccept(unused -> {
            PersistentPageMemory pageMemory = this.dataRegion.pageMemory();
            int partitionId = groupPartitionId.getPartitionId();
            StoragePartitionMeta meta = this.getOrCreatePartitionMetaOnCreatePartition(groupPartitionId);
            this.inCheckpointLock(() -> {
                FreeListImpl freeList = this.createFreeList(partitionId, pageMemory, meta);
                VersionChainTree versionChainTree = this.createVersionChainTree(partitionId, freeList, pageMemory, meta);
                IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId, freeList, pageMemory, meta);
                GcQueue gcQueue = this.createGcQueue(partitionId, freeList, pageMemory, meta);
                TombstonesTree tombstonesTree = this.createTombstonesTree(partitionId, freeList, pageMemory, meta);
                UpdateLogTree updateLogTree = this.createUpdateLogTree(partitionId, freeList, pageMemory, meta);
                ((PersistentPageMemoryMvPartitionStorage)mvPartitionStorage).updateDataStructures(meta, freeList, versionChainTree, indexMetaTree, gcQueue, tombstonesTree, updateLogTree);
                afterUpdateStructuresCallback.run();
                return null;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> destroyPartitionPhysically(GroupPartitionId groupPartitionId) {
        this.dataRegion.filePageStoreManager().getStore(groupPartitionId).markToDestroy();
        Lock partitionDestructionLock = this.dataRegion.checkpointManager().partitionDestructionLockManager().destructionLock(groupPartitionId).writeLock();
        partitionDestructionLock.lock();
        try {
            this.dataRegion.pageMemory().invalidate(groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
            this.dataRegion.partitionMetaManager().removeMeta(groupPartitionId);
            CompletableFuture<Void> completableFuture = this.dataRegion.filePageStoreManager().destroyPartition(groupPartitionId);
            return completableFuture;
        }
        finally {
            partitionDestructionLock.unlock();
        }
    }

    private GroupPartitionId createGroupPartitionId(int partitionId) {
        return new GroupPartitionId(this.getTableId(), partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V inCheckpointLock(Supplier<V> supplier) {
        CheckpointTimeoutLock checkpointTimeoutLock = this.dataRegion.checkpointManager().checkpointTimeoutLock();
        checkpointTimeoutLock.checkpointReadLock();
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            checkpointTimeoutLock.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoragePartitionMeta getOrCreatePartitionMetaOnCreatePartition(GroupPartitionId groupPartitionId) {
        ByteBuffer buffer = GridUnsafe.allocateBuffer(this.dataRegion.pageMemory().pageSize());
        try {
            FilePageStore filePageStore = this.dataRegion.filePageStoreManager().getStore(groupPartitionId);
            if (filePageStore != null) {
                StoragePartitionMeta partitionMeta = (StoragePartitionMeta)this.dataRegion.partitionMetaManager().getMeta(groupPartitionId);
                assert (partitionMeta != null) : groupPartitionId;
                StoragePartitionMeta storagePartitionMeta = partitionMeta;
                return storagePartitionMeta;
            }
            filePageStore = this.readOrCreateAndInitFilePageStore(groupPartitionId, buffer);
            StoragePartitionMeta partitionMeta = this.readOrCreatePartitionMeta(groupPartitionId, filePageStore, buffer.rewind());
            filePageStore.pages(partitionMeta.pageCount());
            filePageStore.setPageAllocationListener(pageIdx -> {
                assert (this.dataRegion.checkpointManager().checkpointTimeoutLock().checkpointLockIsHeldByThread());
                partitionMeta.incrementPageCount(this.lastCheckpointId());
            });
            this.dataRegion.filePageStoreManager().addStore(groupPartitionId, filePageStore);
            this.dataRegion.partitionMetaManager().addMeta(groupPartitionId, partitionMeta);
            if (filePageStore.deltaFileCount() > 0) {
                this.dataRegion.checkpointManager().triggerCompaction();
            }
            StoragePartitionMeta storagePartitionMeta = partitionMeta;
            return storagePartitionMeta;
        }
        finally {
            GridUnsafe.freeBuffer(buffer);
        }
    }

    private FilePageStore readOrCreateAndInitFilePageStore(GroupPartitionId groupPartitionId, ByteBuffer buffer) throws StorageException {
        try {
            FilePageStore filePageStore = this.dataRegion.filePageStoreManager().readOrCreateStore(groupPartitionId, buffer, this.getTableDescriptor().isEncryptionEnabled());
            assert (!filePageStore.isMarkedToDestroy()) : IgniteStringFormatter.format("Should not be marked for deletion: [tableId={}, partitionId={}]", groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
            filePageStore.ensure();
            return filePageStore;
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error read and initializing file page store: [tableId={}, partitionId={}]", (Throwable)e, groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
        }
    }

    private StoragePartitionMeta readOrCreatePartitionMeta(GroupPartitionId groupPartitionId, FilePageStore filePageStore, ByteBuffer buffer) throws StorageException {
        try {
            int partGen = this.dataRegion.pageMemory().partGeneration(groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
            return (StoragePartitionMeta)this.dataRegion.partitionMetaManager().readOrCreateMeta(this.lastCheckpointId(), groupPartitionId, filePageStore, buffer, partGen);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error reading or creating partition meta information: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), groupPartitionId.getPartitionId());
        }
    }

    @Override
    protected void beforeCloseOrDestroy() {
        this.dataRegion.removeTableStorage(this);
    }
}

