/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.copy;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.apache.ignite3.internal.sql.engine.sql.copy.GridgainSqlCopyFormat;
import org.jetbrains.annotations.Nullable;

public class GridgainSqlCopy
extends SqlCall {
    private final Operator operator;
    private final SqlNode from;
    private final SqlNode into;
    @Nullable
    private final SqlNodeList optionList;

    public GridgainSqlCopy(SqlParserPos pos, SqlNode from, SqlNode into, GridgainSqlCopyFormat format, @Nullable SqlNodeList optionList) {
        super(pos);
        this.from = from;
        this.into = into;
        this.optionList = optionList;
        this.operator = new Operator(format);
    }

    public SqlOperator getOperator() {
        return this.operator;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.from, (Object)this.into, (Object)this.optionList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("COPY");
        writer.keyword("FROM");
        if (this.from instanceof SqlSelect) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SUB_QUERY);
            this.from.unparse(writer, 0, 0);
            writer.endList(frame);
        } else {
            this.from.unparse(writer, 0, 0);
        }
        writer.keyword("INTO");
        this.into.unparse(writer, 0, 0);
        writer.keyword("FORMAT");
        writer.keyword(this.operator.format.name());
        if (this.optionList != null) {
            writer.keyword("WITH");
            this.optionList.unparse(writer, 0, 0);
        }
    }

    public SqlNode getFrom() {
        return this.from;
    }

    public SqlNode getInto() {
        return this.into;
    }

    public GridgainSqlCopyFormat getFormat() {
        return this.operator.format;
    }

    @Nullable
    public SqlNodeList getOptionList() {
        return this.optionList;
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        private final GridgainSqlCopyFormat format;

        public Operator(GridgainSqlCopyFormat format) {
            super("COPY", SqlKind.OTHER);
            this.format = format;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlCopy(pos, operands[0], operands[1], this.format, (SqlNodeList)operands[2]);
        }
    }
}

