/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.exec.fsm.DdlBatchAware;
import org.apache.ignite3.internal.sql.engine.exec.fsm.DdlBatchGroup;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

@DdlBatchAware(group=DdlBatchGroup.DROP)
public class IgniteSqlDropZone
extends SqlDrop {
    private final SqlIdentifier name;

    public IgniteSqlDropZone(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        super((SqlOperator)new Operator(ifExists), pos, ifExists);
        this.name = Objects.requireNonNull(name, "zone name");
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifExists() {
        Operator operator = (Operator)this.getOperator();
        return operator.existFlag();
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("DROP ZONE", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlDropZone(pos, this.existFlag(), (SqlIdentifier)operands[0]);
        }
    }
}

