/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.schema.DefaultValueGenerator;
import org.apache.ignite3.internal.schema.DefaultValueProvider;
import org.apache.ignite3.internal.sql.engine.schema.AbstractIgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.CatalogColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptorImpl;
import org.apache.ignite3.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSchema;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSchemas;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSequence;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSequenceImpl;
import org.apache.ignite3.internal.sql.engine.schema.IgniteStatistic;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSystemViewImpl;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTableImpl;
import org.apache.ignite3.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite3.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptorImpl;
import org.apache.ignite3.internal.sql.engine.statistic.SqlStatisticManager;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class SqlSchemaManagerImpl
implements SqlSchemaManager {
    private final CatalogManager catalogManager;
    private final SqlStatisticManager sqlStatisticManager;
    private final Cache<Integer, IgniteSchemas> schemaCache;
    private final Cache<CacheKey, IgniteTableImpl> tableCache;
    private final Cache<Long, IgniteIndex> indexCache;
    private final Cache<Long, ActualIgniteTable> fullDataTableCache;
    private final Cache<Long, IgniteSequence> sequenceCache;

    public SqlSchemaManagerImpl(CatalogManager catalogManager, SqlStatisticManager sqlStatisticManager, CacheFactory factory, int cacheSize) {
        this.catalogManager = catalogManager;
        this.sqlStatisticManager = sqlStatisticManager;
        this.schemaCache = factory.create(cacheSize);
        this.tableCache = factory.create(cacheSize);
        this.indexCache = factory.create(cacheSize);
        this.fullDataTableCache = factory.create(cacheSize);
        this.sequenceCache = factory.create(cacheSize);
    }

    @Override
    public IgniteSchemas schemas(int catalogVersion) {
        return this.schemaCache.get(catalogVersion, version -> this.createRootSchema(this.catalogManager.catalog((int)version)));
    }

    @Override
    public IgniteSchemas schemas(long timestamp) {
        int catalogVersion = this.catalogManager.activeCatalogVersion(timestamp);
        return this.schemas(catalogVersion);
    }

    @Override
    public int catalogVersion(long timestamp) {
        return this.catalogManager.activeCatalogVersion(timestamp);
    }

    @Override
    public CompletableFuture<Void> schemaReadyFuture(int catalogVersion) {
        if (this.catalogManager.latestCatalogVersion() >= catalogVersion) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.catalogManager.catalogReadyFuture(catalogVersion);
    }

    @Override
    public IgniteTable table(int catalogVersion, int tableId) {
        return this.fullDataTableCache.get(SqlSchemaManagerImpl.cacheKey(catalogVersion, tableId), key -> {
            Catalog catalog;
            IgniteSchemas rootSchema = this.schemaCache.get(catalogVersion);
            if (rootSchema != null) {
                SchemaPlus schemaPlus = rootSchema.root();
                for (String name : schemaPlus.getSubSchemaNames()) {
                    SchemaPlus subSchema = schemaPlus.getSubSchema(name);
                    assert (subSchema != null) : name;
                    IgniteSchema schema = (IgniteSchema)((Object)((Object)subSchema.unwrap(IgniteSchema.class)));
                    assert (schema != null) : "unknown schema " + subSchema;
                    ActualIgniteTable table = (ActualIgniteTable)schema.tableByIdOpt(tableId);
                    if (table == null) continue;
                    return table;
                }
            }
            if ((catalog = this.catalogManager.catalog(catalogVersion)) == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Catalog of given version not found: " + catalogVersion);
            }
            CatalogTableDescriptor tableDescriptor = catalog.table(tableId);
            if (tableDescriptor == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Table with given id not found: " + tableId);
            }
            CacheKey tableKey = SqlSchemaManagerImpl.tableCacheKey(tableDescriptor.id(), tableDescriptor.updateTimestamp());
            IgniteTableImpl igniteTable = this.tableCache.get(tableKey, x -> {
                TableDescriptor descriptor = this.createTableDescriptorForTable(catalog, tableDescriptor);
                return this.createTableDataOnlyTable(catalog, tableDescriptor, descriptor);
            });
            Map<String, IgniteIndex> tableIndexes = this.getIndexes(catalog, tableDescriptor.id(), tableDescriptor.primaryKeyIndexId());
            return new ActualIgniteTable(igniteTable, tableIndexes);
        });
    }

    @Override
    public IgniteSequence sequence(int sequenceId) {
        return this.sequence(this.catalogManager.latestCatalogVersion(), sequenceId);
    }

    @Override
    public IgniteSequence sequence(int catalogVersion, int sequenceId) {
        return this.sequenceCache.get(SqlSchemaManagerImpl.cacheKey(catalogVersion, sequenceId), key -> {
            Catalog catalog;
            IgniteSchemas schemas = this.schemaCache.get(catalogVersion);
            SchemaPlus rootSchema = schemas.root();
            if (rootSchema != null) {
                for (String name : rootSchema.getSubSchemaNames()) {
                    SchemaPlus subSchema = rootSchema.getSubSchema(name);
                    assert (subSchema != null) : name;
                    IgniteSchema schema = (IgniteSchema)((Object)((Object)subSchema.unwrap(IgniteSchema.class)));
                    assert (schema != null) : "unknown schema " + subSchema;
                    IgniteSequence table = schema.sequenceByIdOpt(sequenceId);
                    if (table == null) continue;
                    return table;
                }
            }
            if ((catalog = this.catalogManager.catalog(catalogVersion)) == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Catalog of given version not found: " + catalogVersion);
            }
            CatalogSequenceDescriptor sequenceDescriptor = catalog.sequence(sequenceId);
            if (sequenceDescriptor == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Sequence with given id not found: " + sequenceId);
            }
            CatalogTableDescriptor tableDescriptor = catalog.table(sequenceDescriptor.tableId());
            if (tableDescriptor == null) {
                String msg = IgniteStringFormatter.format("Sequence underlying system table not found [catalogVersion={}, sequenceId={}, tableId={}]", catalogVersion, sequenceId, sequenceDescriptor.tableId());
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, msg);
            }
            TableDescriptor descriptor = this.createTableDescriptorForTable(catalog, tableDescriptor);
            return new IgniteSequenceImpl(sequenceDescriptor.name(), sequenceDescriptor.version(), sequenceDescriptor.id(), sequenceDescriptor.tableId(), sequenceDescriptor.increment(), sequenceDescriptor.minvalue(), sequenceDescriptor.maxvalue(), sequenceDescriptor.start(), sequenceDescriptor.cachevalue(), descriptor);
        });
    }

    private static long cacheKey(int part1, int part2) {
        long cacheKey = part1;
        return (cacheKey <<= 32) | (long)part2;
    }

    private static CacheKey tableCacheKey(int tableId, HybridTimestamp modificationTimestamp) {
        return new CacheKey(tableId, modificationTimestamp.longValue());
    }

    private IgniteSchemas createRootSchema(Catalog catalog) {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)false);
        for (CatalogSchemaDescriptor schemaDescriptor : catalog.schemas()) {
            IgniteSchema igniteSchema = this.createSqlSchema(catalog, schemaDescriptor);
            rootSchema.add(igniteSchema.getName(), (Schema)igniteSchema);
        }
        return new IgniteSchemas(rootSchema, catalog.version());
    }

    private IgniteSchema createSqlSchema(Catalog catalog, CatalogSchemaDescriptor schemaDescriptor) {
        TableDescriptor descriptor;
        int catalogVersion = catalog.version();
        String schemaName = schemaDescriptor.name();
        int numTables = schemaDescriptor.tables().length;
        ArrayList<AbstractIgniteDataSource> schemaDataSources = new ArrayList<AbstractIgniteDataSource>(numTables);
        for (CatalogTableDescriptor tableDescriptor : schemaDescriptor.tables()) {
            CacheKey cacheKey = SqlSchemaManagerImpl.tableCacheKey(tableDescriptor.id(), tableDescriptor.updateTimestamp());
            IgniteTableImpl igniteTable = this.tableCache.get(cacheKey, k -> {
                TableDescriptor descriptor = this.createTableDescriptorForTable(catalog, tableDescriptor);
                return this.createTableDataOnlyTable(catalog, tableDescriptor, descriptor);
            });
            Map<String, IgniteIndex> tableIndexes = this.getIndexes(catalog, tableDescriptor.id(), tableDescriptor.primaryKeyIndexId());
            schemaDataSources.add(new ActualIgniteTable(igniteTable, tableIndexes));
        }
        ArrayList<IgniteSequenceImpl> schemaSequences = new ArrayList<IgniteSequenceImpl>(schemaDescriptor.sequences().length);
        for (CatalogSequenceDescriptor catalogSequenceDescriptor : schemaDescriptor.sequences()) {
            int tableId = catalogSequenceDescriptor.tableId();
            CatalogTableDescriptor catalogTableDescriptor = catalog.table(tableId);
            assert (catalogTableDescriptor != null) : "Sequence table descriptor is not found in schema: " + tableId;
            descriptor = this.createTableDescriptorForTable(catalog, catalogTableDescriptor);
            IgniteSequenceImpl sequence = new IgniteSequenceImpl(catalogSequenceDescriptor.name(), catalogSequenceDescriptor.version(), catalogSequenceDescriptor.id(), tableId, catalogSequenceDescriptor.increment(), catalogSequenceDescriptor.minvalue(), catalogSequenceDescriptor.maxvalue(), catalogSequenceDescriptor.start(), catalogSequenceDescriptor.cachevalue(), descriptor);
            schemaSequences.add(sequence);
        }
        for (CatalogObjectDescriptor catalogObjectDescriptor : schemaDescriptor.systemViews()) {
            int viewId = catalogObjectDescriptor.id();
            String viewName = catalogObjectDescriptor.name();
            descriptor = SqlSchemaManagerImpl.createTableDescriptorForSystemView((CatalogSystemViewDescriptor)catalogObjectDescriptor);
            IgniteSystemViewImpl schemaTable = new IgniteSystemViewImpl(viewName, viewId, descriptor);
            schemaDataSources.add(schemaTable);
        }
        return new IgniteSchema(schemaName, catalogVersion, schemaDataSources, schemaSequences);
    }

    private static IgniteIndex createSchemaIndex(CatalogIndexDescriptor indexDescriptor, RelCollation outputCollation, IgniteDistribution distribution, boolean primaryKey) {
        IgniteIndex.Type type;
        if (indexDescriptor instanceof CatalogSortedIndexDescriptor) {
            type = IgniteIndex.Type.SORTED;
        } else if (indexDescriptor instanceof CatalogHashIndexDescriptor) {
            type = IgniteIndex.Type.HASH;
        } else {
            throw new IllegalArgumentException("Unexpected index type: " + indexDescriptor);
        }
        return new IgniteIndex(indexDescriptor.id(), indexDescriptor.name(), type, distribution, outputCollation, primaryKey);
    }

    private TableDescriptor createTableDescriptorForTable(Catalog catalog, CatalogTableDescriptor descriptor) {
        int implicitPkColIdx;
        List<CatalogTableColumnDescriptor> columns = descriptor.columns();
        ArrayList<ColumnDescriptor> colDescriptors = new ArrayList<ColumnDescriptor>(columns.size() + 2);
        Object2IntMap<String> columnToIndex = SqlSchemaManagerImpl.buildColumnToIndexMap(columns);
        for (int i = 0; i < columns.size(); ++i) {
            CatalogTableColumnDescriptor col = columns.get(i);
            boolean key = descriptor.isPrimaryKeyColumn(col.name());
            CatalogColumnDescriptor columnDescriptor = SqlSchemaManagerImpl.createColumnDescriptor(col, key, i);
            colDescriptors.add(columnDescriptor);
        }
        if (Commons.implicitPkEnabled() && (implicitPkColIdx = columnToIndex.getOrDefault((Object)"__p_key", -1)) != -1) {
            colDescriptors.set(implicitPkColIdx, SqlSchemaManagerImpl.injectDefault((ColumnDescriptor)colDescriptors.get(implicitPkColIdx)));
        }
        colDescriptors.add(SqlSchemaManagerImpl.createPartitionVirtualColumn(columns.size(), "__PARTITION_ID", NativeTypes.INT64));
        colDescriptors.add(SqlSchemaManagerImpl.createPartitionVirtualColumn(columns.size() + 1, "__PART", NativeTypes.INT32));
        colDescriptors.add(SqlSchemaManagerImpl.createPartitionVirtualColumn(columns.size() + 2, "__part", NativeTypes.INT32));
        CatalogZoneDescriptor zoneDescriptor = Objects.requireNonNull(catalog.zone(descriptor.zoneId()));
        CatalogSchemaDescriptor schemaDescriptor = Objects.requireNonNull(catalog.schema(descriptor.schemaId()));
        IgniteDistribution distribution = this.createDistribution(descriptor, columnToIndex, schemaDescriptor.name(), zoneDescriptor.name());
        return new TableDescriptorImpl(colDescriptors, distribution);
    }

    private IgniteDistribution createDistribution(CatalogTableDescriptor descriptor, Object2IntMap<String> columnToIndex, String schemaName, String zoneName) {
        List<Integer> colocationColumns = descriptor.colocationColumnNames().stream().map(arg_0 -> columnToIndex.getInt(arg_0)).collect(Collectors.toList());
        int tableId = descriptor.id();
        int zoneId = descriptor.zoneId();
        String label = TraitUtils.affinityDistributionLabel(schemaName, descriptor.name(), zoneName);
        return IgniteDistributions.affinity(colocationColumns, tableId, zoneId, label);
    }

    private static Object2IntMap<String> buildColumnToIndexMap(List<CatalogTableColumnDescriptor> columns) {
        Object2IntOpenHashMap columnToIndex = new Object2IntOpenHashMap(columns.size() + 2);
        for (int i = 0; i < columns.size(); ++i) {
            CatalogTableColumnDescriptor col = columns.get(i);
            columnToIndex.put((Object)col.name(), i);
        }
        return columnToIndex;
    }

    private static ColumnDescriptorImpl createPartitionVirtualColumn(int logicalIndex, String partColName, NativeType type) {
        return new ColumnDescriptorImpl(partColName, false, true, true, true, logicalIndex, type, DefaultValueStrategy.DEFAULT_COMPUTED, () -> {
            throw new AssertionError((Object)"Partition virtual column is generated by a function");
        }, DefaultValueProvider.NULL_PROVIDER);
    }

    private static ColumnDescriptor injectDefault(ColumnDescriptor desc) {
        assert (Commons.implicitPkEnabled() && "__p_key".equals(desc.name())) : desc;
        return new ColumnDescriptorImpl(desc.name(), desc.key(), true, false, desc.nullable(), desc.logicalIndex(), desc.physicalType(), DefaultValueStrategy.DEFAULT_COMPUTED, () -> {
            throw new AssertionError((Object)"Implicit primary key is generated by a function");
        }, DefaultValueProvider.forValueGenerator(DefaultValueGenerator.RAND_UUID));
    }

    private static TableDescriptor createTableDescriptorForSystemView(CatalogSystemViewDescriptor descriptor) {
        IgniteDistribution distribution;
        ArrayList<ColumnDescriptor> colDescriptors = new ArrayList<ColumnDescriptor>();
        List<CatalogTableColumnDescriptor> columns = descriptor.columns();
        for (int i = 0; i < columns.size(); ++i) {
            CatalogTableColumnDescriptor col = columns.get(i);
            CatalogColumnDescriptor columnDescriptor = SqlSchemaManagerImpl.createColumnDescriptor(col, false, i);
            colDescriptors.add(columnDescriptor);
        }
        CatalogSystemViewDescriptor.SystemViewType systemViewType = descriptor.systemViewType();
        switch (systemViewType) {
            case NODE: {
                distribution = IgniteDistributions.identity(0);
                break;
            }
            case CLUSTER: {
                distribution = IgniteDistributions.single();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected system view type: " + systemViewType);
            }
        }
        return new TableDescriptorImpl(colDescriptors, distribution);
    }

    private static CatalogColumnDescriptor createColumnDescriptor(CatalogTableColumnDescriptor col, boolean key, int i) {
        DefaultValueStrategy defaultValueStrategy;
        DefaultValueProvider defaultValueProvider;
        Supplier<Object> defaultValueSupplier;
        boolean nullable;
        block7: {
            block6: {
                nullable = col.nullable();
                DefaultValue defaultVal = col.defaultValue();
                defaultValueSupplier = null;
                defaultValueProvider = null;
                if (defaultVal == null) break block6;
                switch (defaultVal.type()) {
                    case CONSTANT: {
                        DefaultValue.ConstantValue constantValue = (DefaultValue.ConstantValue)defaultVal;
                        if (constantValue.value() == null) {
                            defaultValueStrategy = DefaultValueStrategy.DEFAULT_NULL;
                        } else {
                            defaultValueStrategy = DefaultValueStrategy.DEFAULT_CONSTANT;
                            defaultValueProvider = DefaultValueProvider.constantProvider(constantValue.value());
                        }
                        break block7;
                    }
                    case FUNCTION_CALL: {
                        DefaultValue.FunctionCall functionCall = (DefaultValue.FunctionCall)defaultVal;
                        defaultValueProvider = DefaultValueProvider.forValueGenerator(DefaultValueGenerator.valueOf(functionCall.functionName()), functionCall.parameters());
                        defaultValueStrategy = DefaultValueStrategy.DEFAULT_COMPUTED;
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected default value: ");
                    }
                }
            }
            defaultValueStrategy = null;
            defaultValueSupplier = null;
        }
        return new CatalogColumnDescriptor(col.name(), key, nullable, i, col.type(), col.precision(), col.scale(), col.length(), defaultValueStrategy, defaultValueSupplier, defaultValueProvider);
    }

    private IgniteTableImpl createTableDataOnlyTable(Catalog catalog, CatalogTableDescriptor table, TableDescriptor descriptor) {
        Map<String, IgniteIndex> tableIndexes = this.getIndexes(catalog, table.id(), table.primaryKeyIndexId());
        CatalogZoneDescriptor zoneDescriptor = SqlSchemaManagerImpl.getZoneDescriptor(catalog, table.zoneId());
        IgniteDistribution secondaryDistribution = SqlSchemaManagerImpl.secondaryDistribution(catalog, table, descriptor);
        return SqlSchemaManagerImpl.createTable(table, descriptor, tableIndexes, zoneDescriptor, this.sqlStatisticManager, secondaryDistribution);
    }

    private Map<String, IgniteIndex> getIndexes(Catalog catalog, int tableId, int primaryKeyIndexId) {
        HashMap<String, IgniteIndex> tableIndexes = new HashMap<String, IgniteIndex>();
        CatalogTableDescriptor table = catalog.table(tableId);
        assert (table != null);
        for (CatalogIndexDescriptor indexDescriptor : catalog.indexes(tableId)) {
            if (indexDescriptor.status() != CatalogIndexStatus.AVAILABLE) continue;
            long indexKey = SqlSchemaManagerImpl.cacheKey(indexDescriptor.id(), indexDescriptor.status().id());
            IgniteIndex schemaIndex = this.indexCache.get(indexKey, x -> {
                RelCollation outputCollation = IgniteIndex.createIndexCollation(indexDescriptor, table);
                Object2IntMap<String> columnToIndex = SqlSchemaManagerImpl.buildColumnToIndexMap(table.columns());
                CatalogZoneDescriptor zoneDescriptor = Objects.requireNonNull(catalog.zone(table.zoneId()));
                CatalogSchemaDescriptor schemaDescriptor = Objects.requireNonNull(catalog.schema(table.schemaId()));
                IgniteDistribution distribution = this.createDistribution(table, columnToIndex, schemaDescriptor.name(), zoneDescriptor.name());
                return SqlSchemaManagerImpl.createSchemaIndex(indexDescriptor, outputCollation, distribution, indexDescriptor.id() == primaryKeyIndexId);
            });
            tableIndexes.put(schemaIndex.name(), schemaIndex);
        }
        return tableIndexes;
    }

    private static CatalogZoneDescriptor getZoneDescriptor(Catalog catalog, int zoneId) {
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(zoneId);
        assert (zoneDescriptor != null) : "Zone is not found in schema: " + zoneId;
        return zoneDescriptor;
    }

    private static IgniteTableImpl createTable(CatalogTableDescriptor catalogTableDescriptor, TableDescriptor tableDescriptor, Map<String, IgniteIndex> indexes, CatalogZoneDescriptor zoneDescriptor, SqlStatisticManager sqlStatisticManager, @Nullable IgniteDistribution secondaryDistribution) {
        IgniteIndex primaryIndex = indexes.values().stream().filter(IgniteIndex::primaryKey).findFirst().orElseThrow();
        Map<String, IgniteIndex> primaryKeyOnlyMap = Map.of(primaryIndex.name(), primaryIndex);
        ImmutableIntList primaryKeyColumns = primaryIndex.collation().getKeys();
        int tableId = catalogTableDescriptor.id();
        String tableName = catalogTableDescriptor.name();
        IgniteStatistic statistic = new IgniteStatistic(() -> sqlStatisticManager.tableSize(tableId), tableDescriptor.distribution());
        return new IgniteTableImpl(tableName, tableId, catalogTableDescriptor.latestSchemaVersion(), catalogTableDescriptor.updateTimestamp().longValue(), tableDescriptor, primaryKeyColumns, statistic, primaryKeyOnlyMap, zoneDescriptor.partitions(), zoneDescriptor.id(), catalogTableDescriptor.cache(), catalogTableDescriptor.secondaryZoneId(), secondaryDistribution, catalogTableDescriptor.secondaryStorageState());
    }

    @Nullable
    private static IgniteDistribution secondaryDistribution(Catalog catalog, CatalogTableDescriptor table, TableDescriptor descriptor) {
        Integer zoneId = table.secondaryZoneId();
        if (zoneId == null) {
            return null;
        }
        CatalogSchemaDescriptor schemaDescriptor = Objects.requireNonNull(catalog.schema(table.schemaId()));
        CatalogZoneDescriptor zoneDescriptor = SqlSchemaManagerImpl.getZoneDescriptor(catalog, zoneId);
        IgniteDistribution distribution = descriptor.distribution();
        ImmutableIntList keys = distribution.getKeys();
        if (distribution.isTableDistribution()) {
            String label = TraitUtils.affinityDistributionLabel(schemaDescriptor.name(), table.name(), zoneDescriptor.name());
            return IgniteDistributions.affinity((List<Integer>)keys, table.id(), zoneDescriptor.id(), label);
        }
        return distribution;
    }

    private static class CacheKey {
        final int id;
        final long timestamp;

        private CacheKey(int id, long timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.id == cacheKey.id && this.timestamp == cacheKey.timestamp;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.timestamp);
        }
    }

    private static class ActualIgniteTable
    extends AbstractIgniteDataSource
    implements IgniteTable {
        private final IgniteTableImpl table;
        private final Map<String, IgniteIndex> indexMap;

        ActualIgniteTable(IgniteTableImpl igniteTable, Map<String, IgniteIndex> indexMap) {
            super(igniteTable.name(), igniteTable.id(), igniteTable.version(), igniteTable.timestamp(), igniteTable.descriptor(), igniteTable.getStatistic());
            this.table = igniteTable;
            this.indexMap = indexMap;
        }

        @Override
        protected TableScan toRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable relOptTbl, List<RelHint> hints) {
            return this.table.toRel(cluster, traitSet, relOptTbl, hints);
        }

        @Override
        public Integer secondaryZoneId() {
            return this.table.secondaryZoneId();
        }

        @Override
        public boolean isUpdateAllowed(int colIdx) {
            return this.table.isUpdateAllowed(colIdx);
        }

        @Override
        public RelDataType rowTypeForInsert(IgniteTypeFactory factory) {
            return this.table.rowTypeForInsert(factory);
        }

        @Override
        public RelDataType rowTypeForUpdate(IgniteTypeFactory factory) {
            return this.table.rowTypeForUpdate(factory);
        }

        @Override
        public RelDataType rowTypeForDelete(IgniteTypeFactory factory) {
            return this.table.rowTypeForDelete(factory);
        }

        @Override
        public ImmutableIntList keyColumns() {
            return this.table.keyColumns();
        }

        @Override
        public Supplier<PartitionCalculator> partitionCalculator() {
            return this.table.partitionCalculator();
        }

        @Override
        public Map<String, IgniteIndex> indexes() {
            return this.indexMap;
        }

        @Override
        public int partitions() {
            return this.table.partitions();
        }

        @Override
        public int zoneId() {
            return this.table.zoneId();
        }

        @Override
        public boolean cache() {
            return this.table.cache();
        }

        @Override
        public boolean useSecondaryStorage() {
            return this.table.useSecondaryStorage();
        }

        @Override
        public CatalogSecondaryStorageState secondaryStorageState() {
            return this.table.secondaryStorageState();
        }

        @Override
        public IgniteTable cloneForSecondaryStorage() {
            IgniteTable clonedTable = this.table.cloneForSecondaryStorage();
            return new ActualIgniteTable((IgniteTableImpl)clonedTable, this.indexMap);
        }
    }
}

