/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite3.internal.schema.DefaultValueProvider;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite3.internal.type.NativeType;
import org.jetbrains.annotations.Nullable;

public class ColumnDescriptorImpl
implements ColumnDescriptor {
    private static final Supplier<Object> NULL_SUPPLIER = () -> null;
    private final boolean nullable;
    private final boolean key;
    private final boolean hidden;
    private final boolean virtual;
    private final String name;
    private final Supplier<Object> dfltVal;
    private final DefaultValueStrategy defaultStrategy;
    private final DefaultValueProvider defaultValueProvider;
    private final int logicalIndex;
    private final NativeType storageType;

    public ColumnDescriptorImpl(String name, boolean key, boolean hidden, boolean virtual, boolean nullable, int logicalIndex, NativeType type, DefaultValueStrategy defaultStrategy, @Nullable Supplier<Object> dfltVal, @Nullable DefaultValueProvider defaultValueProvider) {
        this.key = key;
        this.hidden = hidden;
        this.virtual = virtual;
        this.nullable = nullable;
        this.name = name;
        this.defaultStrategy = defaultStrategy;
        this.logicalIndex = logicalIndex;
        this.storageType = type;
        this.dfltVal = defaultStrategy != DefaultValueStrategy.DEFAULT_NULL ? Objects.requireNonNull(dfltVal, "dfltVal") : NULL_SUPPLIER;
        this.defaultValueProvider = defaultValueProvider;
    }

    @Override
    public boolean hidden() {
        return this.hidden;
    }

    @Override
    public boolean virtual() {
        return this.virtual;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public boolean key() {
        return this.key;
    }

    @Override
    public DefaultValueStrategy defaultStrategy() {
        return this.defaultStrategy;
    }

    @Override
    public Object defaultValue() {
        return this.dfltVal.get();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int logicalIndex() {
        return this.logicalIndex;
    }

    @Override
    public NativeType physicalType() {
        return this.storageType;
    }

    @Override
    public DefaultValueProvider defaultValueProvider() {
        return this.defaultValueProvider;
    }
}

