/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import java.util.function.Supplier;
import org.apache.ignite3.internal.schema.DefaultValueProvider;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public final class CatalogColumnDescriptor
implements ColumnDescriptor {
    private static final Supplier<Object> NULL_SUPPLIER = () -> null;
    private final boolean nullable;
    private final boolean key;
    private final String name;
    private final Supplier<Object> dfltVal;
    private final DefaultValueStrategy defaultStrategy;
    private final DefaultValueProvider defaultValueProvider;
    private final int index;
    private final ColumnType columnType;
    private final int precision;
    private final int scale;
    private final int length;
    private NativeType nativeType;

    public CatalogColumnDescriptor(String name, boolean key, boolean nullable, int index, ColumnType columnType, int precision, int scale, int length, @Nullable DefaultValueStrategy defaultStrategy, @Nullable Supplier<Object> dfltVal, @Nullable DefaultValueProvider dfltValueProvider) {
        this.key = key;
        this.nullable = nullable;
        this.name = name;
        this.index = index;
        this.defaultStrategy = defaultStrategy;
        this.columnType = columnType;
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.dfltVal = defaultStrategy != null ? (defaultStrategy == DefaultValueStrategy.DEFAULT_NULL ? NULL_SUPPLIER : () -> this.defaultValueProvider().get()) : NULL_SUPPLIER;
        this.defaultValueProvider = dfltValueProvider;
    }

    @Override
    public boolean hidden() {
        return false;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public boolean key() {
        return this.key;
    }

    @Override
    public DefaultValueStrategy defaultStrategy() {
        return this.defaultStrategy;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int logicalIndex() {
        return this.index;
    }

    @Override
    public NativeType physicalType() {
        if (this.nativeType == null) {
            this.nativeType = TypeUtils.columnType2NativeType(this.columnType, this.precision, this.scale, this.length);
        }
        return this.nativeType;
    }

    @Override
    @Nullable
    public Object defaultValue() {
        return this.dfltVal.get();
    }

    @Override
    public DefaultValueProvider defaultValueProvider() {
        return this.defaultValueProvider;
    }
}

