/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.ddl;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.NodeFilterValidator;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class ClusterWideNodeFilterValidator
implements NodeFilterValidator {
    private final LogicalTopologyService logicalTopologyService;

    public ClusterWideNodeFilterValidator(LogicalTopologyService logicalTopologyService) {
        this.logicalTopologyService = logicalTopologyService;
    }

    @Override
    public CompletableFuture<Void> validate(@Nullable String nodeFilter) {
        if (nodeFilter == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        Set<NodeWithAttributes> filtered = ClusterWideNodeFilterValidator.filteredTopologyNodes(this.logicalTopologyService.localLogicalTopology(), nodeFilter);
        if (!filtered.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.logicalTopologyService.logicalTopologyOnLeader().handle((snapshot, e) -> {
            if (e == null) {
                if (ClusterWideNodeFilterValidator.filteredTopologyNodes(snapshot, nodeFilter).isEmpty()) {
                    throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Node filter does not match any node in the cluster [filter='{}'].", nodeFilter));
                }
                return null;
            }
            throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, "Distributed validation of the node filter for distribution zone failed [filter='{}'].", (Throwable)e);
        });
    }

    private static Set<NodeWithAttributes> filteredTopologyNodes(LogicalTopologySnapshot snapshot, String nodeFilter) {
        Set nodes = snapshot.nodes().stream().map(n -> new NodeWithAttributes(n.name(), n.id(), n.userAttributes(), n.storageProfiles())).collect(Collectors.toSet());
        return nodes.stream().filter(n -> DistributionZonesUtil.filterNodeAttributes(n.userAttributes(), nodeFilter)).collect(Collectors.toSet());
    }
}

