/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.sql.engine.message.QueryBatchRequestMessage;
import org.apache.ignite3.internal.sql.engine.message.QueryBatchRequestMessageBuilder;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryBatchRequestMessageDeserializer
implements MessageDeserializer<QueryBatchRequestMessage> {
    private final QueryBatchRequestMessageBuilder msg;

    QueryBatchRequestMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryBatchRequestMessage();
    }

    @Override
    public Class<QueryBatchRequestMessage> klass() {
        return QueryBatchRequestMessage.class;
    }

    @Override
    public QueryBatchRequestMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryBatchRequestMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("amountOfBatches");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.amountOfBatches(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("exchangeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.exchangeId(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.queryId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readByteArray("sharedStateByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.sharedStateByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchRequestMessage.class);
    }
}

