/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.expressions;

import java.io.Reader;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.sql.engine.api.expressions.EvaluationContext;
import org.apache.ignite3.internal.sql.engine.api.expressions.EvaluationContextBuilder;
import org.apache.ignite3.internal.sql.engine.api.expressions.ExpressionEvaluationException;
import org.apache.ignite3.internal.sql.engine.api.expressions.ExpressionFactory;
import org.apache.ignite3.internal.sql.engine.api.expressions.ExpressionParsingException;
import org.apache.ignite3.internal.sql.engine.api.expressions.ExpressionValidationException;
import org.apache.ignite3.internal.sql.engine.api.expressions.IgnitePredicate;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowAccessor;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowFactoryFactory;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.SqlEvaluationContext;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlExpressionFactory;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlPredicate;
import org.apache.ignite3.internal.sql.engine.expressions.RowBasedScope;
import org.apache.ignite3.internal.sql.engine.expressions.RowNamespace;
import org.apache.ignite3.internal.sql.engine.expressions.ToInternalGenericAdapter;
import org.apache.ignite3.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite3.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlParser;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.StructNativeType;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class SqlExpressionFactoryAdapter
implements ExpressionFactory {
    private static final String SINGLE_INPUT_ROW_NAMESPACE_NAME = "INPUT";
    private final SqlExpressionFactory factory;

    public SqlExpressionFactoryAdapter(SqlExpressionFactory factory) {
        this.factory = factory;
    }

    @Override
    public <RowT> EvaluationContextBuilder<RowT> contextBuilder() {
        return new EvaluationContextBuilderImpl();
    }

    @Override
    public IgnitePredicate predicate(String expression, StructNativeType inputRowType) throws ExpressionParsingException, ExpressionValidationException {
        SqlNode expressionAst = SqlExpressionFactoryAdapter.parse(expression);
        SqlExpressionFactoryAdapter.validate(expressionAst, RejectSubQueriesValidator.INSTANCE);
        SqlExpressionFactoryAdapter.validate(expressionAst, RejectContextDependentFunctionValidator.INSTANCE);
        try (IgnitePlanner planner = SqlExpressionFactoryAdapter.createPlanner();){
            SqlValidator validator = planner.validator();
            RowBasedScope scope = new RowBasedScope(validator.getEmptyScope());
            RelDataType relDataType = TypeUtils.native2relationalType((RelDataTypeFactory)planner.getTypeFactory(), inputRowType);
            scope.addChild(new RowNamespace(validator, relDataType), SINGLE_INPUT_ROW_NAMESPACE_NAME, false);
            try {
                expressionAst.validateExpr(validator, (SqlValidatorScope)scope);
            }
            catch (CalciteContextException ex) {
                String message = ex.getMessage();
                if (message == null) {
                    message = "Unable to validate expression.";
                }
                throw new ExpressionValidationException(message);
            }
            SqlExpressionFactoryAdapter.validate(expressionAst, RejectAggregatesValidator.INSTANCE);
            RelDataType resultType = validator.deriveType((SqlValidatorScope)scope, expressionAst);
            if (!SqlTypeUtil.isBoolean((RelDataType)resultType)) {
                throw new ExpressionValidationException("Expected BOOLEAN expression but " + resultType + " was provided.");
            }
            RexNode rexNode = planner.sqlToRelConverter().convertExpressionExt(expressionAst, (SqlValidatorScope)scope, relDataType);
            SqlPredicate predicate = this.factory.predicate(rexNode, relDataType);
            PredicateAdapter predicateAdapter = new PredicateAdapter(predicate);
            return predicateAdapter;
        }
    }

    private static SqlNode parse(String sql) throws ExpressionParsingException {
        SqlNode sqlNode;
        SourceStringReader reader = new SourceStringReader(sql);
        try {
            SqlParser parser = SqlParser.create((Reader)reader, (SqlParser.Config)IgniteSqlParser.PARSER_CONFIG);
            sqlNode = parser.parseExpression();
        }
        catch (Throwable parser) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    parser.addSuppressed(throwable);
                }
                throw parser;
            }
            catch (SqlParseException e) {
                String message = IgniteSqlParser.normalizeMessage(e);
                throw new ExpressionParsingException(message);
            }
        }
        reader.close();
        return sqlNode;
    }

    private static void validate(SqlNode ast, SqlShuttle validator) throws ExpressionValidationException {
        try {
            ast.accept((SqlVisitor)validator);
        }
        catch (Util.FoundOne one) {
            String message = (String)one.getNode();
            assert (message != null);
            throw new ExpressionValidationException(message);
        }
    }

    private static IgnitePlanner createPlanner() {
        return PlanningContext.builder().catalogVersion(-1).build().planner();
    }

    private static String getMessagePrefix(SqlNode n) {
        SqlParserPos pos = n.getParserPosition();
        return Static.RESOURCE.validatorContext(pos.getLineNum(), pos.getColumnNum(), pos.getEndLineNum(), pos.getEndColumnNum()).str();
    }

    private static class EvaluationContextBuilderImpl<RowT>
    implements EvaluationContextBuilder<RowT> {
        private LongSupplier timeProvider = System::currentTimeMillis;
        private RowAccessor<RowT> rowAccessor;

        private EvaluationContextBuilderImpl() {
        }

        @Override
        public EvaluationContextBuilder<RowT> timeProvider(LongSupplier timeProvider) {
            this.timeProvider = Objects.requireNonNull(timeProvider, "timeProvider");
            return this;
        }

        @Override
        public EvaluationContextBuilder<RowT> rowAccessor(RowAccessor<RowT> rowAccessor) {
            this.rowAccessor = Objects.requireNonNull(rowAccessor, "rowAccessor");
            return this;
        }

        @Override
        public EvaluationContext<RowT> build() {
            return new ContextImpl<RowT>(this.timeProvider, new ToInternalGenericAdapter<RowT>(this.rowAccessor));
        }
    }

    private static final class RejectSubQueriesValidator
    extends SqlShuttle {
        private static final RejectSubQueriesValidator INSTANCE = new RejectSubQueriesValidator();

        private RejectSubQueriesValidator() {
        }

        @Nullable
        public SqlNode visit(SqlCall call) {
            if (call.getKind().belongsTo((Collection)SqlKind.TOP_LEVEL)) {
                String message = SqlExpressionFactoryAdapter.getMessagePrefix((SqlNode)call) + ": Subqueries are not supported in given context.";
                throw new Util.FoundOne((Object)message);
            }
            return super.visit(call);
        }
    }

    private static final class RejectContextDependentFunctionValidator
    extends SqlShuttle {
        private static final RejectContextDependentFunctionValidator INSTANCE = new RejectContextDependentFunctionValidator();
        private static final Set<String> UNSUPPORTED_FUNCTIONS = Set.of("CURRENT_DATE", "LOCALTIME", "LOCALTIMESTAMP", "CURRENT_USER");

        private RejectContextDependentFunctionValidator() {
        }

        @Nullable
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple() && UNSUPPORTED_FUNCTIONS.contains(id.getSimple())) {
                String message = SqlExpressionFactoryAdapter.getMessagePrefix((SqlNode)id) + ": " + id.getSimple() + " is not supported in given context.";
                throw new Util.FoundOne((Object)message);
            }
            return super.visit(id);
        }
    }

    private static final class RejectAggregatesValidator
    extends SqlShuttle {
        private static final RejectAggregatesValidator INSTANCE = new RejectAggregatesValidator();

        private RejectAggregatesValidator() {
        }

        @Nullable
        public SqlNode visit(SqlCall call) {
            if (call.getKind().belongsTo((Collection)SqlKind.AGGREGATE)) {
                String message = SqlExpressionFactoryAdapter.getMessagePrefix((SqlNode)call) + ": Aggregates are not supported in given context.";
                throw new Util.FoundOne((Object)message);
            }
            return super.visit(call);
        }
    }

    private static class PredicateAdapter
    implements IgnitePredicate {
        private final SqlPredicate delegate;

        private PredicateAdapter(SqlPredicate delegate) {
            this.delegate = delegate;
        }

        @Override
        public <RowT> boolean test(EvaluationContext<RowT> context, RowT row) {
            return this.delegate.test((SqlEvaluationContext)Commons.cast(context), row);
        }
    }

    private static class ContextImpl<RowT>
    implements EvaluationContext<RowT>,
    SqlEvaluationContext<RowT> {
        private final LongSupplier timeProvider;
        private final RowAccessor<RowT> rowAccessor;

        private ContextImpl(LongSupplier timeProvider, RowAccessor<RowT> rowAccessor) {
            this.timeProvider = timeProvider;
            this.rowAccessor = rowAccessor;
        }

        @Override
        public RowAccessor<RowT> rowAccessor() {
            return this.rowAccessor;
        }

        @Override
        public RowFactoryFactory<RowT> rowFactoryFactory() {
            throw new AssertionError((Object)"Should not get here");
        }

        @Override
        @Nullable
        public RowT correlatedVariable(int id) {
            return null;
        }

        @Override
        public ExecutableTableRegistry tableRegistry() {
            throw new AssertionError((Object)"Should not get here");
        }

        @Nullable
        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            throw new AssertionError((Object)"Should not get here");
        }

        public QueryProvider getQueryProvider() {
            throw new AssertionError((Object)"Should not get here");
        }

        @Nullable
        public Object get(String name) {
            if (DataContext.Variable.CURRENT_TIMESTAMP.camelName.equals(name)) {
                return this.timeProvider.getAsLong();
            }
            ExceptionUtils.sneakyThrow(new ExpressionEvaluationException("Unexpected context variable requested: " + name));
            throw new AssertionError((Object)"Should not get here");
        }
    }
}

