/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTracker;

public final class NoOpMemoryTracker
implements MemoryTracker {
    private final AtomicBoolean closed = new AtomicBoolean();

    public static MemoryTracker create() {
        return new NoOpMemoryTracker();
    }

    private NoOpMemoryTracker() {
    }

    @Override
    public void acquire(long size) {
        assert (size >= 0L);
        this.checkClosed();
    }

    @Override
    public boolean tryAcquire(long size) {
        assert (size >= 0L);
        this.checkClosed();
        return true;
    }

    @Override
    public void release(long size) {
        assert (size >= 0L);
        this.checkClosed();
    }

    @Override
    public long reserved() {
        return 0L;
    }

    @Override
    public long maxReserved() {
        return 0L;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Memory tracker is closed.");
        }
    }
}

