/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.fsm;

import java.time.ZoneId;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.sql.engine.SqlOperationContext;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhaseHandler;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ValidationHelper;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;

class OptimizingPhaseHandler
implements ExecutionPhaseHandler {
    static final ExecutionPhaseHandler INSTANCE = new OptimizingPhaseHandler();

    private OptimizingPhaseHandler() {
    }

    @Override
    public Result handle(Query query) {
        ParsedResult result = query.parsedResult;
        assert (result != null) : "Query is expected to be parsed at this phase";
        SqlOperationContext operationContext = OptimizingPhaseHandler.buildContext(query, result);
        CompletionStage awaitFuture = query.executor.waitForMetadata(operationContext.operationTime()).thenCompose(none -> query.executor.prepare(result, operationContext).thenAccept(plan -> {
            if (query.txContext.explicitTx() == null) {
                query.txContext.updateObservableTime(query.executor.deriveMinimalRequiredTime((QueryPlan)plan));
            }
            query.plan = plan;
        }));
        return Result.proceedAfter((CompletableFuture<Void>)awaitFuture);
    }

    private static SqlOperationContext buildContext(Query query, ParsedResult result) {
        SqlOperationContext operationContext;
        SqlOperationContext retryContext = query.operationContext;
        if (retryContext != null) {
            return retryContext;
        }
        ValidationHelper.validateParsedStatement(query.properties, result);
        ValidationHelper.validateDynamicParameters(result.dynamicParamsCount(), query.params, true);
        OptimizingPhaseHandler.ensureStatementMatchesTx(result.queryType(), query.txContext);
        HybridTimestamp operationTime = query.executor.deriveOperationTime(query.txContext);
        String schemaName = query.properties.defaultSchema();
        ZoneId timeZoneId = query.properties.timeZoneId();
        String userName = query.properties.userName();
        query.operationContext = operationContext = SqlOperationContext.builder().queryId(query.id).cancel(query.cancel).parameters(query.params).timeZoneId(timeZoneId).defaultSchemaName(schemaName).operationTime(operationTime).txContext(query.txContext).txUsedListener(tx -> {
            query.usedTransaction = tx;
        }).errorHandler(query::setError).userName(userName).securityContext(query.securityContext).build();
        return operationContext;
    }

    private static void ensureStatementMatchesTx(SqlQueryType queryType, QueryTransactionContext txContext) {
        QueryTransactionWrapper txWrapper = txContext.explicitTx();
        if (txWrapper == null) {
            return;
        }
        if (!queryType.supportsExplicitTransactions()) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, queryType.displayName() + " doesn't support transactions.");
        }
        if (SqlQueryType.DML == queryType && txWrapper.unwrap().isReadOnly()) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, queryType.displayName() + " cannot be started by using read only transactions.");
        }
    }
}

