/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.fsm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ignite3.internal.sql.ResultSetMetadataImpl;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursorImpl;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.TxControlInsideExternalTxNotSupportedException;
import org.apache.ignite3.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite3.internal.sql.engine.exec.fsm.DdlBatchingHelper;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ValidationHelper;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlStartTransaction;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite3.internal.sql.engine.tx.ScriptTransactionContext;
import org.apache.ignite3.internal.sql.engine.util.IteratorToDataCursorAdapter;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

class MultiStatementHandler {
    private static final ResultSetMetadata EMPTY_RESULT_SET_METADATA = new ResultSetMetadataImpl(Collections.emptyList());
    private final Query query;
    private final Queue<ScriptStatement> statements;
    private final ScriptTransactionContext scriptTxContext;
    private final Queue<CompletableFuture<Void>> inFlightSelects = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
    private final Queue<CompletableFuture<Void>> dependentQueries = new ConcurrentLinkedQueue<CompletableFuture<Void>>();

    MultiStatementHandler(TransactionalOperationTracker txTracker, Query query, QueryTransactionContext txContext, List<ParsedResult> parsedResults, Object[] params) {
        this.query = query;
        this.statements = MultiStatementHandler.prepareStatementsQueue(parsedResults, params);
        this.scriptTxContext = new ScriptTransactionContext(txContext, txTracker, query.executor.licenseChecker());
    }

    private static Queue<ScriptStatement> prepareStatementsQueue(List<ParsedResult> parsedResults, Object[] params) {
        assert (!parsedResults.isEmpty());
        int paramsCount = parsedResults.stream().mapToInt(ParsedResult::dynamicParamsCount).sum();
        ValidationHelper.validateDynamicParameters(paramsCount, params, true);
        ScriptStatement[] results = new ScriptStatement[parsedResults.size()];
        boolean txControlStatementFound = false;
        CompletableFuture<AsyncSqlCursor<InternalSqlRow>> prevCursorFuture = null;
        for (int i = parsedResults.size() - 1; i >= 0; --i) {
            ParsedResult result = parsedResults.get(i);
            Object[] params0 = Arrays.copyOfRange(params, paramsCount - result.dynamicParamsCount(), paramsCount);
            paramsCount -= result.dynamicParamsCount();
            boolean unfinishedTxBlock = false;
            if (!txControlStatementFound && result.queryType() == SqlQueryType.TX_CONTROL) {
                unfinishedTxBlock = result.parsedTree() instanceof IgniteSqlStartTransaction;
                txControlStatementFound = true;
            }
            results[i] = new ScriptStatement(i, result, params0, unfinishedTxBlock, prevCursorFuture);
            prevCursorFuture = results[i].cursorFuture;
        }
        return new ArrayBlockingQueue<ScriptStatement>(results.length, false, List.of(results));
    }

    CompletableFuture<AsyncSqlCursor<InternalSqlRow>> processNext() {
        ScriptStatement scriptStatement = this.statements.poll();
        assert (scriptStatement != null);
        CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFuture = scriptStatement.cursorFuture;
        try {
            CompletionStage<Object> fut;
            if (cursorFuture.isDone()) {
                return cursorFuture;
            }
            int statementNum = scriptStatement.idx;
            ParsedResult parsedResult = scriptStatement.parsedResult;
            Object[] params = scriptStatement.dynamicParams;
            CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCurFut = scriptStatement.nextStatementFuture;
            if (parsedResult.queryType() == SqlQueryType.TX_CONTROL) {
                ValidationHelper.validateQueryType(this.query.properties.allowedQueryTypes(), SqlQueryType.TX_CONTROL);
                if (!this.inFlightSelects.isEmpty()) {
                    this.inFlightSelects.clear();
                }
                fut = scriptStatement.unfinishedTxBlock ? CompletableFuture.failedFuture(new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Transaction block doesn't have a COMMIT statement at the end.")) : this.scriptTxContext.handleControlStatement(parsedResult.parsedTree()).thenApply(ignored -> new AsyncSqlCursorImpl(parsedResult.queryType(), EMPTY_RESULT_SET_METADATA, new IteratorToDataCursorAdapter(Collections.emptyIterator()), nextCurFut));
            } else if (parsedResult.queryType() == SqlQueryType.DDL) {
                ArrayList<QueryExecutor.ParsedResultWithNextCursorFuture> ddlBatch = new ArrayList<QueryExecutor.ParsedResultWithNextCursorFuture>();
                while (true) {
                    ddlBatch.add(new QueryExecutor.ParsedResultWithNextCursorFuture(scriptStatement.parsedResult, scriptStatement.nextStatementFuture));
                    ScriptStatement statement = this.statements.peek();
                    if (statement == null || statement.parsedResult.queryType() != SqlQueryType.DDL || !DdlBatchingHelper.isCompatible(scriptStatement.parsedResult, statement.parsedResult)) break;
                    scriptStatement = statement;
                    this.statements.poll();
                }
                fut = this.query.executor.executeChildBatch(this.query, this.scriptTxContext, statementNum, ddlBatch);
            } else {
                this.scriptTxContext.registerCursorFuture(parsedResult.queryType(), cursorFuture);
                fut = this.query.executor.executeChildQuery(this.query, this.scriptTxContext, statementNum, parsedResult, params, nextCurFut);
            }
            boolean implicitTx = this.scriptTxContext.explicitTx() == null;
            boolean lastStatement = scriptStatement.isLastStatement();
            fut.whenComplete((cursor, ex) -> {
                if (ex != null) {
                    this.scriptTxContext.onError((Throwable)ex);
                    cursorFuture.completeExceptionally((Throwable)ex);
                    this.cancelAll((Throwable)ex);
                    return;
                }
                cursorFuture.complete((AsyncSqlCursor<InternalSqlRow>)cursor);
                if (!cursor.onClose().isDone()) {
                    this.dependentQueries.add(cursor.onClose());
                }
                if (lastStatement) {
                    this.scheduleTermination();
                } else {
                    CompletableFuture<Object> triggerFuture;
                    ScriptStatement nextStatement = this.statements.peek();
                    if (implicitTx) {
                        triggerFuture = cursor.queryType() != SqlQueryType.QUERY ? cursor.onFirstPageReady() : CompletableFutures.nullCompletedFuture();
                    } else if (cursor.queryType() == SqlQueryType.QUERY) {
                        this.inFlightSelects.add((CompletableFuture<Void>)CompletableFuture.anyOf(cursor.onClose(), cursor.onFirstPageReady()).handle((r, e) -> null));
                        if (nextStatement != null && nextStatement.parsedResult.queryType() == SqlQueryType.DML) {
                            triggerFuture = CompletableFuture.allOf((CompletableFuture[])this.inFlightSelects.toArray(CompletableFuture[]::new));
                            this.inFlightSelects.clear();
                        } else {
                            triggerFuture = CompletableFutures.nullCompletedFuture();
                        }
                    } else {
                        CompletableFuture<Void> prefetchFuture = cursor.onFirstPageReady();
                        assert (prefetchFuture.isDone() && !prefetchFuture.isCompletedExceptionally()) : "prefetch future is expected to be completed successfully, but was " + (prefetchFuture.isDone() ? "completed exceptionally" : "not completed");
                        triggerFuture = CompletableFutures.nullCompletedFuture();
                    }
                    ((CompletableFuture)triggerFuture.thenRunAsync(this::processNext, this.query.executor::execute)).exceptionally(e -> {
                        this.cancelAll((Throwable)e);
                        return null;
                    });
                }
            });
        }
        catch (TxControlInsideExternalTxNotSupportedException txEx) {
            this.scriptTxContext.onError(txEx);
            cursorFuture.completeExceptionally(txEx);
        }
        catch (Throwable e) {
            this.scriptTxContext.onError(e);
            cursorFuture.completeExceptionally(e);
            this.cancelAll(e);
        }
        return cursorFuture;
    }

    private void cancelAll(Throwable cause) {
        for (ScriptStatement scriptStatement : this.statements) {
            CompletableFuture<AsyncSqlCursor<InternalSqlRow>> fut = scriptStatement.cursorFuture;
            if (fut.isDone()) continue;
            fut.completeExceptionally(new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, "The script execution was canceled due to an error in the previous statement.", cause));
        }
        this.scheduleTermination();
    }

    private void scheduleTermination() {
        CompletableFuture.allOf((CompletableFuture[])this.dependentQueries.toArray(CompletableFuture[]::new)).whenComplete((ignored, ex) -> this.query.terminate());
    }

    private static class ScriptStatement {
        private final CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFuture = new CompletableFuture();
        private final CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextStatementFuture;
        private final ParsedResult parsedResult;
        private final Object[] dynamicParams;
        private final int idx;
        private final boolean unfinishedTxBlock;

        private ScriptStatement(int idx, ParsedResult parsedResult, Object[] dynamicParams, boolean unfinishedTxBlock, @Nullable CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextStatementFuture) {
            this.idx = idx;
            this.parsedResult = parsedResult;
            this.dynamicParams = dynamicParams;
            this.nextStatementFuture = nextStatementFuture;
            this.unfinishedTxBlock = unfinishedTxBlock;
        }

        boolean isLastStatement() {
            return this.nextStatementFuture == null;
        }
    }
}

