/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowAccessor;
import org.apache.ignite3.internal.sql.engine.exec.SqlEvaluationContext;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlComparator;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

class ComparatorImplementor {
    ComparatorImplementor() {
    }

    SqlComparator implement(final RelCollation collation) {
        assert (collation != null && !CollectionUtils.nullOrEmpty(collation.getFieldCollations())) : collation;
        return new SqlComparator(){

            @Override
            public <RowT> int compare(SqlEvaluationContext<RowT> context, RowT r1, RowT r2) {
                RowAccessor<RowT> hnd = context.rowAccessor();
                List collations = collation.getFieldCollations();
                int colsCountRow1 = hnd.columnsCount(r1);
                int colsCountRow2 = hnd.columnsCount(r2);
                int maxCols = Math.min(Math.max(colsCountRow1, colsCountRow2), collations.size());
                for (int i = 0; i < maxCols; ++i) {
                    int res;
                    boolean ascending;
                    RelFieldCollation field = (RelFieldCollation)collations.get(i);
                    boolean bl = ascending = field.direction == RelFieldCollation.Direction.ASCENDING;
                    if (i == colsCountRow1) {
                        return ascending ? -1 : 1;
                    }
                    if (i == colsCountRow2) {
                        return ascending ? 1 : -1;
                    }
                    int fieldIdx = field.getFieldIndex();
                    Object c1 = hnd.get(fieldIdx, r1);
                    Object c2 = hnd.get(fieldIdx, r2);
                    int nullComparison = field.nullDirection.nullComparison;
                    int n = res = ascending ? ComparatorImplementor.compare(c1, c2, nullComparison) : ComparatorImplementor.compare(c2, c1, -nullComparison);
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        };
    }

    SqlComparator implement(final List<RelFieldCollation> left, final List<RelFieldCollation> right, final ImmutableBitSet equalNulls) {
        if (CollectionUtils.nullOrEmpty(left) || CollectionUtils.nullOrEmpty(right) || left.size() != right.size()) {
            throw new IllegalArgumentException("Both inputs should be non-empty and have the same size: left=" + (Serializable)(left != null ? Integer.valueOf(left.size()) : "null") + ", right=" + (Serializable)(right != null ? Integer.valueOf(right.size()) : "null"));
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get((int)i).nullDirection.nullComparison != right.get((int)i).nullDirection.nullComparison) {
                throw new IllegalArgumentException("Can't be compared: left=" + left.get(i) + ", right=" + right.get(i));
            }
            if (left.get((int)i).direction == right.get((int)i).direction) continue;
            throw new IllegalArgumentException("Can't be compared: left=" + left.get(i) + ", right=" + right.get(i));
        }
        return new SqlComparator(){

            @Override
            public <RowT> int compare(SqlEvaluationContext<RowT> context, RowT r1, RowT r2) {
                boolean hasNulls = false;
                RowAccessor<RowT> hnd = context.rowAccessor();
                for (int i = 0; i < left.size(); ++i) {
                    int res;
                    RelFieldCollation leftField = (RelFieldCollation)left.get(i);
                    RelFieldCollation rightField = (RelFieldCollation)right.get(i);
                    int leftIdx = leftField.getFieldIndex();
                    int rightIdx = rightField.getFieldIndex();
                    Object c1 = hnd.get(leftIdx, r1);
                    Object c2 = hnd.get(rightIdx, r2);
                    if (!equalNulls.get(leftIdx) && c1 == null && c2 == null) {
                        hasNulls = true;
                        continue;
                    }
                    int nullComparison = leftField.nullDirection.nullComparison;
                    int n = res = leftField.direction == RelFieldCollation.Direction.ASCENDING ? ComparatorImplementor.compare(c1, c2, nullComparison) : ComparatorImplementor.compare(c2, c1, -nullComparison);
                    if (res == 0) continue;
                    return res;
                }
                return hasNulls ? 1 : 0;
            }
        };
    }

    private static int compare(@Nullable Object o1, @Nullable Object o2, int nullComparison) {
        Comparable c1 = (Comparable)o1;
        Comparable c2 = (Comparable)o2;
        return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
    }
}

