/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.ExtendedProjectedTuple;
import org.apache.ignite3.internal.sql.engine.util.ProjectedTuple;

public class SecondaryStoreRowConverterImpl
implements TableRowConverter {
    private final int[] requiredColumnsMapping;
    private final Int2ObjectMap<VirtualColumn> virtualColumns;
    private final boolean useIdentityMapping;

    SecondaryStoreRowConverterImpl(SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor, TableDescriptor descriptor, int[] requiredColumns, Int2ObjectMap<VirtualColumn> virtualColumns) {
        boolean bl = this.useIdentityMapping = virtualColumns.isEmpty() && SecondaryStoreRowConverterImpl.isTrimmingProject(requiredColumns, schemaDescriptor.length());
        if (this.useIdentityMapping) {
            this.requiredColumnsMapping = requiredColumns;
            this.virtualColumns = virtualColumns;
        } else {
            Mapping inverse = Commons.trimmingMapping(descriptor.columnsCount(), ImmutableBitSet.of((int[])requiredColumns)).inverse();
            this.requiredColumnsMapping = new int[requiredColumns.length];
            this.virtualColumns = new Int2ObjectOpenHashMap();
            for (int i = 0; i < requiredColumns.length; ++i) {
                int mappedColumnIndex;
                int columnIndex = requiredColumns[i];
                this.requiredColumnsMapping[i] = mappedColumnIndex = inverse.getSource(columnIndex);
                if (columnIndex < schemaDescriptor.columns().size()) continue;
                this.virtualColumns.put(mappedColumnIndex, (Object)((VirtualColumn)virtualColumns.get(columnIndex)));
            }
        }
    }

    private static boolean isTrimmingProject(int[] mapping, int length) {
        int previous = -1;
        for (int i : mapping) {
            if (i <= previous || i >= length) {
                return false;
            }
            previous = i;
        }
        return true;
    }

    @Override
    public <RowT> BinaryRowEx toFullRow(ExecutionContext<RowT> executionContext, RowT row) {
        throw new UnsupportedOperationException("SecondaryStoreRowConverterImpl#toFullRow");
    }

    @Override
    public <RowT> BinaryRowEx toKeyRow(ExecutionContext<RowT> executionContext, RowT row) {
        throw new UnsupportedOperationException("SecondaryStoreRowConverterImpl#toKeyRow");
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> executionContext, BinaryRow tableRow, RowFactory<RowT> factory) {
        BinaryTuple tuple;
        assert (tableRow.schemaVersion() == 0);
        BinaryTuple tableTuple = new BinaryTuple(this.requiredColumnsMapping.length - this.virtualColumns.size(), tableRow.tupleSlice());
        if (!this.virtualColumns.isEmpty()) {
            ExtendedProjectedTuple internalTuple = new ExtendedProjectedTuple(tableTuple, this.requiredColumnsMapping, this.virtualColumns);
            tuple = new BinaryTuple(internalTuple.elementCount(), internalTuple.byteBuffer());
        } else if (this.useIdentityMapping) {
            tuple = tableTuple;
        } else {
            ProjectedTuple internalTuple = new ProjectedTuple(tableTuple, this.requiredColumnsMapping);
            tuple = new BinaryTuple(internalTuple.elementCount(), internalTuple.byteBuffer());
        }
        return factory.create(tuple);
    }
}

