/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.InternalTupleEx;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterImpl;
import org.apache.ignite3.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite3.internal.sql.engine.util.ExtendedProjectedTuple;
import org.apache.ignite3.internal.sql.engine.util.ProjectedTuple;

public class ProjectedTableRowConverterImpl
extends TableRowConverterImpl {
    private final int[] requiredColumnsMapping;
    private final Int2ObjectMap<VirtualColumn> virtualColumns;

    ProjectedTableRowConverterImpl(SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor, int[] requiredColumns, Int2ObjectMap<VirtualColumn> extraColumns) {
        super(schemaRegistry, schemaDescriptor);
        this.requiredColumnsMapping = requiredColumns;
        this.virtualColumns = extraColumns;
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> ectx, BinaryRow tableRow, RowFactory<RowT> factory) {
        boolean rowSchemaMatches = tableRow.schemaVersion() == this.schemaDescriptor.version();
        InternalTupleEx tableTuple = rowSchemaMatches ? new BinaryTuple(this.schemaDescriptor.length(), tableRow.tupleSlice()) : this.schemaRegistry.resolve(tableRow, this.schemaDescriptor);
        ProjectedTuple tuple = !this.virtualColumns.isEmpty() ? new ExtendedProjectedTuple(tableTuple, this.requiredColumnsMapping, this.virtualColumns) : new ProjectedTuple(tableTuple, this.requiredColumnsMapping);
        return factory.create(tuple);
    }
}

