/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import java.time.ZoneId;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.sql.engine.QueryCancel;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public final class SqlOperationContext {
    private final Set<String> excludedNodes = ConcurrentHashMap.newKeySet();
    private final UUID queryId;
    private final ZoneId timeZoneId;
    private final Object[] parameters;
    private final HybridTimestamp operationTime;
    private final QueryTransactionContext txContext;
    @Nullable
    private final QueryCancel cancel;
    @Nullable
    private final String defaultSchemaName;
    @Nullable
    private final Consumer<QueryTransactionWrapper> txUsedListener;
    @Nullable
    private final Consumer<Throwable> errorListener;
    @Nullable
    private final String userName;
    @Nullable
    private final Long topologyVersion;
    @Nullable
    private final AtomicReference<QueryTransactionWrapper> retryTxHolder;
    private final SecurityContext securityContext;

    private SqlOperationContext(UUID queryId, ZoneId timeZoneId, Object[] parameters, HybridTimestamp operationTime, SecurityContext securityContext, @Nullable QueryTransactionContext txContext, @Nullable QueryCancel cancel, @Nullable String defaultSchemaName, @Nullable Consumer<QueryTransactionWrapper> txUsedListener, @Nullable Consumer<Throwable> errorListener, @Nullable String userName, @Nullable Long topologyVersion, @Nullable QueryTransactionWrapper retryTx) {
        this.queryId = queryId;
        this.timeZoneId = timeZoneId;
        this.parameters = parameters;
        this.operationTime = operationTime;
        this.txContext = txContext;
        this.cancel = cancel;
        this.defaultSchemaName = defaultSchemaName;
        this.txUsedListener = txUsedListener;
        this.errorListener = errorListener;
        this.userName = userName;
        this.topologyVersion = topologyVersion;
        this.retryTxHolder = new AtomicReference<QueryTransactionWrapper>(retryTx);
        this.securityContext = securityContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SqlOperationContext withTransactionForRetry(QueryTransactionWrapper tx) {
        return new SqlOperationContext(this.queryId, this.timeZoneId, this.parameters, tx.unwrap().schemaTimestamp(), this.securityContext, this.txContext, this.cancel, this.defaultSchemaName, this.txUsedListener, this.errorListener, this.userName, this.topologyVersion, tx);
    }

    public UUID queryId() {
        return this.queryId;
    }

    public Object[] parameters() {
        return this.parameters;
    }

    @Nullable
    public QueryCancel cancel() {
        return this.cancel;
    }

    public ZoneId timeZoneId() {
        return this.timeZoneId;
    }

    @Nullable
    public String userName() {
        return this.userName;
    }

    @Nullable
    public String defaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Nullable
    public QueryTransactionContext txContext() {
        return this.txContext;
    }

    @Nullable
    public Long topologyVersion() {
        return this.topologyVersion;
    }

    public void notifyTxUsed(QueryTransactionWrapper tx) {
        if (this.txUsedListener != null) {
            this.txUsedListener.accept(tx);
        }
    }

    public void notifyError(Throwable th) {
        if (this.errorListener != null) {
            this.errorListener.accept(th);
        }
    }

    public HybridTimestamp operationTime() {
        return this.operationTime;
    }

    public void excludeNode(String nodeName) {
        this.excludedNodes.add(nodeName);
    }

    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Nullable
    public Predicate<String> nodeExclusionFilter() {
        Set<String> excludedNodes = Set.copyOf(this.excludedNodes);
        return excludedNodes.isEmpty() ? null : excludedNodes::contains;
    }

    @Nullable
    public QueryTransactionWrapper retryTx() {
        return this.retryTxHolder.getAndSet(null);
    }

    public static class Builder {
        private UUID queryId;
        private ZoneId timeZoneId;
        private Object[] parameters = ArrayUtils.OBJECT_EMPTY_ARRAY;
        private HybridTimestamp operationTime;
        @Nullable
        private QueryTransactionContext txContext;
        @Nullable
        private Consumer<QueryTransactionWrapper> txUsedListener;
        @Nullable
        private Consumer<Throwable> errorListener;
        @Nullable
        private QueryCancel cancel;
        @Nullable
        private String defaultSchemaName;
        @Nullable
        private String userName;
        @Nullable
        private Long topologyVersion;
        private SecurityContext securityContext;

        public Builder cancel(@Nullable QueryCancel cancel) {
            this.cancel = Objects.requireNonNull(cancel);
            return this;
        }

        public Builder queryId(UUID queryId) {
            this.queryId = Objects.requireNonNull(queryId);
            return this;
        }

        public Builder parameters(Object ... parameters) {
            this.parameters = Objects.requireNonNull(parameters);
            return this;
        }

        public Builder timeZoneId(ZoneId timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public Builder defaultSchemaName(@Nullable String defaultSchemaName) {
            this.defaultSchemaName = defaultSchemaName;
            return this;
        }

        public Builder operationTime(HybridTimestamp operationTime) {
            this.operationTime = operationTime;
            return this;
        }

        public Builder txContext(@Nullable QueryTransactionContext txContext) {
            this.txContext = txContext;
            return this;
        }

        public Builder txUsedListener(Consumer<QueryTransactionWrapper> txUsedListener) {
            this.txUsedListener = txUsedListener;
            return this;
        }

        public Builder errorHandler(Consumer<Throwable> errorListener) {
            this.errorListener = errorListener;
            return this;
        }

        public Builder userName(@Nullable String userName) {
            this.userName = userName;
            return this;
        }

        public Builder topologyVersion(@Nullable Long topologyVersion) {
            this.topologyVersion = topologyVersion;
            return this;
        }

        public Builder securityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public SqlOperationContext build() {
            return new SqlOperationContext(Objects.requireNonNull(this.queryId, "queryId"), Objects.requireNonNull(this.timeZoneId, "timeZoneId"), Objects.requireNonNull(this.parameters, "parameters"), Objects.requireNonNull(this.operationTime, "operationTime"), this.securityContext, this.txContext, this.cancel, this.defaultSchemaName, this.txUsedListener, this.errorListener, this.userName, this.topologyVersion, null);
        }
    }
}

