/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.api;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.sql.StatementBuilderImpl;
import org.apache.ignite3.internal.sql.StatementImpl;
import org.apache.ignite3.internal.sql.SyncResultSetAdapter;
import org.apache.ignite3.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.TraceableException;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.sql.BatchedArguments;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSet;
import org.apache.ignite3.sql.SqlBatchException;
import org.apache.ignite3.sql.SqlException;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.Statement;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteSqlImpl
implements IgniteSql,
IgniteComponent,
Wrapper {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteSqlImpl.class);
    private static final int AWAIT_CURSOR_CLOSE_ON_STOP_IN_SECONDS = 10;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicInteger cursorIdGen = new AtomicInteger();
    private final ConcurrentMap<Integer, AsyncSqlCursor<?>> openedCursors = new ConcurrentHashMap();
    private final QueryProcessor queryProcessor;
    private final HybridTimestampTracker observableTimestampTracker;
    private final Executor commonExecutor;

    public IgniteSqlImpl(QueryProcessor queryProcessor, HybridTimestampTracker observableTimestampTracker, Executor commonExecutor) {
        this.queryProcessor = queryProcessor;
        this.observableTimestampTracker = observableTimestampTracker;
        this.commonExecutor = commonExecutor;
    }

    @Override
    public Statement createStatement(String query) {
        return new StatementImpl(query);
    }

    @Override
    public Statement.StatementBuilder statementBuilder() {
        return new StatementBuilderImpl();
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.closed.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        ArrayList cursorsToClose = new ArrayList(this.openedCursors.values());
        this.openedCursors.clear();
        CompletableFuture[] closeCursorFutures = new CompletableFuture[cursorsToClose.size()];
        int idx = 0;
        for (AsyncSqlCursor cursor : cursorsToClose) {
            closeCursorFutures[idx++] = cursor.closeAsync();
        }
        ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(closeCursorFutures).whenComplete((r, e) -> {
            if (e == null) {
                return;
            }
            Throwable error = IgniteSqlImpl.gatherExceptions(closeCursorFutures);
            assert (error != null);
            LOG.warn("Some cursors were closed abruptly", SqlExceptionMapperUtil.mapToPublicSqlException(error));
        })).orTimeout(10L, TimeUnit.SECONDS).handle((ignored, error) -> {
            if (error instanceof TimeoutException) {
                LOG.warn("Cursors weren't be closed in {} seconds.", 10);
            }
            return null;
        })).join();
        return CompletableFutures.nullCompletedFuture();
    }

    @Nullable
    private static Throwable gatherExceptions(CompletableFuture<?> ... futures) {
        Throwable error = null;
        for (CompletableFuture<?> fut : futures) {
            if (!fut.isCompletedExceptionally()) continue;
            try {
                fut.getNow(null);
            }
            catch (Throwable th) {
                Throwable unwrapped = ExceptionUtils.unwrapCause(th);
                if (error == null) {
                    error = unwrapped;
                    continue;
                }
                error.addSuppressed(unwrapped);
            }
        }
        return error;
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        CompletableFuture<AsyncResultSet<SqlRow>> future = this.executeAsync(transaction, cancellationToken, query, arguments);
        return new SyncResultSetAdapter<SqlRow>(IgniteSqlImpl.sync(future));
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        CompletableFuture<AsyncResultSet<SqlRow>> future = this.executeAsync(transaction, cancellationToken, statement, arguments);
        return new SyncResultSetAdapter<SqlRow>(IgniteSqlImpl.sync(future));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        CompletableFuture<AsyncResultSet<T>> future = this.executeAsync(transaction, mapper, cancellationToken, query, arguments);
        return new SyncResultSetAdapter<T>(IgniteSqlImpl.sync(future));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        Objects.requireNonNull(statement);
        CompletableFuture<AsyncResultSet<T>> future = this.executeAsync(transaction, mapper, statement, arguments);
        return new SyncResultSetAdapter<T>(IgniteSqlImpl.sync(future));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return IgniteSqlImpl.sync(this.executeBatchAsync(transaction, cancellationToken, dmlQuery, batch));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        return IgniteSqlImpl.sync(this.executeBatchAsync(transaction, cancellationToken, dmlStatement, batch));
    }

    @Override
    public void executeScript(String query, Object ... arguments) {
        this.executeScript(null, query, arguments);
    }

    @Override
    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        Objects.requireNonNull(query);
        IgniteSqlImpl.sync(this.executeScriptAsync(cancellationToken, query, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.executeAsyncInternal(transaction, cancellationToken, this.createStatement(query), arguments);
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.executeAsyncInternal(transaction, cancellationToken, statement, arguments);
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<AsyncResultSet<SqlRow>> executeAsyncInternal(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        CompletionStage result;
        assert (statement.pageSize() > 0) : statement.pageSize();
        int pageSize = statement.pageSize();
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(IgniteSqlImpl.nodeIsStoppingException());
        }
        try {
            SqlProperties properties = IgniteSqlImpl.toPropertiesBuilder(statement).allowedQueryTypes(SqlQueryType.SINGLE_STMT_TYPES).allowMultiStatement(false);
            SecurityContext securityContext = SecurityContextHolder.getOrThrow();
            result = this.queryProcessor.queryAsync(properties, this.observableTimestampTracker, (InternalTransaction)transaction, cancellationToken, statement.query(), securityContext, arguments).thenCompose(cur -> {
                if (!this.busyLock.enterBusy()) {
                    cur.closeAsync();
                    return CompletableFuture.failedFuture(IgniteSqlImpl.nodeIsStoppingException());
                }
                try {
                    int cursorId = this.registerCursor((AsyncSqlCursor<?>)cur);
                    cur.onClose().whenComplete((r, e) -> this.openedCursors.remove(cursorId));
                    CompletionStage completionStage = cur.requestNextAsync(pageSize).thenApply(batchRes -> new AsyncResultSetImpl((AsyncSqlCursor<InternalSqlRow>)cur, (AsyncCursor.BatchedResult<InternalSqlRow>)batchRes, pageSize));
                    return completionStage;
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            });
        }
        catch (Exception e) {
            CompletableFuture<AsyncResultSet<SqlRow>> completableFuture = CompletableFuture.failedFuture(SqlExceptionMapperUtil.mapToPublicSqlException(e));
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
        return ((CompletableFuture)result).exceptionally(th -> {
            Throwable cause = ExceptionUtils.unwrapCause(th);
            throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException(cause));
        });
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return this.executeBatchAsync(transaction, cancellationToken, this.createStatement(query), batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(IgniteSqlImpl.nodeIsStoppingException());
        }
        try {
            SqlProperties properties = IgniteSqlImpl.toPropertiesBuilder(statement);
            CompletableFuture<long[]> completableFuture = IgniteSqlImpl.executeBatchCore(this.queryProcessor, this.observableTimestampTracker, (InternalTransaction)transaction, cancellationToken, statement.query(), batch, properties, this.busyLock::enterBusy, this.busyLock::leaveBusy, this::registerCursor, this.openedCursors::remove, SecurityContextHolder.getOrThrow());
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture<long[]> completableFuture = CompletableFuture.failedFuture(SqlExceptionMapperUtil.mapToPublicSqlException(e));
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public static CompletableFuture<long[]> executeBatchCore(QueryProcessor queryProcessor, HybridTimestampTracker observableTimestampTracker, @Nullable InternalTransaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch, SqlProperties properties, Supplier<Boolean> enterBusy, Runnable leaveBusy, Function<AsyncSqlCursor<?>, Integer> registerCursor, Consumer<Integer> removeCursor, SecurityContext securityContext) {
        SqlProperties properties0 = new SqlProperties(properties).allowedQueryTypes(EnumSet.of(SqlQueryType.DML));
        LongArrayList counters = new LongArrayList(batch.size());
        CompletionStage tail = CompletableFutures.nullCompletedFuture();
        ArrayList batchFuts = new ArrayList(batch.size());
        for (int i = 0; i < batch.size(); ++i) {
            Object[] args = batch.get(i).toArray();
            tail = tail.thenCompose(v -> {
                if (!((Boolean)enterBusy.get()).booleanValue()) {
                    return CompletableFuture.failedFuture(IgniteSqlImpl.nodeIsStoppingException());
                }
                try {
                    CompletionStage completionStage = queryProcessor.queryAsync(properties0, observableTimestampTracker, transaction, cancellationToken, query, securityContext, args).thenCompose(arg_0 -> IgniteSqlImpl.lambda$executeBatchCore$7((Supplier)enterBusy, registerCursor, removeCursor, counters, leaveBusy, arg_0));
                    return completionStage;
                }
                finally {
                    leaveBusy.run();
                }
            });
            batchFuts.add(tail);
        }
        CompletionStage resFut = ((CompletableFuture)tail.exceptionally(ex -> {
            Throwable cause = ExceptionUtils.unwrapCause(ex);
            if (cause instanceof CancellationException) {
                throw (CancellationException)cause;
            }
            Throwable t = SqlExceptionMapperUtil.mapToPublicSqlException(cause);
            if (t instanceof TraceableException) {
                throw new SqlBatchException(((TraceableException)((Object)t)).traceId(), ((TraceableException)((Object)t)).code(), counters.toArray(ArrayUtils.LONG_EMPTY_ARRAY), t.getMessage(), t);
            }
            throw new CompletionException(cause);
        })).thenApply(v -> counters.toArray(ArrayUtils.LONG_EMPTY_ARRAY));
        ((CompletableFuture)resFut).whenComplete((cur, ex) -> {
            if (ExceptionUtils.unwrapCause(ex) instanceof CancellationException) {
                batchFuts.forEach(f -> f.cancel(false));
            }
        });
        return resFut;
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return this.executeScriptAsync(null, query, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(IgniteSqlImpl.nodeIsStoppingException());
        }
        try {
            CompletableFuture<Void> completableFuture = IgniteSqlImpl.executeScriptCore(this.queryProcessor, this.observableTimestampTracker, this.busyLock::enterBusy, this.busyLock::leaveBusy, query, cancellationToken, arguments, new SqlProperties().userName("SYSTEM"), this.commonExecutor, SecurityContextHolder.getOrThrow());
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public static CompletableFuture<Void> executeScriptCore(QueryProcessor queryProcessor, HybridTimestampTracker observableTimestampTracker, Supplier<Boolean> enterBusy, Runnable leaveBusy, String query, @Nullable CancellationToken cancellationToken, @Nullable Object[] arguments, SqlProperties properties, Executor executor, SecurityContext securityContext) {
        SqlProperties properties0 = new SqlProperties(properties).allowedQueryTypes(SqlQueryType.ALL).allowMultiStatement(true);
        CompletableFuture<AsyncSqlCursor<InternalSqlRow>> f = queryProcessor.queryAsync(properties0, observableTimestampTracker, null, cancellationToken, query, securityContext, arguments);
        CompletableFuture<Void> resFut = new CompletableFuture<Void>();
        ScriptHandler handler = new ScriptHandler(resFut, enterBusy, leaveBusy, executor);
        f.whenComplete(handler::processCursor);
        return resFut.exceptionally(th -> {
            Throwable cause = ExceptionUtils.unwrapCause(th);
            throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException(cause));
        });
    }

    private static void validateDmlResult(AsyncCursor.BatchedResult<InternalSqlRow> page) {
        if (page == null || page.items() == null || page.items().size() != 1 || page.items().get(0).fieldCount() != 1 || page.hasMore()) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Invalid DML results: " + page);
        }
    }

    private static SqlProperties toPropertiesBuilder(Statement statement) {
        return new SqlProperties().timeZoneId(statement.timeZoneId()).defaultSchema(IgniteNameUtils.parseIdentifier(statement.defaultSchema())).queryTimeout(statement.queryTimeout(TimeUnit.MILLISECONDS)).userName("SYSTEM");
    }

    private int registerCursor(AsyncSqlCursor<?> cursor) {
        int cursorId = this.cursorIdGen.incrementAndGet();
        AsyncSqlCursor<?> old = this.openedCursors.put(cursorId, cursor);
        assert (old == null);
        return cursorId;
    }

    @TestOnly
    List<AsyncSqlCursor<?>> openedCursors() {
        return List.copyOf(this.openedCursors.values());
    }

    private static SqlException nodeIsStoppingException() {
        return new SqlException(ErrorGroups.Common.NODE_STOPPING_ERR, "Node is stopping");
    }

    private static <T> T sync(CompletableFuture<T> future) {
        return IgniteUtils.getInterruptibly(future);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        if (classToUnwrap.isAssignableFrom(QueryProcessor.class)) {
            return classToUnwrap.cast(this.queryProcessor);
        }
        return classToUnwrap.cast(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ CompletionStage lambda$executeBatchCore$7(Supplier enterBusy, Function registerCursor, Consumer removeCursor, LongArrayList counters, Runnable leaveBusy, AsyncSqlCursor cursor) {
        if (!((Boolean)enterBusy.get()).booleanValue()) {
            cursor.closeAsync();
            return CompletableFuture.failedFuture(IgniteSqlImpl.nodeIsStoppingException());
        }
        try {
            int cursorId = (Integer)registerCursor.apply(cursor);
            CompletionStage completionStage = ((CompletableFuture)cursor.requestNextAsync(1).handle((page, th) -> {
                removeCursor.accept(cursorId);
                cursor.closeAsync();
                if (th != null) {
                    return CompletableFuture.failedFuture(th);
                }
                IgniteSqlImpl.validateDmlResult(page);
                counters.add(((Long)((InternalSqlRow)page.items().get(0)).get(0)).longValue());
                return CompletableFutures.nullCompletedFuture();
            })).thenCompose(Function.identity());
            return completionStage;
        }
        finally {
            leaveBusy.run();
        }
    }

    private static class ScriptHandler {
        private final CompletableFuture<Void> resFut;
        private final List<Throwable> cursorCloseErrors = Collections.synchronizedList(new ArrayList());
        private final Supplier<Boolean> enterBusy;
        private final Runnable leaveBusy;
        private final Executor executor;

        ScriptHandler(CompletableFuture<Void> resFut, Supplier<Boolean> enterBusy, Runnable leaveBusy, Executor executor) {
            this.resFut = resFut;
            this.enterBusy = enterBusy;
            this.leaveBusy = leaveBusy;
            this.executor = executor;
        }

        void processCursor(AsyncSqlCursor<InternalSqlRow> cursor, Throwable scriptError) {
            if (scriptError != null) {
                this.onFail(scriptError);
                return;
            }
            cursor.closeAsync().whenComplete((ignored, cursorCloseError) -> {
                if (cursorCloseError != null) {
                    this.cursorCloseErrors.add((Throwable)cursorCloseError);
                }
                if (!this.enterBusy.get().booleanValue()) {
                    this.onFail(IgniteSqlImpl.nodeIsStoppingException());
                    return;
                }
                try {
                    if (cursor.hasNextResult()) {
                        cursor.nextResult().whenCompleteAsync(this::processCursor, this.executor);
                        return;
                    }
                }
                finally {
                    this.leaveBusy.run();
                }
                this.onComplete();
            });
        }

        private void onComplete() {
            if (!this.cursorCloseErrors.isEmpty()) {
                this.onFail(new IllegalStateException("The script was completed with errors."));
                return;
            }
            this.resFut.complete(null);
        }

        private void onFail(Throwable err) {
            for (Throwable cursorCloseErr : this.cursorCloseErrors) {
                err.addSuppressed(cursorCloseErr);
            }
            this.resFut.completeExceptionally(err);
        }
    }
}

