/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.api;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.binarytuple.BinaryTupleContainer;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.internal.util.TransformingIterator;
import org.apache.ignite3.sql.NoRowSetExpectedException;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class AsyncResultSetImpl<T>
implements AsyncResultSet<T> {
    private final AsyncSqlCursor<InternalSqlRow> cursor;
    private volatile AsyncCursor.BatchedResult<InternalSqlRow> curPage;
    private final int pageSize;

    public AsyncResultSetImpl(AsyncSqlCursor<InternalSqlRow> cursor, AsyncCursor.BatchedResult<InternalSqlRow> page, int pageSize) {
        this.cursor = cursor;
        this.curPage = page;
        this.pageSize = pageSize;
    }

    @Override
    @Nullable
    public ResultSetMetadata metadata() {
        return this.hasRowSet() ? this.cursor.metadata() : null;
    }

    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.cursor.partitionAwarenessMetadata();
    }

    public AsyncSqlCursor<InternalSqlRow> cursor() {
        return this.cursor;
    }

    @Override
    public boolean hasRowSet() {
        SqlQueryType queryType = this.cursor.queryType();
        return queryType.hasRowSet();
    }

    @Override
    public long affectedRows() {
        SqlQueryType queryType = this.cursor.queryType();
        if (!queryType.returnsAffectedRows()) {
            return -1L;
        }
        assert (this.curPage.items().get(0).get(0) instanceof Long) : "Invalid DML result: " + this.curPage;
        return (Long)this.curPage.items().get(0).get(0);
    }

    @Override
    public boolean wasApplied() {
        SqlQueryType queryType = this.cursor.queryType();
        if (!queryType.supportsWasApplied()) {
            return false;
        }
        assert (this.curPage.items().get(0).get(0) instanceof Boolean) : "Invalid DDL/KILL result: " + this.curPage;
        return (Boolean)this.curPage.items().get(0).get(0);
    }

    @Override
    public Iterable<T> currentPage() {
        this.requireResultSet();
        Iterator<InternalSqlRow> it0 = this.curPage.items().iterator();
        ResultSetMetadata meta0 = this.cursor.metadata();
        return () -> new TransformingIterator<InternalSqlRow, Object>(it0, item -> new SqlRowImpl((InternalSqlRow)item, meta0));
    }

    @Override
    public int currentPageSize() {
        this.requireResultSet();
        return this.curPage.items().size();
    }

    @Override
    public CompletableFuture<? extends AsyncResultSet<T>> fetchNextPage() {
        this.requireResultSet();
        return this.cursor.requestNextAsync(this.pageSize).thenApply(page -> {
            this.curPage = page;
            if (!this.curPage.hasMore()) {
                this.closeAsync();
            }
            return this;
        });
    }

    @Override
    public boolean hasMorePages() {
        return this.curPage.hasMore();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.cursor.closeAsync();
    }

    private void requireResultSet() {
        if (!this.hasRowSet()) {
            throw new NoRowSetExpectedException();
        }
    }

    private static class SqlRowImpl
    implements SqlRow,
    BinaryTupleContainer {
        private final InternalSqlRow row;
        private final ResultSetMetadata meta;

        SqlRowImpl(InternalSqlRow row, ResultSetMetadata meta) {
            this.row = row;
            this.meta = meta;
        }

        @Override
        public int columnCount() {
            return this.meta.columns().size();
        }

        @Override
        public String columnName(int columnIndex) {
            return this.meta.columns().get(columnIndex).name();
        }

        @Override
        public int columnIndex(String columnName) {
            return this.meta.indexOf(columnName);
        }

        private int columnIndexChecked(String columnName) {
            int idx = this.columnIndex(columnName);
            if (idx == -1) {
                throw new IllegalArgumentException("Column doesn't exist [name=" + columnName + "]");
            }
            return idx;
        }

        @Override
        public <T> T valueOrDefault(String columnName, T defaultValue) {
            Object ret = this.row.get(this.columnIndexChecked(columnName));
            return (T)(ret != null ? ret : defaultValue);
        }

        @Override
        public Tuple set(String columnName, Object value) {
            throw new UnsupportedOperationException("Operation not supported.");
        }

        @Override
        public <T> T value(String columnName) throws IllegalArgumentException {
            return (T)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public <T> T value(int columnIndex) {
            return (T)this.row.get(columnIndex);
        }

        @Override
        public boolean booleanValue(String columnName) {
            return (Boolean)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public boolean booleanValue(int columnIndex) {
            return (Boolean)this.row.get(columnIndex);
        }

        @Override
        public byte byteValue(String columnName) {
            return (Byte)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public byte byteValue(int columnIndex) {
            return (Byte)this.row.get(columnIndex);
        }

        @Override
        public short shortValue(String columnName) {
            return (Short)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public short shortValue(int columnIndex) {
            return (Short)this.row.get(columnIndex);
        }

        @Override
        public int intValue(String columnName) {
            return (Integer)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public int intValue(int columnIndex) {
            return (Integer)this.row.get(columnIndex);
        }

        @Override
        public long longValue(String columnName) {
            return (Long)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public long longValue(int columnIndex) {
            return (Long)this.row.get(columnIndex);
        }

        @Override
        public float floatValue(String columnName) {
            return ((Float)this.row.get(this.columnIndexChecked(columnName))).floatValue();
        }

        @Override
        public float floatValue(int columnIndex) {
            return ((Float)this.row.get(columnIndex)).floatValue();
        }

        @Override
        public double doubleValue(String columnName) {
            return (Double)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public double doubleValue(int columnIndex) {
            return (Double)this.row.get(columnIndex);
        }

        @Override
        public BigDecimal decimalValue(String columnName) {
            return (BigDecimal)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public BigDecimal decimalValue(int columnIndex) {
            return (BigDecimal)this.row.get(columnIndex);
        }

        @Override
        public String stringValue(String columnName) {
            return (String)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public String stringValue(int columnIndex) {
            return (String)this.row.get(columnIndex);
        }

        @Override
        public byte[] bytesValue(String columnName) {
            return (byte[])this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public byte[] bytesValue(int columnIndex) {
            return (byte[])this.row.get(columnIndex);
        }

        @Override
        public UUID uuidValue(String columnName) {
            return (UUID)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public UUID uuidValue(int columnIndex) {
            return (UUID)this.row.get(columnIndex);
        }

        @Override
        public LocalDate dateValue(String columnName) {
            return (LocalDate)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public LocalDate dateValue(int columnIndex) {
            return (LocalDate)this.row.get(columnIndex);
        }

        @Override
        public LocalTime timeValue(String columnName) {
            return (LocalTime)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public LocalTime timeValue(int columnIndex) {
            return (LocalTime)this.row.get(columnIndex);
        }

        @Override
        public LocalDateTime datetimeValue(String columnName) {
            return (LocalDateTime)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public LocalDateTime datetimeValue(int columnIndex) {
            return (LocalDateTime)this.row.get(columnIndex);
        }

        @Override
        public Instant timestampValue(String columnName) {
            return (Instant)this.row.get(this.columnIndexChecked(columnName));
        }

        @Override
        public Instant timestampValue(int columnIndex) {
            return (Instant)this.row.get(columnIndex);
        }

        @Override
        public ResultSetMetadata metadata() {
            return this.meta;
        }

        @Override
        public BinaryTupleReader binaryTuple() {
            return this.row.asBinaryTuple();
        }

        public String toString() {
            return S.tupleToString(this);
        }
    }
}

