/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.row;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.schema.AssemblyException;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.InvalidTypeException;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaMismatchException;
import org.apache.ignite3.internal.type.DecimalNativeType;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.type.TemporalNativeType;
import org.apache.ignite3.internal.util.TemporalTypeUtils;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class RowAssembler {
    private final int schemaVersion;
    private final List<Column> columns;
    private final BinaryTupleBuilder builder;
    private int curCol;

    public RowAssembler(SchemaDescriptor schema, int totalValueSize) {
        this(schema.version(), schema.columns(), totalValueSize);
    }

    public RowAssembler(SchemaDescriptor schema, int totalValueSize, boolean exactEstimate) {
        this(schema.version(), schema.columns(), totalValueSize, exactEstimate);
    }

    public RowAssembler(int schemaVersion, List<Column> columns, int totalValueSize) {
        this(schemaVersion, columns, totalValueSize, true);
    }

    public RowAssembler(int schemaVersion, List<Column> columns, int totalValueSize, boolean exactEstimate) {
        this.schemaVersion = schemaVersion;
        this.columns = columns;
        this.builder = new BinaryTupleBuilder(columns.size(), totalValueSize, exactEstimate);
        this.curCol = 0;
    }

    public RowAssembler appendValue(@Nullable Object val) throws SchemaMismatchException {
        if (val == null) {
            return this.appendNull();
        }
        NativeType columnType = this.columns.get(this.curCol).type();
        switch (columnType.spec()) {
            case BOOLEAN: {
                return this.appendBoolean((boolean)((Boolean)val));
            }
            case INT8: {
                return this.appendByte((byte)((Byte)val));
            }
            case INT16: {
                return this.appendShort((short)((Short)val));
            }
            case INT32: {
                return this.appendInt((int)((Integer)val));
            }
            case INT64: {
                return this.appendLong((long)((Long)val));
            }
            case FLOAT: {
                return this.appendFloat(((Float)val).floatValue());
            }
            case DOUBLE: {
                return this.appendDouble((double)((Double)val));
            }
            case UUID: {
                return this.appendUuid((UUID)val);
            }
            case TIME: {
                return this.appendTime((LocalTime)val);
            }
            case DATE: {
                return this.appendDate((LocalDate)val);
            }
            case DATETIME: {
                return this.appendDateTime((LocalDateTime)val);
            }
            case TIMESTAMP: {
                return this.appendTimestamp((Instant)val);
            }
            case STRING: {
                return this.appendString((String)val);
            }
            case BYTE_ARRAY: {
                return this.appendBytes((byte[])val);
            }
            case DECIMAL: {
                return this.appendDecimal((BigDecimal)val);
            }
        }
        throw new InvalidTypeException("Unexpected value: " + columnType);
    }

    public RowAssembler appendNull() throws SchemaMismatchException {
        if (!this.columns.get(this.curCol).nullable()) {
            String name = this.columns.get(this.curCol).name();
            throw new SchemaMismatchException(Column.nullConstraintViolationMessage(name));
        }
        this.builder.appendNull();
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendDefault() {
        Column column = this.columns.get(this.curCol);
        return this.appendValue(column.defaultValueForInsert());
    }

    public RowAssembler appendBoolean(boolean val) throws SchemaMismatchException {
        this.checkType(NativeTypes.BOOLEAN);
        this.builder.appendBoolean(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendBoolean(Boolean value) throws SchemaMismatchException {
        return value == null ? this.appendNull() : this.appendBoolean((boolean)value);
    }

    public RowAssembler appendByte(byte val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT8);
        this.builder.appendByte(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendByte(Byte value) throws SchemaMismatchException {
        return value == null ? this.appendNull() : this.appendByte((byte)value);
    }

    public RowAssembler appendShort(short val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT16);
        this.builder.appendShort(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendShort(Short value) throws SchemaMismatchException {
        return value == null ? this.appendNull() : this.appendShort((short)value);
    }

    public RowAssembler appendInt(int val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT32);
        this.builder.appendInt(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendInt(@Nullable Integer value) {
        return value == null ? this.appendNull() : this.appendInt((int)value);
    }

    public RowAssembler appendLong(long val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT64);
        this.builder.appendLong(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendLong(Long value) {
        return value == null ? this.appendNull() : this.appendLong((long)value);
    }

    public RowAssembler appendFloat(float val) throws SchemaMismatchException {
        this.checkType(NativeTypes.FLOAT);
        this.builder.appendFloat(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendFloat(Float value) {
        return value == null ? this.appendNull() : this.appendFloat(value.floatValue());
    }

    public RowAssembler appendDouble(double val) throws SchemaMismatchException {
        this.checkType(NativeTypes.DOUBLE);
        this.builder.appendDouble(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendDouble(Double value) {
        return value == null ? this.appendNull() : this.appendDouble((double)value);
    }

    public RowAssembler appendDecimalNotNull(BigDecimal val) throws SchemaMismatchException {
        this.checkType(ColumnType.DECIMAL);
        Column col = this.columns.get(this.curCol);
        DecimalNativeType type = (DecimalNativeType)col.type();
        BigDecimal scaled = val.setScale(type.scale(), RoundingMode.HALF_UP);
        if (scaled.precision() > type.precision()) {
            throw new SchemaMismatchException(Column.numericFieldOverflow(col.name()));
        }
        this.builder.appendDecimalNotNull(val, type.scale());
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendDecimal(BigDecimal value) {
        return value == null ? this.appendNull() : this.appendDecimalNotNull(value);
    }

    public RowAssembler appendStringNotNull(String val) throws SchemaMismatchException {
        this.checkType(ColumnType.STRING);
        this.builder.appendStringNotNull(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendString(@Nullable String value) {
        return value == null ? this.appendNull() : this.appendStringNotNull(value);
    }

    public RowAssembler appendBytesNotNull(byte[] val) throws SchemaMismatchException {
        this.checkType(ColumnType.BYTE_ARRAY);
        this.builder.appendBytesNotNull(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendBytes(byte[] value) {
        return value == null ? this.appendNull() : this.appendBytesNotNull(value);
    }

    public RowAssembler appendUuidNotNull(UUID uuid) throws SchemaMismatchException {
        this.checkType(NativeTypes.UUID);
        this.builder.appendUuidNotNull(uuid);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendUuid(UUID value) {
        return value == null ? this.appendNull() : this.appendUuidNotNull(value);
    }

    public RowAssembler appendDateNotNull(LocalDate val) throws SchemaMismatchException {
        this.checkType(NativeTypes.DATE);
        this.builder.appendDateNotNull(val);
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendDate(LocalDate value) {
        return value == null ? this.appendNull() : this.appendDateNotNull(value);
    }

    public RowAssembler appendTimeNotNull(LocalTime val) throws SchemaMismatchException {
        this.checkType(ColumnType.TIME);
        this.builder.appendTimeNotNull(this.normalizeTime(val));
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendTime(LocalTime value) {
        return value == null ? this.appendNull() : this.appendTimeNotNull(value);
    }

    public RowAssembler appendDateTimeNotNull(LocalDateTime val) throws SchemaMismatchException {
        this.checkType(ColumnType.DATETIME);
        this.builder.appendDateTimeNotNull(LocalDateTime.of(val.toLocalDate(), this.normalizeTime(val.toLocalTime())));
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendDateTime(LocalDateTime value) {
        return value == null ? this.appendNull() : this.appendDateTimeNotNull(value);
    }

    public RowAssembler appendTimestampNotNull(Instant val) throws SchemaMismatchException {
        this.checkType(ColumnType.TIMESTAMP);
        this.builder.appendTimestampNotNull(Instant.ofEpochSecond(val.getEpochSecond(), this.normalizeNanos(val.getNano())));
        this.shiftColumn();
        return this;
    }

    public RowAssembler appendTimestamp(Instant value) {
        return value == null ? this.appendNull() : this.appendTimestampNotNull(value);
    }

    private LocalTime normalizeTime(LocalTime val) {
        int nanos = this.normalizeNanos(val.getNano());
        return LocalTime.of(val.getHour(), val.getMinute(), val.getSecond(), nanos);
    }

    private int normalizeNanos(int nanos) {
        NativeType type = this.columns.get(this.curCol).type();
        return TemporalTypeUtils.normalizeNanos(nanos, ((TemporalNativeType)type).precision());
    }

    public BinaryRow build() {
        if (this.curCol != 0 && this.columns.size() != this.curCol) {
            throw new AssemblyException("Value column missed: colIdx=" + this.curCol);
        }
        return new BinaryRowImpl(this.schemaVersion, this.builder.build());
    }

    public ByteBuffer buildBinaryTuple() {
        if (this.curCol != 0 && this.columns.size() != this.curCol) {
            throw new AssemblyException(String.format("Columns size is %d, only %d values are set", this.columns.size(), this.curCol));
        }
        return this.builder.build();
    }

    private void checkType(ColumnType type) {
        Column col = this.columns.get(this.curCol);
        if (col.type().spec() != type) {
            throw new InvalidTypeException("Column's type mismatch [column=" + col + ", expectedType=" + col.type().spec() + ", actualType=" + type + "]");
        }
    }

    private void checkType(NativeType type) {
        this.checkType(type.spec());
    }

    private void shiftColumn() {
        ++this.curCol;
    }
}

