/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.deployment;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.security.utils.SecurityService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.DeploymentUnit;
import org.apache.ignite3.internal.deployunit.IgniteDeployment;
import org.apache.ignite3.internal.deployunit.NodesToDeploy;
import org.apache.ignite3.internal.deployunit.UnitStatuses;
import org.apache.ignite3.internal.deployunit.UnitVersionStatus;
import org.apache.ignite3.internal.deployunit.structure.UnitFile;
import org.apache.ignite3.internal.deployunit.structure.UnitFolder;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorageProvider;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.deployment.DeploymentCodeApi;
import org.apache.ignite3.internal.rest.api.deployment.DeploymentStatus;
import org.apache.ignite3.internal.rest.api.deployment.InitialDeployMode;
import org.apache.ignite3.internal.rest.api.deployment.UnitEntry;
import org.apache.ignite3.internal.rest.api.deployment.UnitStatus;
import org.apache.ignite3.internal.rest.deployment.CompletedFileUploadSubscriber;
import org.gridgain.internal.rest.SecurityContextAware;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;

@Controller(value="/management/v1/deployment")
public class DeploymentManagementController
implements DeploymentCodeApi,
ResourceHolder,
SecurityContextAware {
    private static final IgniteLogger LOG = Loggers.forClass(DeploymentManagementController.class);
    private IgniteDeployment deployment;
    private TempStorageProvider tempStorageProvider;
    private final SecurityService securityService;

    public DeploymentManagementController(IgniteDeployment deployment, TempStorageProvider tempStorageProvider, SecurityService securityService) {
        this.deployment = deployment;
        this.tempStorageProvider = tempStorageProvider;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<Boolean> deploy(String unitId, String unitVersion, Publisher<CompletedFileUpload> unitContent, Optional<InitialDeployMode> deployMode, Optional<List<String>> initialNodes) {
        return this.doDeploy(unitId, unitVersion, unitContent, deployMode, initialNodes, false);
    }

    @Override
    public CompletableFuture<Boolean> deployZip(String unitId, String unitVersion, Publisher<CompletedFileUpload> unitContent, Optional<InitialDeployMode> deployMode, Optional<List<String>> initialNodes) {
        return this.doDeploy(unitId, unitVersion, unitContent, deployMode, initialNodes, true);
    }

    private CompletableFuture<Boolean> doDeploy(String unitId, String unitVersion, Publisher<CompletedFileUpload> unitContent, Optional<InitialDeployMode> deployMode, Optional<List<String>> initialNodes, boolean zip) {
        TempStorage tempStorage;
        Version version;
        try {
            version = Version.parseVersion(unitVersion);
            tempStorage = this.tempStorageProvider.tempStorage(unitId, version);
        }
        catch (Exception e) {
            return Flux.from(unitContent).doOnNext(completedFileUpload -> {
                try {
                    completedFileUpload.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }).collectList().toFuture().thenCompose(unused -> CompletableFuture.failedFuture(e));
        }
        CompletedFileUploadSubscriber subscriber = new CompletedFileUploadSubscriber(tempStorage, zip);
        unitContent.subscribe((Subscriber)subscriber);
        NodesToDeploy nodesToDeploy = initialNodes.map(NodesToDeploy::new).orElseGet(() -> new NodesToDeploy(DeploymentManagementController.fromInitialDeployMode(deployMode)));
        return subscriber.result().thenCompose(deploymentUnit -> this.secured(() -> this.deployment.deployAsync(unitId, version, (DeploymentUnit)deploymentUnit, nodesToDeploy)).whenComplete((unitStatus, throwable) -> {
            tempStorage.close();
            try {
                deploymentUnit.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close subscriber", (Throwable)e);
            }
        }));
    }

    @Override
    public CompletableFuture<Boolean> undeploy(String unitId, String unitVersion) {
        return this.secured(() -> this.deployment.undeployAsync(unitId, Version.parseVersion(unitVersion)));
    }

    @Override
    public CompletableFuture<Collection<UnitStatus>> clusterStatuses(Optional<List<DeploymentStatus>> statuses) {
        return this.secured(() -> this.deployment.clusterStatusesAsync().thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses)));
    }

    @Override
    public CompletableFuture<Collection<UnitStatus>> clusterStatuses(String unitId, Optional<String> version, Optional<List<DeploymentStatus>> statuses) {
        return this.clusterStatuses(unitId, version).thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses));
    }

    private CompletableFuture<List<UnitStatuses>> clusterStatuses(String unitId, Optional<String> version) {
        return this.secured(() -> {
            if (version.isPresent()) {
                Version parsedVersion = Version.parseVersion((String)version.get());
                return this.deployment.clusterStatusAsync(unitId, parsedVersion).thenApply(deploymentStatus -> {
                    if (deploymentStatus != null) {
                        return List.of(UnitStatuses.builder(unitId).append(parsedVersion, (org.apache.ignite3.internal.deployunit.DeploymentStatus)((Object)((Object)deploymentStatus))).build());
                    }
                    return List.of();
                });
            }
            return this.deployment.clusterStatusesAsync(unitId).thenApply(unitStatuses -> unitStatuses != null ? List.of(unitStatuses) : List.of());
        });
    }

    @Override
    public CompletableFuture<Collection<UnitStatus>> nodeStatuses(Optional<List<DeploymentStatus>> statuses) {
        return this.secured(() -> this.deployment.nodeStatusesAsync().thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses)));
    }

    @Override
    public CompletableFuture<Collection<UnitStatus>> nodeStatuses(String unitId, Optional<String> version, Optional<List<DeploymentStatus>> statuses) {
        return this.nodeStatuses(unitId, version).thenApply(statusesList -> DeploymentManagementController.fromUnitStatuses(statusesList, statuses));
    }

    private CompletableFuture<List<UnitStatuses>> nodeStatuses(String unitId, Optional<String> version) {
        return this.secured(() -> {
            if (version.isPresent()) {
                Version parsedVersion = Version.parseVersion((String)version.get());
                return this.deployment.nodeStatusAsync(unitId, parsedVersion).thenApply(deploymentStatus -> {
                    if (deploymentStatus != null) {
                        return List.of(UnitStatuses.builder(unitId).append(parsedVersion, (org.apache.ignite3.internal.deployunit.DeploymentStatus)((Object)((Object)deploymentStatus))).build());
                    }
                    return List.of();
                });
            }
            return this.deployment.nodeStatusesAsync(unitId).thenApply(unitStatuses -> unitStatuses != null ? List.of(unitStatuses) : List.of());
        });
    }

    private static List<UnitStatus> fromUnitStatuses(List<UnitStatuses> statusesList, Optional<List<DeploymentStatus>> deploymentStatuses) {
        return statusesList.stream().map(unitStatuses -> DeploymentManagementController.fromUnitStatuses(unitStatuses, DeploymentManagementController.createStatusFilter(deploymentStatuses))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static UnitStatus fromUnitStatuses(UnitStatuses statuses, Predicate<DeploymentStatus> statusFilter) {
        ArrayList<org.apache.ignite3.internal.rest.api.deployment.UnitVersionStatus> versionStatuses = new ArrayList<org.apache.ignite3.internal.rest.api.deployment.UnitVersionStatus>();
        for (UnitVersionStatus versionStatus : statuses.versionStatuses()) {
            DeploymentStatus deploymentStatus = DeploymentManagementController.fromDeploymentStatus(versionStatus.getStatus());
            if (!statusFilter.test(deploymentStatus)) continue;
            versionStatuses.add(new org.apache.ignite3.internal.rest.api.deployment.UnitVersionStatus(versionStatus.getVersion().render(), deploymentStatus));
        }
        if (versionStatuses.isEmpty()) {
            return null;
        }
        return new UnitStatus(statuses.id(), versionStatuses);
    }

    private static Predicate<DeploymentStatus> createStatusFilter(Optional<List<DeploymentStatus>> statuses) {
        if (statuses.isEmpty() || statuses.get().isEmpty()) {
            return status -> true;
        }
        EnumSet statusesSet = EnumSet.copyOf(statuses.get());
        return statusesSet::contains;
    }

    private static org.apache.ignite3.internal.deployunit.InitialDeployMode fromInitialDeployMode(Optional<InitialDeployMode> mode) {
        if (mode.isEmpty()) {
            return org.apache.ignite3.internal.deployunit.InitialDeployMode.MAJORITY;
        }
        switch (mode.get()) {
            case ALL: {
                return org.apache.ignite3.internal.deployunit.InitialDeployMode.ALL;
            }
        }
        return org.apache.ignite3.internal.deployunit.InitialDeployMode.MAJORITY;
    }

    private static DeploymentStatus fromDeploymentStatus(org.apache.ignite3.internal.deployunit.DeploymentStatus status) {
        return DeploymentStatus.valueOf(status.name());
    }

    @Override
    public CompletableFuture<UnitEntry.UnitFolder> unitStructure(String unitId, String unitVersion) {
        return this.deployment.nodeUnitFileStructure(unitId, Version.parseVersion(unitVersion)).thenApply(DeploymentManagementController::toDto);
    }

    private static UnitEntry.UnitFolder toDto(UnitFolder unitFolder) {
        return new UnitEntry.UnitFolder(unitFolder.name(), unitFolder.children().stream().map(DeploymentManagementController::toDto).collect(Collectors.toList()));
    }

    private static UnitEntry toDto(org.apache.ignite3.internal.deployunit.structure.UnitEntry entry) {
        if (entry instanceof UnitFile) {
            return new UnitEntry.UnitFile(entry.name(), entry.size());
        }
        return DeploymentManagementController.toDto((UnitFolder)entry);
    }

    @Override
    public void cleanResources() {
        this.deployment = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

