/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.license;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="License feature representation.")
public class LicenseFeature {
    @Schema(description="Feature identifier.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String id;
    @Schema(description="Feature name.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String name;

    @JsonCreator
    public LicenseFeature(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name) {
        this.id = id;
        this.name = name;
    }

    private LicenseFeature(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonGetter(value="id")
    public String id() {
        return this.id;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LicenseFeature)) {
            return false;
        }
        LicenseFeature that = (LicenseFeature)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "LicenseFeature{id='" + this.id + "', name='" + this.name + "'}";
    }

    public static final class Builder {
        private String id;
        private String name;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public LicenseFeature build() {
            return new LicenseFeature(this);
        }
    }
}

