/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.dcr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.rest.api.dcr.AuthConfig;
import org.apache.ignite3.internal.rest.api.dcr.ReplicationError;
import org.apache.ignite3.internal.rest.api.dcr.ReplicationStatus;
import org.apache.ignite3.internal.rest.api.dcr.SslConfig;
import org.apache.ignite3.internal.rest.api.dcr.TableStatus;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains detailed information about a specific replication process.")
public class ReplicationInfo {
    @Schema(description="Name of the replication.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String name;
    @Schema(description="List of URLs of the source cluster nodes.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final Set<String> sourceClusterAddresses;
    @Schema(description="Auth config of the connection to the source cluster.")
    @Nullable
    private final AuthConfig authConfig;
    @Schema(description="SSL config of the connection to the source cluster.")
    @Nullable
    private final SslConfig sslConfig;
    @Schema(description="Name of the source cluster.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String sourceClusterName;
    @Schema(description="Name of the target cluster.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String targetClusterName;
    @Schema(description="Name of the worker node on target cluster.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String workerNodeName;
    @Schema(description="Schema name for replication, defaults to 'PUBLIC' if not specified.")
    private final String schemaName;
    @Schema(description="Current status of the replication.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final ReplicationStatus status;
    @Schema(description="Status of the replication per table.")
    @Nullable
    private final List<TableStatus> tableStatuses;
    @Schema(description="List of replication errors encountered.")
    private final List<ReplicationError> errors;
    @Schema(description="Progress of full state transfer. Indicates how much percent of initial data were transferred.")
    private final int fstProgress;

    @JsonCreator
    public ReplicationInfo(@JsonProperty(value="name") String name, @JsonProperty(value="sourceClusterAddresses") Set<String> sourceClusterAddresses, @JsonProperty(value="sourceClusterAuthConfig") @Nullable AuthConfig authConfig, @JsonProperty(value="sourceClusterSslConfig") @Nullable SslConfig sslConfig, @JsonProperty(value="sourceClusterName") String sourceClusterName, @JsonProperty(value="targetClusterName") String targetClusterName, @JsonProperty(value="workerNodeName") String workerNodeName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableStatuses") List<TableStatus> tableStatuses, @JsonProperty(value="status") ReplicationStatus status, @JsonProperty(value="progress") int fstProgress, @JsonProperty(value="errors") List<ReplicationError> errors) {
        this.name = name;
        this.sourceClusterAddresses = sourceClusterAddresses;
        this.authConfig = authConfig;
        this.sslConfig = sslConfig;
        this.sourceClusterName = sourceClusterName;
        this.targetClusterName = targetClusterName;
        this.workerNodeName = workerNodeName;
        this.schemaName = schemaName;
        this.status = status;
        this.fstProgress = fstProgress;
        this.errors = errors;
        this.tableStatuses = tableStatuses;
    }

    @JsonGetter
    public String name() {
        return this.name;
    }

    @JsonGetter
    public Set<String> sourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    @JsonGetter
    @Nullable
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    @JsonGetter
    @Nullable
    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    @JsonGetter
    public String sourceClusterName() {
        return this.sourceClusterName;
    }

    @JsonGetter
    public String targetClusterName() {
        return this.targetClusterName;
    }

    @JsonGetter
    public String workerNodeName() {
        return this.workerNodeName;
    }

    @JsonGetter
    public String schemaName() {
        return this.schemaName;
    }

    @JsonGetter
    public ReplicationStatus status() {
        return this.status;
    }

    @JsonGetter
    public int fstProgress() {
        return this.fstProgress;
    }

    @JsonGetter
    public List<ReplicationError> errors() {
        return this.errors;
    }

    @JsonGetter
    public List<TableStatus> tableStatuses() {
        return this.tableStatuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationInfo that = (ReplicationInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.sourceClusterAddresses, that.sourceClusterAddresses) && Objects.equals(this.authConfig, that.authConfig) && Objects.equals(this.sslConfig, that.sslConfig) && Objects.equals(this.sourceClusterName, that.sourceClusterName) && Objects.equals(this.targetClusterName, that.targetClusterName) && Objects.equals(this.workerNodeName, that.workerNodeName) && Objects.equals(this.schemaName, that.schemaName) && this.status == that.status && Objects.equals(this.errors, that.errors) && Objects.equals(this.fstProgress, that.fstProgress) && Objects.equals(this.tableStatuses, that.tableStatuses);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.sourceClusterName, this.targetClusterName, this.workerNodeName, this.schemaName, this.status, this.fstProgress, this.errors, this.tableStatuses});
    }

    public String toString() {
        return S.toString(this);
    }
}

