/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.cdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.internal.rest.api.cdc.SourceTable;
import org.apache.ignite3.internal.rest.api.cdc.SourceType;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Source", name="Source")
public class Source {
    @Schema(description="Type")
    private final SourceType type;
    @Schema(description="Name")
    private final String name;
    @Schema(description="Parameters")
    private final Map<String, Object> parameters;
    @Schema(description="Tables")
    private final List<SourceTable> tables;

    @JsonCreator
    public Source(@JsonProperty(value="type") SourceType type, @JsonProperty(value="name") String name, @JsonProperty(value="parameters") @Nullable Map<String, Object> parameters, @JsonProperty(value="tables") @Nullable List<SourceTable> tables) {
        this.type = type;
        this.name = name;
        this.parameters = parameters == null ? null : new HashMap<String, Object>(parameters);
        this.tables = tables == null ? null : new ArrayList<SourceTable>(tables);
    }

    @JsonGetter(value="type")
    public SourceType type() {
        return this.type;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="parameters")
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    @JsonGetter(value="tables")
    public List<SourceTable> tables() {
        return this.tables;
    }

    public String toString() {
        return S.toString(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        return this.type == source.type && Objects.equals(this.name, source.name) && Objects.equals(this.parameters, source.parameters) && Objects.equals(this.tables, source.tables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.parameters, this.tables});
    }

    public static SourceBuilder builderFrom(Source source) {
        return new SourceBuilder().type(source.type()).name(source.name()).parameters(source.parameters()).tables(source.tables());
    }

    public static SourceBuilder builder() {
        return new SourceBuilder();
    }

    public static class SourceBuilder {
        private SourceType type;
        private String name;
        private Map<String, Object> parameters;
        private List<SourceTable> tables;

        public SourceBuilder type(SourceType type) {
            this.type = type;
            return this;
        }

        public SourceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SourceBuilder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public SourceBuilder tables(List<SourceTable> tables) {
            this.tables = tables;
            return this;
        }

        public Source build() {
            return new Source(this.type, this.name, this.parameters, this.tables);
        }
    }
}

