/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesTypeInfos;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessageBuilder;

class ZonePartitionIdMessageDeserializer
implements MessageDeserializer<ZonePartitionIdMessage> {
    private final ZonePartitionIdMessageBuilder msg;

    ZonePartitionIdMessageDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.zonePartitionIdMessage();
    }

    @Override
    public Class<ZonePartitionIdMessage> klass() {
        return ZonePartitionIdMessage.class;
    }

    @Override
    public ZonePartitionIdMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ReplicaMessagesTypeInfos.zonePartitionIdMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionId(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("zoneId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.zoneId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ZonePartitionIdMessage.class);
    }
}

