/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesTypeInfos;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessageImpl;

class TablePartitionIdMessageSerializer
implements MessageSerializer<TablePartitionIdMessage> {
    public static final TablePartitionIdMessageSerializer INSTANCE = new TablePartitionIdMessageSerializer();

    private TablePartitionIdMessageSerializer() {
    }

    @Override
    public boolean writeMessage(TablePartitionIdMessage msg, MessageWriter writer) throws MessageMappingException {
        TablePartitionIdMessageImpl message = (TablePartitionIdMessageImpl)msg;
        writer.setMessageTypeInfo(ReplicaMessagesTypeInfos.tablePartitionIdMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("partitionId", message.partitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

