/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.util;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.util.GridUnsafe;

public class VarlenEncoder {
    private static final long LEAST_SIGNIFICANT_BITS_MASK = -128L;

    public static int writeLong(long val, ByteBuffer out) {
        int startPos = out.position();
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(val | 0x80L);
            out.put(b);
            val >>>= 7;
        }
        out.put((byte)val);
        return out.position() - startPos;
    }

    public static int writeLong(long val, long addr) {
        int offset = 0;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(val | 0x80L);
            GridUnsafe.putByte(addr + (long)offset, b);
            val >>>= 7;
            ++offset;
        }
        GridUnsafe.putByte(addr + (long)offset, (byte)val);
        return ++offset;
    }

    public static int sizeInBytes(long val) {
        if (val >= 0L) {
            if (val < 128L) {
                return 1;
            }
            if (val < 16384L) {
                return 2;
            }
            if (val < 0x200000L) {
                return 3;
            }
            if (val < 0x10000000L) {
                return 4;
            }
            if (val < 0x800000000L) {
                return 5;
            }
            if (val < 0x40000000000L) {
                return 6;
            }
            if (val < 0x2000000000000L) {
                return 7;
            }
            if (val < 0x100000000000000L) {
                return 8;
            }
            return 9;
        }
        return 10;
    }

    public static long readLong(ByteBuffer buffer) {
        long val = 0L;
        int shift = 0;
        while (true) {
            byte b = buffer.get();
            val |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                return val;
            }
            shift += 7;
        }
    }
}

