/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

class EntrySearchResult {
    private static final EntrySearchResult NOT_FOUND_RESULT = new EntrySearchResult(null, SearchOutcome.NOT_FOUND);
    private static final EntrySearchResult CONTINUE_SEARCH_RESULT = new EntrySearchResult(null, SearchOutcome.CONTINUE_SEARCH);
    @Nullable
    private final ByteBuffer entryBuffer;
    private final SearchOutcome searchOutcome;

    private EntrySearchResult(@Nullable ByteBuffer entryBuffer, SearchOutcome searchOutcome) {
        this.entryBuffer = entryBuffer;
        this.searchOutcome = searchOutcome;
    }

    ByteBuffer entryBuffer() {
        assert (this.entryBuffer != null) : "Search result is empty";
        return this.entryBuffer;
    }

    SearchOutcome searchOutcome() {
        return this.searchOutcome;
    }

    static EntrySearchResult success(ByteBuffer entryBuffer) {
        return new EntrySearchResult(entryBuffer, SearchOutcome.SUCCESS);
    }

    static EntrySearchResult notFound() {
        return NOT_FOUND_RESULT;
    }

    static EntrySearchResult continueSearch() {
        return CONTINUE_SEARCH_RESULT;
    }

    public String toString() {
        return S.toString(this);
    }

    static enum SearchOutcome {
        SUCCESS,
        NOT_FOUND,
        CONTINUE_SEARCH;

    }
}

