/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.rebalance;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.raft.rebalance.ExceptionUtils;
import org.apache.ignite3.internal.raft.rebalance.RaftCommand;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.apache.ignite3.lang.ErrorGroups;

public class RaftCommandWithRetry {
    private static final IgniteLogger LOG = Loggers.forClass(RaftCommandWithRetry.class);
    private static final long MOVE_RESCHEDULE_DELAY_MILLIS = 100L;
    private final IgniteBusyLock busyLock;
    private final ScheduledExecutorService rebalanceScheduler;

    public RaftCommandWithRetry(IgniteBusyLock busyLock, ScheduledExecutorService rebalanceScheduler) {
        this.busyLock = busyLock;
        this.rebalanceScheduler = rebalanceScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> execute(RaftCommand raftCommand) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = ((CompletableFuture)raftCommand.execute().handle((resp, err) -> {
                if (!this.busyLock.enterBusy()) {
                    throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
                }
                try {
                    if (err != null) {
                        CompletableFuture<Void> completableFuture = this.handleError(raftCommand, (Throwable)err);
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                    return completableFuture;
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            })).thenCompose(Function.identity());
            return completionStage;
        }
        catch (Throwable ex) {
            CompletableFuture<Void> completableFuture = this.handleError(raftCommand, ex);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Void> handleError(RaftCommand raftCommand, Throwable err) {
        if (!ExceptionUtils.recoverable(err)) {
            LOG.debug("Unrecoverable error received during raft command invocation. Stop retrying.", err);
            return CompletableFuture.failedFuture(err);
        }
        LOG.debug("Recoverable error received during raft command invocation, retrying.", err);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.rebalanceScheduler.schedule(() -> this.execute(raftCommand).whenComplete(CompletableFutures.copyStateTo(future)), 100L, TimeUnit.MILLISECONDS);
        return future;
    }
}

